/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.structure.FastGradleSync;
import com.android.tools.idea.gradle.structure.daemon.PsAnalyzerDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsContext
implements Disposable {
    @NotNull
    private final PsProject myProject;
    @NotNull
    private final PsAnalyzerDaemon myAnalyzerDaemon;
    @NotNull
    private final FastGradleSync myGradleSync;
    @NotNull
    private final PsLibraryUpdateCheckerDaemon myLibraryUpdateCheckerDaemon;
    @NotNull
    private final EventDispatcher<ChangeListener> myChangeEventDispatcher;
    @NotNull
    private final EventDispatcher<GradleSyncListener> myGradleSyncEventDispatcher;
    @Nullable
    private String mySelectedModuleName;

    public PsContext(@NotNull PsProject project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/configurables/PsContext", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/configurables/PsContext", "<init>"));
        }
        this.myChangeEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myGradleSyncEventDispatcher = EventDispatcher.create(GradleSyncListener.class);
        this.myProject = project;
        this.myGradleSync = new FastGradleSync();
        this.getMainConfigurable().add(this::requestGradleSync, this);
        this.myLibraryUpdateCheckerDaemon = new PsLibraryUpdateCheckerDaemon(this);
        this.myLibraryUpdateCheckerDaemon.reset();
        this.myLibraryUpdateCheckerDaemon.queueAutomaticUpdateCheck();
        this.myAnalyzerDaemon = new PsAnalyzerDaemon(this, this.myLibraryUpdateCheckerDaemon);
        this.myAnalyzerDaemon.reset();
        this.myProject.forEachModule(this.myAnalyzerDaemon::queueCheck);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private void requestGradleSync() {
        Project project = this.myProject.getResolvedModel();
        ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncStarted(project);
        FastGradleSync.Callback callback = this.myGradleSync.requestProjectSync(project);
        callback.doWhenDone(() -> ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncSucceeded(project));
        callback.doWhenRejected(() -> {
            Throwable failure = callback.getFailure();
            assert (failure != null);
            ((GradleSyncListener)this.myGradleSyncEventDispatcher.getMulticaster()).syncFailed(project, ExceptionUtil.getRootCause((Throwable)failure).getMessage());
        });
    }

    public void add(@NotNull GradleSyncListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/PsContext", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/configurables/PsContext", "add"));
        }
        this.myGradleSyncEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsAnalyzerDaemon getAnalyzerDaemon() {
        PsAnalyzerDaemon psAnalyzerDaemon = this.myAnalyzerDaemon;
        if (psAnalyzerDaemon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/PsContext", "getAnalyzerDaemon"));
        }
        return psAnalyzerDaemon;
    }

    @NotNull
    public PsLibraryUpdateCheckerDaemon getLibraryUpdateCheckerDaemon() {
        PsLibraryUpdateCheckerDaemon psLibraryUpdateCheckerDaemon = this.myLibraryUpdateCheckerDaemon;
        if (psLibraryUpdateCheckerDaemon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/PsContext", "getLibraryUpdateCheckerDaemon"));
        }
        return psLibraryUpdateCheckerDaemon;
    }

    @Nullable
    public String getSelectedModule() {
        return this.mySelectedModuleName;
    }

    public void setSelectedModule(@NotNull String moduleName, @NotNull Object source) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/structure/configurables/PsContext", "setSelectedModule"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/gradle/structure/configurables/PsContext", "setSelectedModule"));
        }
        this.mySelectedModuleName = moduleName;
        ((ChangeListener)this.myChangeEventDispatcher.getMulticaster()).moduleSelectionChanged(this.mySelectedModuleName, source);
    }

    public void add(@NotNull ChangeListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/PsContext", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/structure/configurables/PsContext", "add"));
        }
        this.myChangeEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @NotNull
    public PsProject getProject() {
        PsProject psProject = this.myProject;
        if (psProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/PsContext", "getProject"));
        }
        return psProject;
    }

    public void dispose() {
    }

    @NotNull
    public ProjectStructureConfigurable getMainConfigurable() {
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.myProject.getResolvedModel());
        if (projectStructureConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/PsContext", "getMainConfigurable"));
        }
        return projectStructureConfigurable;
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleSelectionChanged(@NotNull String var1, @NotNull Object var2);
    }
}

