/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ImageComponent;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.collect.ComparisonChain;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ChooseTemplateStep
extends TemplateWizardStep
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChooseTemplateStep.class.getName()));
    private final TemplateChangeListener myTemplateChangeListener;
    private JPanel myPanel;
    protected JBList myTemplateList;
    private ImageComponent myTemplateImage;
    private JLabel myDescription;
    private JLabel myError;
    private int myPreviousSelection = -1;

    public ChooseTemplateStep(TemplateWizardState state, String templateCategory, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable TemplateChangeListener templateChangeListener) {
        this(state, templateCategory, project, module, sidePanelIcon, updateListener, templateChangeListener, null);
    }

    public ChooseTemplateStep(TemplateWizardState state, String templateCategory, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable TemplateChangeListener templateChangeListener, @Nullable Set<String> excluded) {
        super(state, project, module, sidePanelIcon, updateListener);
        this.myTemplateChangeListener = templateChangeListener;
        this.$$$setupUI$$$();
        this.myTemplateList.setBorder(BorderFactory.createLoweredBevelBorder());
        if (templateCategory != null) {
            List<MetadataListItem> templates = ChooseTemplateStep.getTemplateList(state, templateCategory, excluded);
            this.setListData(templates);
            this.validate();
        }
    }

    protected static List<MetadataListItem> getTemplateList(TemplateWizardState state, String templateFolder, @Nullable Set<String> excluded) {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(templateFolder);
        return ChooseTemplateStep.getTemplateList(state, templates, excluded);
    }

    protected static List<MetadataListItem> getTemplateList(TemplateWizardState state, List<File> templateFiles, @Nullable Set<String> excluded) {
        TemplateManager manager = TemplateManager.getInstance();
        ArrayList<MetadataListItem> metadataList = new ArrayList<MetadataListItem>(templateFiles.size());
        for (File template : templateFiles) {
            Boolean isLauncher;
            TemplateMetadata metadata = manager.getTemplateMetadata(template);
            if (metadata == null || !metadata.isSupported() || (isLauncher = (Boolean)state.get("isLauncher")) != null && isLauncher.booleanValue() && metadata.getParameter("isLauncher") == null || excluded != null && excluded.contains(metadata.getTitle())) continue;
            metadataList.add(new MetadataListItem(template, metadata));
        }
        Collections.sort(metadataList);
        return metadataList;
    }

    protected void setListData(List<MetadataListItem> metadataList) {
        this.myTemplateList.setSelectionMode(0);
        this.myTemplateList.setModel((ListModel)JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray(metadataList)));
        if (!metadataList.isEmpty()) {
            this.myTemplateList.setSelectedIndex(0);
        }
        this.myTemplateList.addListSelectionListener((ListSelectionListener)this);
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTemplateList;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.update();
    }

    @Override
    public boolean validate() {
        MetadataListItem templateListItem;
        if (!super.validate()) {
            return false;
        }
        int index = this.myTemplateList.getSelectedIndex();
        this.myTemplateImage.setIcon(null);
        this.setDescriptionHtml("");
        if (index != -1 && (templateListItem = (MetadataListItem)this.myTemplateList.getModel().getElementAt(index)) != null) {
            this.myTemplateState.setTemplateLocation(templateListItem.getTemplateFile());
            Template.convertApisToInt(this.myTemplateState.getParameters());
            String thumb = templateListItem.myMetadata.getThumbnailPath();
            if (thumb != null && !thumb.isEmpty()) {
                File file = new File(this.myTemplateState.myTemplate.getRootPath(), thumb.replace('/', File.separatorChar));
                try {
                    byte[] bytes = Files.toByteArray((File)file);
                    ImageIcon previewImage = new ImageIcon(bytes);
                    this.myTemplateImage.setIcon(previewImage);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            } else {
                this.myTemplateImage.setIcon(AndroidIcons.Wizards.DefaultTemplate);
            }
            this.setDescriptionHtml(templateListItem.getDescription());
            String apiValidationError = ChooseTemplateStep.validateApiLevels(templateListItem.myMetadata, this.myTemplateState);
            if (apiValidationError != null) {
                this.setErrorHtml(apiValidationError);
                return false;
            }
            if (this.myTemplateChangeListener != null && this.myPreviousSelection != index) {
                this.myPreviousSelection = index;
                this.myTemplateChangeListener.templateChanged(templateListItem.toString());
            }
        }
        return true;
    }

    @Nullable
    protected static String validateApiLevels(@Nullable TemplateMetadata metadata, @NotNull TemplateWizardState templateState) {
        if (templateState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/android/tools/idea/npw/ChooseTemplateStep", "validateApiLevels"));
        }
        if (metadata == null || metadata.getCategory() != null && metadata.getCategory().equals("Application")) {
            return null;
        }
        int minSdk = metadata.getMinSdk();
        Integer minApi = (Integer)templateState.get("minApiLevel");
        if (minApi != null && minSdk > minApi) {
            return String.format("The component %s has a minimum SDK level of %d.", metadata.getTitle(), minSdk);
        }
        int minBuildApi = metadata.getMinBuildApi();
        Integer buildApi = (Integer)templateState.get("buildApi");
        if (buildApi != null && minSdk > buildApi) {
            return String.format("The component %s has a minimum build API level of %d.", metadata.getTitle(), minBuildApi);
        }
        return null;
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ChooseTemplateStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ChooseTemplateStep", "getError"));
        }
        return jLabel;
    }

    @Nullable
    public TemplateMetadata getSelectedTemplateMetadata() {
        MetadataListItem templateListItem = (MetadataListItem)this.myTemplateList.getSelectedValue();
        if (templateListItem != null) {
            return templateListItem.myMetadata;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        ImageComponent imageComponent;
        JBList jBList;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myTemplateList = jBList = new JBList();
        jPanel.add((Component)jBList, new GridConstraints(0, 0, 1, 2, 0, 3, 0, 6, new Dimension(150, -1), null, null));
        this.myTemplateImage = imageComponent = new ImageComponent();
        ((Component)((Object)imageComponent)).setEnabled(true);
        jPanel.add((Component)((Object)imageComponent), new GridConstraints(0, 2, 1, 2, 0, 0, 6, 6, new Dimension(256, 256), new Dimension(256, 256), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, new Dimension(-1, 175), null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel2 = new JLabel();
        jLabel2.setVerticalAlignment(1);
        jLabel2.setVerticalTextPosition(1);
        jLabel2.setText("");
        ((Component)jLabel2).setBackground(new Color(-1118482));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myError = jLabel = new JLabel();
        jLabel.setVerticalAlignment(3);
        jLabel.setVerticalTextPosition(3);
        jLabel.setText("");
        ((Component)jLabel).setBackground(new Color(-1118482));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static class MetadataListItem
    implements Comparable<MetadataListItem> {
        private TemplateMetadata myMetadata;
        private final File myTemplate;

        public MetadataListItem(@NotNull File template, @NotNull TemplateMetadata metadata) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/npw/ChooseTemplateStep$MetadataListItem", "<init>"));
            }
            if (metadata == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/npw/ChooseTemplateStep$MetadataListItem", "<init>"));
            }
            this.myTemplate = template;
            this.myMetadata = metadata;
        }

        public String toString() {
            return this.myMetadata.getTitle();
        }

        public File getTemplateFile() {
            return this.myTemplate;
        }

        @Override
        public int compareTo(@NotNull MetadataListItem other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/npw/ChooseTemplateStep$MetadataListItem", "compareTo"));
            }
            return ComparisonChain.start().compare((Comparable)((Object)this.myMetadata.getTitle()), (Comparable)((Object)other.myMetadata.getTitle())).result();
        }

        @Nullable
        public String getDescription() {
            return this.myMetadata.getDescription();
        }
    }

    public static interface TemplateChangeListener {
        public void templateChanged(String var1);
    }
}

