/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.idea.structure.dialog.CounterDisplayConfigurable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidePanel
extends JPanel {
    @NotNull
    private final JBList myList;
    @NotNull
    private final DefaultListModel<Place> myListModel;
    @NotNull
    private final Place.Navigator myNavigator;
    @NotNull
    private final List<Place> myPlaces;
    @NotNull
    private final Map<Integer, String> mySeparatorByIndex;
    @NotNull
    private final Map<Place, Presentation> myPresentationByPlace;
    @NotNull
    private final History myHistory;

    public SidePanel(@NotNull Place.Navigator navigator, @NotNull History history) {
        if (navigator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigator", "com/android/tools/idea/structure/dialog/SidePanel", "<init>"));
        }
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/android/tools/idea/structure/dialog/SidePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myPlaces = Lists.newArrayList();
        this.mySeparatorByIndex = Maps.newHashMap();
        this.myPresentationByPlace = Maps.newHashMap();
        this.myHistory = history;
        this.myNavigator = navigator;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myList.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        ListItemDescriptor<Place> descriptor = new ListItemDescriptor<Place>(){

            public String getTextFor(Place place) {
                return ((Presentation)SidePanel.this.myPresentationByPlace.get(place)).getText();
            }

            public String getTooltipFor(Place place) {
                return this.getTextFor(place);
            }

            public Icon getIconFor(Place place) {
                return EmptyIcon.create((int)16, (int)20);
            }

            public boolean hasSeparatorAboveOf(Place value) {
                return SidePanel.this.getSeparatorAbove(value) != null;
            }

            public String getCaptionAboveOf(Place value) {
                return SidePanel.this.getSeparatorAbove(value);
            }
        };
        this.myList.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)descriptor){
            JPanel myExtraPanel;
            SidePanelCountLabel myCountLabel;
            CellRendererPane myValidationParent;
            {
                this.myValidationParent = new CellRendererPane();
                this.mySeparatorComponent.setCaptionCentered(false);
                SidePanel.this.myList.add((Component)this.myValidationParent);
            }

            protected Color getForeground() {
                return new JBColor((Color)Gray._60, (Color)Gray._140);
            }

            protected SeparatorWithText createSeparator() {
                return new SidePanelSeparator();
            }

            protected void layout() {
                this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                this.myExtraPanel.add((Component)this.myComponent, "Center");
                this.myExtraPanel.add((Component)this.myCountLabel, "East");
                this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CounterDisplayConfigurable configurable;
                int count;
                Place place;
                Object category;
                this.layout();
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Place && (category = (place = (Place)value).getPath("category")) instanceof CounterDisplayConfigurable && (count = (configurable = (CounterDisplayConfigurable)category).getCount()) > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(count > 100 ? "100+" : String.valueOf(count));
                }
                return component;
            }

            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new SidePanelCountLabel();
                JComponent component = super.createItemComponent();
                this.myTextLabel.setForeground((Color)Gray._240);
                this.myTextLabel.setOpaque(true);
                return component;
            }

            protected Color getBackground() {
                return UIUtil.SIDE_PANEL_BACKGROUND;
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList, (boolean)true), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object value = this.myList.getSelectedValue();
            if (value != null) {
                this.myNavigator.navigateTo((Place)value, false);
            }
        });
    }

    @NotNull
    public JBList getList() {
        JBList jBList = this.myList;
        if (jBList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/dialog/SidePanel", "getList"));
        }
        return jBList;
    }

    public void addPlace(@NotNull Place place, @NotNull Presentation presentation) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/structure/dialog/SidePanel", "addPlace"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/android/tools/idea/structure/dialog/SidePanel", "addPlace"));
        }
        this.myListModel.addElement(place);
        this.myPlaces.add(place);
        this.myPresentationByPlace.put(place, presentation);
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.myListModel.clear();
        this.myPlaces.clear();
        this.myPresentationByPlace.clear();
        this.mySeparatorByIndex.clear();
    }

    public void addSeparator(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/structure/dialog/SidePanel", "addSeparator"));
        }
        this.mySeparatorByIndex.put(this.myPlaces.size(), text);
    }

    @Nullable
    public String getSeparatorAbove(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/structure/dialog/SidePanel", "getSeparatorAbove"));
        }
        return this.mySeparatorByIndex.get(this.myPlaces.indexOf(place));
    }

    @NotNull
    public Collection<Place> getPlaces() {
        List<Place> list = this.myPlaces;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/dialog/SidePanel", "getPlaces"));
        }
        return list;
    }

    public void select(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/structure/dialog/SidePanel", "select"));
        }
        this.myList.setSelectedValue((Object)place, true);
    }
}

