/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GradleFilePsiMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project, final @Nullable String supportLibVersionFilter) {
        Project project2;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergeGradleFiles"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergeGradleFiles"));
        }
        source = source.replace("\r", "");
        dest = dest.replace("\r", "");
        boolean projectNeedsCleanup = false;
        if (project != null && !project.isDefault()) {
            project2 = project;
        } else {
            project2 = ((ProjectManagerImpl)ProjectManager.getInstance()).newProject("MergingOnly", "", false, true);
            assert (project2 != null);
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).runStartupActivities();
            projectNeedsCleanup = true;
        }
        final GroovyFile templateBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)source);
        final GroovyFile existingBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)dest);
        String result = (String)new WriteCommandAction<String>(project2, "Merge Gradle Files", new PsiFile[]{existingBuildFile}){

            protected void run(@NotNull Result<String> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/templates/GradleFilePsiMerger$1", "run"));
                }
                GradleFilePsiMerger.mergePsi((PsiElement)templateBuildFile, (PsiElement)existingBuildFile, project2, supportLibVersionFilter);
                PsiElement formatted = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)existingBuildFile);
                result.setResult((Object)formatted.getText());
            }
        }.execute().getResultObject();
        if (projectNeedsCleanup) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        return result;
    }

    private static void mergePsi(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromRoot", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergePsi"));
        }
        if (toRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRoot", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergePsi"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergePsi"));
        }
        HashSet<PsiElement> destinationChildren = new HashSet<PsiElement>();
        destinationChildren.addAll(Arrays.asList(toRoot.getChildren()));
        if (toRoot instanceof GrCallExpression && fromRoot instanceof GrCallExpression) {
            PsiElement[] fromArguments = fromRoot.getLastChild().getChildren();
            PsiElement[] toArguments = toRoot.getLastChild().getChildren();
            if (toArguments.length == 1 && fromArguments.length == 1 && toArguments[0] instanceof GrLiteral && fromArguments[0] instanceof GrLiteral) {
                toArguments[0].replace(fromArguments[0]);
                return;
            }
        }
        for (PsiElement child : fromRoot.getChildren()) {
            PsiElement destination = GradleFilePsiMerger.findEquivalentElement(destinationChildren, child);
            if (destination == null) {
                if (destinationChildren.isEmpty()) {
                    toRoot.add(child);
                    continue;
                }
                toRoot.addBefore(child, toRoot.getLastChild());
                continue;
            }
            if (child.getFirstChild() != null && child.getFirstChild().getText().equalsIgnoreCase("dependencies") && destination.getFirstChild() != null && destination.getFirstChild().getText().equalsIgnoreCase("dependencies")) {
                GradleFilePsiMerger.mergeDependencies(child.getLastChild(), destination.getLastChild(), project, supportLibVersionFilter);
                continue;
            }
            GradleFilePsiMerger.mergePsi(child, destination, project, supportLibVersionFilter);
        }
    }

    private static void mergeDependencies(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromRoot", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergeDependencies"));
        }
        if (toRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRoot", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergeDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/GradleFilePsiMerger", "mergeDependencies"));
        }
        HashMap dependencies = Maps.newHashMap();
        ArrayList unparsedDependencies = Lists.newArrayList();
        GradleFilePsiMerger.pullDependenciesIntoMap(toRoot, dependencies, null);
        GradleFilePsiMerger.pullDependenciesIntoMap(fromRoot, dependencies, unparsedDependencies);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        ImmutableList configurations = GradleFileMergers.CONFIGURATION_ORDERING.immutableSortedCopy(dependencies.keySet());
        AndroidSdkData sdk = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdk != null) {
            for (String configurationName : configurations) {
                List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)((Multimap)dependencies.get(configurationName)), supportLibVersionFilter, sdk);
                for (GradleCoordinate dependency : resolved) {
                    GrStatement dependencyElement = factory.createStatementFromText((CharSequence)String.format("%s '%s'\n", configurationName, dependency.toString()));
                    toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
                }
            }
        }
        for (String dependency : unparsedDependencies) {
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)dependency);
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
    }

    private static boolean pullDependenciesIntoMap(@NotNull PsiElement root, @NotNull Map<String, Multimap<String, GradleCoordinate>> allConfigurations, @Nullable List<String> unparsedDependencies) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/templates/GradleFilePsiMerger", "pullDependenciesIntoMap"));
        }
        if (allConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allConfigurations", "com/android/tools/idea/templates/GradleFilePsiMerger", "pullDependenciesIntoMap"));
        }
        boolean wasMapUpdated = false;
        for (PsiElement existingElem : root.getChildren()) {
            String coordinateText;
            GradleCoordinate coordinate;
            Object value;
            PsiElement reference;
            if (!(existingElem instanceof GrCall) || !((reference = existingElem.getFirstChild()) instanceof GrReferenceExpression)) continue;
            String configurationName = reference.getText();
            boolean parsed = false;
            GrCall call = (GrCall)existingElem;
            GrArgumentList arguments = call.getArgumentList();
            if (arguments == null || call.getClosureArguments().length != 0) continue;
            GrExpression[] expressionArguments = arguments.getExpressionArguments();
            if (expressionArguments.length == 1 && expressionArguments[0] instanceof GrLiteral && (value = ((GrLiteral)expressionArguments[0]).getValue()) instanceof String && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = (String)value))) != null) {
                parsed = true;
                LinkedListMultimap map = allConfigurations.get(configurationName);
                if (map == null) {
                    map = LinkedListMultimap.create();
                    allConfigurations.put(configurationName, (Multimap<String, GradleCoordinate>)map);
                }
                if (!map.get((Object)coordinate.getId()).contains(coordinate)) {
                    map.put((Object)coordinate.getId(), (Object)coordinate);
                    existingElem.delete();
                    wasMapUpdated = true;
                }
            }
            if (parsed || unparsedDependencies == null) continue;
            unparsedDependencies.add(existingElem.getText());
        }
        return wasMapUpdated;
    }

    @Nullable
    private static PsiElement findEquivalentElement(@NotNull Collection<PsiElement> collection, @NotNull PsiElement element) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/android/tools/idea/templates/GradleFilePsiMerger", "findEquivalentElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/templates/GradleFilePsiMerger", "findEquivalentElement"));
        }
        ArrayList matchingItems = Lists.newArrayListWithExpectedSize((int)1);
        for (PsiElement item : collection) {
            if (item.getText() != null && item.getText().equals(element.getText())) {
                return item;
            }
            if (item.getFirstChild() == null || element.getFirstChild() == null || !item.getFirstChild().getText().equals(element.getFirstChild().getText())) continue;
            matchingItems.add(item);
        }
        if (matchingItems.size() == 1) {
            return (PsiElement)matchingItems.get(0);
        }
        return null;
    }
}

