/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.xml.XmlAttributeDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlIdPropertyItem
extends NlPropertyItem {
    private static final int REFACTOR_ASK = 0;
    private static final int REFACTOR_NO = 1;
    private static final int REFACTOR_YES = 2;
    private static int ourRefactoringChoice = 0;

    protected NlIdPropertyItem(@NotNull List<NlComponent> components, @NotNull XmlAttributeDescriptor descriptor, @Nullable AttributeDefinition attributeDefinition) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlIdPropertyItem", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/uibuilder/property/NlIdPropertyItem", "<init>"));
        }
        super(components, descriptor, "http://schemas.android.com/apk/res/android", attributeDefinition);
    }

    @Override
    @Nullable
    public String getValue() {
        return NlIdPropertyItem.stripIdPrefix(super.getValue());
    }

    private static String stripIdPrefix(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return id;
    }

    @Override
    @NotNull
    public String resolveValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/uibuilder/property/NlIdPropertyItem", "resolveValue"));
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlIdPropertyItem", "resolveValue"));
        }
        return string;
    }

    @Override
    public void setValue(Object value) {
        XmlAttribute attribute;
        String newId = value != null ? NlIdPropertyItem.stripIdPrefix(value.toString()) : "";
        String oldId = this.getValue();
        XmlTag tag = this.getTag();
        if (ourRefactoringChoice != 1 && oldId != null && !oldId.isEmpty() && !newId.isEmpty() && !oldId.equals(newId) && tag != null && tag.isValid() && (attribute = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) != null) {
            Module module = this.getModel().getModule();
            Project project = module.getProject();
            XmlAttributeValue valueElement = attribute.getValueElement();
            if (valueElement != null && valueElement.isValid()) {
                ValueResourceElementWrapper wrapper = new ValueResourceElementWrapper(valueElement);
                RenameProcessor processor = new RenameProcessor(project, (PsiElement)wrapper, "@+id/" + newId, false, false);
                processor.setPreviewUsages(false);
                UsageInfo[] usages = processor.findUsages();
                if (usages.length > 0) {
                    int choice = ourRefactoringChoice;
                    if (choice == 0) {
                        DialogBuilder builder = new DialogBuilder(project);
                        builder.setTitle("Update Usages?");
                        JPanel panel = new JPanel(new BorderLayout());
                        JLabel label = new JLabel("<html>Update usages as well?<br>This will update all XML references and Java R field references.<br><br></html>");
                        panel.add((Component)label, "Center");
                        JBCheckBox checkBox = new JBCheckBox("Don't ask again during this session");
                        panel.add((Component)checkBox, "South");
                        builder.setCenterPanel((JComponent)panel);
                        builder.setDimensionServiceKey("idPropertyDimension");
                        builder.removeAllActions();
                        DialogBuilder.CustomizableAction yesAction = builder.addOkAction();
                        yesAction.setText(Messages.YES_BUTTON);
                        builder.addActionDescriptor(dialogWrapper -> new AbstractAction(Messages.NO_BUTTON){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                dialogWrapper.close(2);
                            }
                        });
                        builder.addCancelAction();
                        int exitCode = builder.show();
                        choice = exitCode == 0 ? 2 : (exitCode == 2 ? 1 : ourRefactoringChoice);
                        int n = ourRefactoringChoice = checkBox.isSelected() ? choice : 0;
                        if (exitCode == 1) {
                            return;
                        }
                    }
                    if (choice == 2) {
                        processor.run();
                        return;
                    }
                }
            }
        }
        super.setValue(value != null ? "@+id/" + value : null);
    }
}

