/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesSorter;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableModel;
import com.android.util.PropertiesMap;
import com.google.common.collect.Table;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesPanel
extends JPanel
implements ViewAllPropertiesAction.Model {
    private static final String CARD_ADVANCED = "table";
    private static final String CARD_DEFAULT = "default";
    private final PTable myTable;
    private final JPanel myTablePanel;
    private final PTableModel myModel;
    private final InspectorPanel myInspectorPanel;
    private final JPanel myCardPanel;
    private List<NlComponent> myComponents;
    private List<NlPropertyItem> myProperties;
    private boolean myAllPropertiesPanelVisible;

    public NlPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.setOpaque(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myModel = new PTableModel();
        this.myTable = new PTable(this.myModel);
        this.myTable.setEditorProvider(NlPropertyEditors.getInstance(project));
        this.myTable.getEmptyText().setText("No selected component");
        JComponent fewerPropertiesLink = this.createViewAllPropertiesLinkPanel(false);
        fewerPropertiesLink.setBorder(BorderFactory.createEmptyBorder(8, 4, 2, 0));
        this.myTablePanel = new JPanel(new BorderLayout());
        this.myTablePanel.setVisible(false);
        this.myTablePanel.setBackground(this.myTable.getBackground());
        this.myTablePanel.add((Component)((Object)this.myTable), "North");
        this.myTablePanel.add((Component)fewerPropertiesLink, "South");
        this.myInspectorPanel = new InspectorPanel(project, this.createViewAllPropertiesLinkPanel(true));
        this.myCardPanel = new JPanel((LayoutManager)new JBCardLayout());
        this.add((Component)this.myCardPanel, "Center");
        this.myCardPanel.add(CARD_DEFAULT, ScrollPaneFactory.createScrollPane((Component)this.myInspectorPanel, (int)20, (int)31));
        this.myCardPanel.add(CARD_ADVANCED, ScrollPaneFactory.createScrollPane((Component)this.myTablePanel));
        this.myComponents = Collections.emptyList();
        this.myProperties = Collections.emptyList();
    }

    public void setItems(@NotNull List<NlComponent> components, @NotNull Table<String, String, NlPropertyItem> properties, @NotNull NlPropertiesManager propertiesManager) {
        List<PTableItem> groupedProperties;
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        this.myComponents = components;
        this.myProperties = NlPropertiesPanel.extractPropertiesForTable(properties);
        if (components.isEmpty()) {
            groupedProperties = Collections.emptyList();
        } else {
            List<NlPropertyItem> sortedProperties = new NlPropertiesSorter().sort(this.myProperties, components);
            groupedProperties = new NlPropertiesGrouper().group(sortedProperties, components);
        }
        if (this.myTable.isEditing()) {
            this.myTable.removeEditor();
        }
        this.myModel.setItems(groupedProperties);
        this.updateDefaultProperties(propertiesManager);
        this.myInspectorPanel.setComponent(components, properties, propertiesManager);
        this.myTablePanel.setVisible(!groupedProperties.isEmpty());
    }

    @NotNull
    private static List<NlPropertyItem> extractPropertiesForTable(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "extractPropertiesForTable"));
        }
        Map androidProperties = properties.row((Object)"http://schemas.android.com/apk/res/android");
        Map autoProperties = properties.row((Object)"http://schemas.android.com/apk/res-auto");
        Map designProperties = properties.row((Object)"http://schemas.android.com/tools");
        Map bareProperties = properties.row((Object)"");
        ArrayList<NlPropertyItem> result = new ArrayList<NlPropertyItem>(properties.size());
        result.addAll(autoProperties.values());
        for (Map.Entry entry : androidProperties.entrySet()) {
            if (autoProperties.containsKey(entry.getKey())) continue;
            result.add((NlPropertyItem)entry.getValue());
        }
        result.addAll(designProperties.values());
        result.addAll(bareProperties.values());
        ArrayList<NlPropertyItem> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "extractPropertiesForTable"));
        }
        return arrayList;
    }

    public void modelRendered(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "modelRendered"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "lambda$modelRendered$0"));
            }
            this.updateDefaultProperties(propertiesManager);
            this.myInspectorPanel.refresh();
        });
    }

    private void updateDefaultProperties(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "updateDefaultProperties"));
        }
        if (this.myComponents.isEmpty() || this.myProperties.isEmpty()) {
            return;
        }
        PropertiesMap defaultValues = propertiesManager.getDefaultProperties(this.myComponents);
        if (defaultValues.isEmpty()) {
            return;
        }
        for (NlPropertyItem property : this.myProperties) {
            property.setDefaultValue(NlPropertiesPanel.getDefaultProperty(defaultValues, property));
        }
    }

    @Nullable
    private static PropertiesMap.Property getDefaultProperty(@NotNull PropertiesMap defaultValues, @NotNull NlProperty property) {
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "getDefaultProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "getDefaultProperty"));
        }
        if ("http://schemas.android.com/apk/res/android".equals(property.getNamespace())) {
            PropertiesMap.Property defaultValue = (PropertiesMap.Property)defaultValues.get((Object)("android:" + property.getName()));
            if (defaultValue != null) {
                return defaultValue;
            }
            return (PropertiesMap.Property)defaultValues.get((Object)("@android:" + property.getName()));
        }
        return (PropertiesMap.Property)defaultValues.get((Object)property.getName());
    }

    @NotNull
    private JComponent createViewAllPropertiesLinkPanel(boolean viewAllProperties) {
        HyperlinkLabel textLink = new HyperlinkLabel();
        textLink.setHyperlinkText(viewAllProperties ? "View all properties" : "View fewer properties");
        textLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        HyperlinkLabel iconLink = new HyperlinkLabel();
        iconLink.setIcon(AndroidIcons.NeleIcons.ToggleProperties);
        iconLink.setUseIconAsLink(true);
        iconLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.setOpaque(false);
        linkPanel.add((Component)textLink);
        linkPanel.add((Component)iconLink);
        JPanel jPanel = linkPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "createViewAllPropertiesLinkPanel"));
        }
        return jPanel;
    }

    private void setAllPropertiesPanelVisible(@NotNull HyperlinkEvent event, boolean viewAllProperties) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setAllPropertiesPanelVisible"));
        }
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setAllPropertiesPanelVisible(viewAllProperties);
        }
    }

    @Override
    public boolean isAllPropertiesPanelVisible() {
        return this.myAllPropertiesPanelVisible;
    }

    @Override
    public void setAllPropertiesPanelVisible(boolean viewAllProperties) {
        this.myAllPropertiesPanelVisible = viewAllProperties;
        JBCardLayout cardLayout = (JBCardLayout)this.myCardPanel.getLayout();
        String name = viewAllProperties ? CARD_ADVANCED : CARD_DEFAULT;
        cardLayout.swipe((Container)this.myCardPanel, name, JBCardLayout.SwipeDirection.AUTO);
    }

    public boolean activatePreferredEditor(boolean afterload) {
        if (this.isAllPropertiesPanelVisible()) {
            this.setAllPropertiesPanelVisible(false);
        }
        return this.myInspectorPanel.activatePreferredEditor(afterload);
    }
}

