/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitRebaseUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUpdater.class.getName());
    private final GitRebaser myRebaser;

    public GitRebaseUpdater(@NotNull Project project, @NotNull Git git, @NotNull VirtualFile root, @NotNull Map<VirtualFile, GitBranchPair> trackedBranches, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        if (trackedBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedBranches", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/update/GitRebaseUpdater", "<init>"));
        }
        super(project, git, root, trackedBranches, progressIndicator, updatedFiles);
        this.myRebaser = new GitRebaser(this.myProject, git, this.myProgressIndicator);
    }

    @Override
    public boolean isSaveNeeded() {
        return true;
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        LOG.info("doUpdate ");
        String remoteBranch = this.getRemoteBranchToMerge();
        List<String> params = Collections.singletonList(remoteBranch);
        GitUpdateResult gitUpdateResult = this.myRebaser.rebase(this.myRoot, params, new Runnable(){

            @Override
            public void run() {
                GitRebaseUpdater.this.cancel();
            }
        }, null);
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseUpdater", "doUpdate"));
        }
        return gitUpdateResult;
    }

    @NotNull
    private String getRemoteBranchToMerge() {
        GitBranchPair gitBranchPair = (GitBranchPair)this.myTrackedBranches.get(this.myRoot);
        GitRemoteBranch dest = gitBranchPair.getDest();
        LOG.assertTrue(dest != null, (Object)String.format("Destination branch is null for source branch %s in %s", gitBranchPair.getBranch().getName(), this.myRoot));
        String string = dest.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitRebaseUpdater", "getRemoteBranchToMerge"));
        }
        return string;
    }

    public void cancel() {
        this.myRebaser.abortRebase(this.myRoot);
        this.myProgressIndicator.setText2("Refreshing files for the root " + this.myRoot.getPath());
        this.myRoot.refresh(false, true);
    }

    public String toString() {
        return "Rebase updater";
    }

    public boolean fastForwardMerge() {
        LOG.info("Trying fast-forward merge for " + this.myRoot);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.myRoot);
        if (repository == null) {
            LOG.error("Repository is null for " + this.myRoot);
            return false;
        }
        try {
            this.markStart(this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark start for repository " + this.myRoot, (Throwable)e);
            return false;
        }
        GitCommandResult result = this.myGit.merge(repository, this.getRemoteBranchToMerge(), Collections.singletonList("--ff-only"), new GitLineHandlerListener[0]);
        try {
            this.markEnd(this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark end for repository " + this.myRoot, (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Couldn't collect the updated files info", String.format("Update of %s was successful, but we couldn't collect the updated changes because of an error", this.myRoot), null);
        }
        return result.success();
    }
}

