/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.ResourceContext;
import com.google.common.annotations.Beta;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlContext
extends ResourceContext {
    static final String SUPPRESS_COMMENT_PREFIX = "<!--suppress ";
    private final XmlParser mParser;
    public Document document;

    public XmlContext(LintDriver driver, Project project, Project main, File file, ResourceFolderType folderType, XmlParser parser) {
        super(driver, project, main, file, folderType);
        this.mParser = parser;
    }

    public Location getLocation(Node node) {
        return this.mParser.getLocation(this, node);
    }

    public Location getNameLocation(Node node) {
        return this.mParser.getNameLocation(this, node);
    }

    public Location getValueLocation(Attr node) {
        return this.mParser.getValueLocation(this, node);
    }

    public Location getLocation(Node textNode, int begin, int end) {
        assert (textNode.getNodeType() == 3);
        return this.mParser.getLocation(this, textNode, begin, end);
    }

    public XmlParser getParser() {
        return this.mParser;
    }

    public void report(Issue issue, Node scope, Location location, String message2) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message2);
    }

    @Deprecated
    public void report(Issue issue, Node scope, Location location, String message2, Object data) {
        this.report(issue, scope, location, message2);
    }

    @Override
    public void report(Issue issue, Location location, String message2) {
        if (this.document != null && this.mDriver.isSuppressed(this, issue, this.document)) {
            return;
        }
        super.report(issue, location, message2);
    }

    @Override
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isSuppressedWithComment(Node node, Issue issue) {
        String contents = this.getContents();
        assert (contents != null);
        int start = this.mParser.getNodeStartOffset(this, node);
        if (start != -1) {
            return this.isSuppressedWithComment(start, issue);
        }
        return false;
    }

    public Location.Handle createLocationHandle(Node node) {
        return this.mParser.createLocationHandle(this, node);
    }
}

