/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.platform.JvmBuiltIns;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatform;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "()V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "defaultImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getDefaultImports", "()Ljava/util/List;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "kotlin-compiler"})
public final class JvmPlatform
extends TargetPlatform {
    @NotNull
    private static final List<ImportPath> defaultImports;
    @NotNull
    private static final PlatformConfigurator platformConfigurator;
    public static final JvmPlatform INSTANCE;

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        return defaultImports;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return JvmBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    private JvmPlatform() {
        super("JVM");
        INSTANCE = this;
        ArrayList<ImportPath> arrayList = new ArrayList<ImportPath>();
        ArrayList<ImportPath> $receiver = arrayList;
        $receiver.add(new ImportPath("java.lang.*"));
        $receiver.add(new ImportPath("kotlin.*"));
        $receiver.add(new ImportPath("kotlin.annotation.*"));
        $receiver.add(new ImportPath("kotlin.jvm.*"));
        $receiver.add(new ImportPath("kotlin.collections.*"));
        $receiver.add(new ImportPath("kotlin.ranges.*"));
        $receiver.add(new ImportPath("kotlin.sequences.*"));
        $receiver.add(new ImportPath("kotlin.text.*"));
        $receiver.add(new ImportPath("kotlin.io.*"));
        Function1<MemberScope, Unit> addAllClassifiersFromScope$ = new Function1<MemberScope, Unit>($receiver){
            final /* synthetic */ ArrayList receiver$0;

            public final void invoke(@NotNull MemberScope scope) {
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                for (DeclarationDescriptor descriptor2 : scope.getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER())) {
                    this.receiver$0.add(new ImportPath(DescriptorUtils.getFqNameSafe(descriptor2), false));
                }
            }
            {
                this.receiver$0 = arrayList;
                super(1);
            }
        };
        KotlinBuiltIns builtIns = INSTANCE.getBuiltIns();
        for (BuiltInsPackageFragment builtinPackageFragment : builtIns.getBuiltInsPackageFragments()) {
            addAllClassifiersFromScope$.invoke((MemberScope)builtinPackageFragment.getMemberScope());
        }
        defaultImports = arrayList;
        platformConfigurator = JvmPlatformConfigurator.INSTANCE;
    }

    static {
        new JvmPlatform();
    }
}

