/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class RemoveManagedFilesAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        if (!super.isAvailable(e)) {
            return false;
        }
        return MavenActionUtil.getMavenProjectsFiles(e.getDataContext()).size() > 0;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/RemoveManagedFilesAction", "actionPerformed"));
        }
        DataContext context = e.getDataContext();
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        if (projectsManager == null) {
            return;
        }
        List<VirtualFile> selectedFiles = MavenActionUtil.getMavenProjectsFiles(context);
        ArrayList<VirtualFile> removableFiles = new ArrayList<VirtualFile>();
        for (VirtualFile pomXml : selectedFiles) {
            if (projectsManager.isManagedFile(pomXml)) {
                removableFiles.add(pomXml);
                continue;
            }
            RemoveManagedFilesAction.notifyUserIfNeeded(context, projectsManager, selectedFiles, pomXml);
        }
        projectsManager.removeManagedFiles(removableFiles);
    }

    private static void notifyUserIfNeeded(DataContext context, MavenProjectsManager projectsManager, List<VirtualFile> selectedFiles, VirtualFile pomXml) {
        MavenProject mavenProject = projectsManager.findProject(pomXml);
        assert (mavenProject != null);
        MavenProject aggregator = projectsManager.findAggregator(mavenProject);
        while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
            aggregator = projectsManager.findAggregator(aggregator);
        }
        if (aggregator != null && !selectedFiles.contains(aggregator.getFile())) {
            RemoveManagedFilesAction.notifyUser(context, mavenProject, aggregator);
        }
    }

    private static void notifyUser(DataContext context, MavenProject mavenProject, MavenProject aggregator) {
        String aggregatorDescription = " (" + aggregator.getMavenId().getDisplayString() + ')';
        Notification notification = new Notification("Maven", "Failed to remove project", "You can not remove " + mavenProject.getName() + " because it's imported as a module of another project" + aggregatorDescription + ". You can use Ignore action. Only root project can be removed.", NotificationType.ERROR);
        notification.setImportant(true);
        notification.notify(MavenActionUtil.getProject(context));
    }
}

