/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;

public class GradleExecutionWorkspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final List<GradleBuildParticipant> myBuildParticipants = ContainerUtil.newArrayList();

    public void addBuildParticipant(GradleBuildParticipant participant) {
        this.myBuildParticipants.add(participant);
    }

    @NotNull
    public List<GradleBuildParticipant> getBuildParticipants() {
        List<GradleBuildParticipant> list = Collections.unmodifiableList(this.myBuildParticipants);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleExecutionWorkspace", "getBuildParticipants"));
        }
        return list;
    }

    @Nullable
    public ModuleData findModuleDataByArtifacts(Collection<File> artifacts) {
        GradleBuildParticipant buildParticipant;
        ModuleData result = null;
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByArtifacts(artifacts)) == null) {
        }
        return result;
    }

    public ModuleData findModuleDataByName(String moduleName) {
        GradleBuildParticipant buildParticipant;
        ModuleData result = null;
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByName(moduleName)) == null) {
        }
        return result;
    }
}

