/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleMainPanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.application.options.codeStyle.CodeStyleSettingsPanelFactory;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesConfigurable
extends SearchableConfigurable.Parent.Abstract
implements OptionsContainingConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel {
    private CodeStyleSchemesPanel myRootSchemesPanel;
    private CodeStyleSchemesModel myModel;
    private List<CodeStyleConfigurableWrapper> myPanels;
    private boolean myResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertCompleted = false;
    private boolean myApplyCompleted = false;
    private final Project myProject;

    public CodeStyleSchemesConfigurable(Project project2) {
        this.myProject = project2;
    }

    public JComponent createComponent() {
        this.myModel = this.ensureModel();
        return this.myPanels == null || this.myPanels.isEmpty() ? null : this.myPanels.get(0).createComponent();
    }

    public boolean hasOwnContent() {
        return true;
    }

    public void disposeUIResources() {
        if (this.myPanels != null) {
            try {
                super.disposeUIResources();
                for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                    panel2.disposeUIResources();
                }
            }
            finally {
                this.myPanels = null;
                this.myModel = null;
                this.myRootSchemesPanel = null;
                this.myResetCompleted = false;
                this.myRevertCompleted = false;
                this.myApplyCompleted = false;
                this.myInitResetInvoked = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myResetCompleted) return;
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revert();
        }
    }

    private void resetImpl() {
        if (this.myModel != null) {
            this.myModel.reset();
        }
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                panel2.resetPanel();
            }
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myResetCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myResetCompleted = true;
            }
        }
    }

    public void revert() {
        if (this.myModel.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertCompleted = false;
        }
        if (!this.myRevertCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertCompleted = true;
            }
        }
    }

    private boolean isSomeSchemeModified() {
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                if (!panel2.isPanelModified()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply() throws ConfigurationException {
        if (!this.myApplyCompleted) {
            try {
                super.apply();
                for (CodeStyleScheme scheme2 : new ArrayList<CodeStyleScheme>(this.myModel.getSchemes())) {
                    boolean isDefaultModified = CodeStyleSchemesModel.cannotBeModified(scheme2) && this.isSchemeModified(scheme2);
                    if (!isDefaultModified) continue;
                    CodeStyleScheme newscheme = this.myModel.createNewScheme(null, scheme2);
                    CodeStyleSettings settingsWillBeModified = scheme2.getCodeStyleSettings();
                    CodeStyleSettings notModifiedSettings = settingsWillBeModified.clone();
                    ((CodeStyleSchemeImpl)scheme2).setCodeStyleSettings(notModifiedSettings);
                    ((CodeStyleSchemeImpl)newscheme).setCodeStyleSettings(settingsWillBeModified);
                    this.myModel.addScheme(newscheme, false);
                    if (this.myModel.getSelectedScheme() != scheme2) continue;
                    this.myModel.selectScheme(newscheme, this);
                }
                for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                    panel2.applyPanel();
                }
                this.myModel.apply();
                EditorFactory.getInstance().refreshAllEditors();
            }
            finally {
                this.myApplyCompleted = true;
            }
        }
    }

    private boolean isSchemeModified(CodeStyleScheme scheme2) {
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            if (!panel2.isPanelModified(scheme2)) continue;
            return true;
        }
        return false;
    }

    protected Configurable[] buildConfigurables() {
        this.myPanels = new ArrayList<CodeStyleConfigurableWrapper>();
        List<Object> providers = Arrays.asList(Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME));
        Collections.sort(providers, (p1, p2) -> {
            String name2;
            if (!p1.getPriority().equals((Object)p2.getPriority())) {
                return p1.getPriority().compareTo((Enum)p2.getPriority());
            }
            String name1 = p1.getConfigurableDisplayName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = p2.getConfigurableDisplayName()) == null) {
                name2 = "";
            }
            return name1.compareToIgnoreCase(name2);
        });
        for (final CodeStyleSettingsProvider codeStyleSettingsProvider : providers) {
            if (!codeStyleSettingsProvider.hasSettingsPage()) continue;
            this.myPanels.add(new CodeStyleConfigurableWrapper(codeStyleSettingsProvider, new CodeStyleSettingsPanelFactory(){

                @Override
                public NewCodeStyleSettingsPanel createPanel(CodeStyleScheme scheme2) {
                    return new NewCodeStyleSettingsPanel(codeStyleSettingsProvider.createSettingsPage(scheme2.getCodeStyleSettings(), CodeStyleSchemesConfigurable.this.ensureModel().getCloneSettings(scheme2)));
                }
            }));
        }
        int size = this.myPanels.size();
        Configurable[] configurableArray = new Configurable[size > 0 ? size - 1 : 0];
        for (int i2 = 0; i2 < configurableArray.length; ++i2) {
            configurableArray[i2] = (Configurable)this.myPanels.get(i2 + 1);
        }
        return configurableArray;
    }

    private CodeStyleSchemesModel ensureModel() {
        if (this.myModel == null) {
            this.myModel = new CodeStyleSchemesModel(this.myProject);
            this.myRootSchemesPanel = new CodeStyleSchemesPanel(this.myModel);
            this.myModel.addListener(new CodeStyleSettingsListener(){

                @Override
                public void currentSchemeChanged(Object source) {
                    if (source != CodeStyleSchemesConfigurable.this.myRootSchemesPanel) {
                        CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                    }
                }

                @Override
                public void schemeListChanged() {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.resetSchemesCombo();
                }

                @Override
                public void currentSettingsChanged() {
                }

                @Override
                public void usePerProjectSettingsOptionChanged() {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.usePerProjectSettingsOptionChanged();
                }

                @Override
                public void schemeChanged(CodeStyleScheme scheme2) {
                    if (scheme2 == CodeStyleSchemesConfigurable.this.myModel.getSelectedScheme()) {
                        CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                    }
                }
            });
        }
        return this.myModel;
    }

    public String getDisplayName() {
        return "Code Style";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle";
    }

    public void selectPage(Class pageToSelect) {
    }

    public boolean isModified() {
        if (this.myModel != null) {
            if (this.myPanels != null && this.myPanels.size() > 0 && this.myPanels.get(0).isModified()) {
                return true;
            }
            boolean schemeListModified = this.myModel.isSchemeListModified();
            if (schemeListModified) {
                this.myApplyCompleted = false;
                this.myRevertCompleted = false;
            }
            return schemeListModified;
        }
        return false;
    }

    @NotNull
    public String getId() {
        if ("preferences.sourceCode" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleSchemesConfigurable", "getId"));
        }
        return "preferences.sourceCode";
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> result2 = new HashSet<String>();
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            result2.addAll(panel2.processListOptions());
        }
        return result2;
    }

    public boolean isProjectLevel() {
        return this.myModel != null && this.myModel.isUsePerProjectSettings();
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String name) {
        if (this.myPanels == null) {
            this.buildConfigurables();
        }
        return this.myPanels.stream().filter(panel2 -> panel2.getDisplayName().equals(name)).findFirst().orElse(null);
    }

    private class CodeStyleConfigurableWrapper
    implements SearchableConfigurable,
    Configurable.NoMargin,
    Configurable.NoScroll,
    OptionsContainingConfigurable {
        private boolean myInitialResetInvoked;
        private CodeStyleMainPanel myPanel;
        private final CodeStyleSettingsProvider myProvider;
        private final CodeStyleSettingsPanelFactory myFactory;

        public CodeStyleConfigurableWrapper(@NotNull CodeStyleSettingsProvider provider, CodeStyleSettingsPanelFactory factory) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/application/options/CodeStyleSchemesConfigurable$CodeStyleConfigurableWrapper", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/application/options/CodeStyleSchemesConfigurable$CodeStyleConfigurableWrapper", "<init>"));
            }
            this.myProvider = provider;
            this.myFactory = factory;
            this.myInitialResetInvoked = false;
        }

        @Nls
        public String getDisplayName() {
            String displayName = this.myProvider.getConfigurableDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return this.myPanel != null ? this.myPanel.getDisplayName() : null;
        }

        public String getHelpTopic() {
            return this.myPanel != null ? this.myPanel.getHelpTopic() : null;
        }

        public JComponent createComponent() {
            if (this.myPanel == null) {
                this.myPanel = new CodeStyleMainPanel(CodeStyleSchemesConfigurable.this.ensureModel(), this.myFactory);
            }
            return this.myPanel;
        }

        public boolean isModified() {
            if (this.myPanel != null) {
                boolean someSchemeModified = this.myPanel.isModified();
                if (someSchemeModified) {
                    CodeStyleSchemesConfigurable.this.myApplyCompleted = false;
                    CodeStyleSchemesConfigurable.this.myRevertCompleted = false;
                }
                return someSchemeModified;
            }
            return false;
        }

        public void apply() throws ConfigurationException {
            CodeStyleSchemesConfigurable.this.apply();
        }

        public void resetPanel() {
            if (this.myPanel != null) {
                this.myPanel.reset();
            }
        }

        public String toString() {
            return this.myProvider.getClass().getName();
        }

        public void reset() {
            if (!this.myInitialResetInvoked) {
                try {
                    CodeStyleSchemesConfigurable.this.resetFromChild();
                }
                finally {
                    this.myInitialResetInvoked = true;
                }
            } else {
                CodeStyleSchemesConfigurable.this.revert();
            }
        }

        @NotNull
        public String getId() {
            String string = "preferences.sourceCode." + this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleSchemesConfigurable$CodeStyleConfigurableWrapper", "getId"));
            }
            return string;
        }

        public void disposeUIResources() {
            if (this.myPanel != null) {
                this.myPanel.disposeUIResources();
            }
        }

        public boolean isPanelModified(CodeStyleScheme scheme2) {
            return this.myPanel != null && this.myPanel.isModified(scheme2);
        }

        public boolean isPanelModified() {
            return this.myPanel != null && this.myPanel.isModified();
        }

        public void applyPanel() throws ConfigurationException {
            if (this.myPanel != null) {
                this.myPanel.apply();
            }
        }

        @Override
        public Set<String> processListOptions() {
            if (this.myPanel == null) {
                this.myPanel = new CodeStyleMainPanel(CodeStyleSchemesConfigurable.this.ensureModel(), this.myFactory);
            }
            return this.myPanel.processListOptions();
        }
    }
}

