/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.HighlightsExtractor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.EditorHighlightingProvidingColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEditorPreview
implements PreviewPanel {
    private static final Map<String, TextAttributesKey> INLINE_ELEMENTS = Collections.singletonMap("parameter_hint", DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    private final ColorSettingsPage myPage;
    private final EditorEx myEditor;
    private final Alarm myBlinkingAlarm;
    private final List<HighlightData> myHighlightData = new ArrayList<HighlightData>();
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final HighlightsExtractor myHighlightsExtractor;
    private static final int BLINK_COUNT = 6;

    public SimpleEditorPreview(ColorAndFontOptions options, ColorSettingsPage page) {
        this(options, page, true);
    }

    public SimpleEditorPreview(ColorAndFontOptions options, ColorSettingsPage page, boolean navigatable) {
        this.myOptions = options;
        this.myPage = page;
        this.myHighlightsExtractor = new HighlightsExtractor(page.getAdditionalHighlightingTagToDescriptorMap(), INLINE_ELEMENTS);
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(this.myHighlightsExtractor.extractHighlights(page.getDemoText(), this.myHighlightData), 10, 3, -1, this.myOptions, false);
        FontEditorPreview.installTrafficLights(this.myEditor);
        this.myBlinkingAlarm = new Alarm().setActivationComponent(this.myEditor.getComponent());
        if (navigatable) {
            this.myEditor.getContentComponent().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    SimpleEditorPreview.this.navigate(false, SimpleEditorPreview.this.myEditor.xyToLogicalPosition(new Point(e.getX(), e.getY())));
                }
            });
            this.myEditor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

                public void caretPositionChanged(CaretEvent e) {
                    SimpleEditorPreview.this.navigate(true, e.getNewPosition());
                }
            });
        }
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    public void setDemoText(String text) {
        this.myEditor.getSelectionModel().removeSelection();
        this.myHighlightData.clear();
        this.myEditor.getDocument().setText(this.myHighlightsExtractor.extractHighlights(text, this.myHighlightData));
    }

    private void navigate(boolean select, @NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/application/options/colors/SimpleEditorPreview", "navigate"));
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        SyntaxHighlighter highlighter = this.myPage.getHighlighter();
        HighlightData highlightData = this.getDataFromOffset(offset);
        String type = highlightData != null ? (RainbowHighlighter.isRainbowTempKey(highlightData.getHighlightKey()) ? "rainbow" : highlightData.getHighlightType()) : SimpleEditorPreview.selectItem(this.myEditor.getHighlighter().createIterator(offset), highlighter);
        this.setCursor(type == null ? 2 : 12);
        if (select && type != null) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectionInPreviewChanged(type);
        }
    }

    @Nullable
    private HighlightData getDataFromOffset(int offset) {
        for (HighlightData highlightData : this.myHighlightData) {
            if (offset < highlightData.getStartOffset() || offset > highlightData.getEndOffset()) continue;
            return highlightData;
        }
        return null;
    }

    @Nullable
    private static String selectItem(HighlighterIterator itr, SyntaxHighlighter highlighter) {
        IElementType tokenType = itr.getTokenType();
        if (tokenType == null) {
            return null;
        }
        TextAttributesKey[] highlights = highlighter.getTokenHighlights(tokenType);
        String s = null;
        for (int i2 = highlights.length - 1; i2 >= 0; --i2) {
            if (highlights[i2] == HighlighterColors.TEXT) continue;
            s = highlights[i2].getExternalName();
            break;
        }
        return s == null ? HighlighterColors.TEXT.getExternalName() : s;
    }

    @Override
    public JComponent getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme2 = this.myOptions.getSelectedScheme();
        this.myEditor.setColorsScheme(scheme2);
        EditorHighlighter highlighter = null;
        if (this.myPage instanceof EditorHighlightingProvidingColorSettingsPage) {
            highlighter = ((EditorHighlightingProvidingColorSettingsPage)this.myPage).createEditorHighlighter(scheme2);
        }
        if (highlighter == null) {
            SyntaxHighlighter pageHighlighter = this.myPage.getHighlighter();
            highlighter = HighlighterFactory.createHighlighter((SyntaxHighlighter)pageHighlighter, (EditorColorsScheme)scheme2);
        }
        this.myEditor.setHighlighter(highlighter);
        this.updateHighlighters();
        this.myEditor.reinitSettings();
    }

    private void updateHighlighters() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myEditor.isDisposed()) {
                return;
            }
            SimpleEditorPreview.removeDecorations(this.myEditor);
            Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(this.myPage);
            for (HighlightData data : this.myHighlightData) {
                data.addHighlToView(this.myEditor, this.myOptions.getSelectedScheme(), displayText);
            }
        });
    }

    private static void removeDecorations(Editor editor) {
        editor.getMarkupModel().removeAllHighlighters();
        for (Inlay inlay : editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength())) {
            Disposer.dispose((Disposable)inlay);
        }
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
        if (description instanceof EditorSchemeAttributeDescriptor) {
            String type = ((EditorSchemeAttributeDescriptor)description).getType();
            List<HighlightData> highlights = this.startBlinkingHighlights(this.myEditor, type, this.myPage.getHighlighter(), true, this.myBlinkingAlarm, 6, this.myPage);
            this.scrollHighlightInView(highlights);
        }
    }

    void scrollHighlightInView(@Nullable List<HighlightData> highlightDatas) {
        if (highlightDatas == null) {
            return;
        }
        boolean needScroll = true;
        int minOffset = Integer.MAX_VALUE;
        for (HighlightData data : highlightDatas) {
            if (this.isOffsetVisible(data.getStartOffset())) {
                needScroll = false;
                break;
            }
            minOffset = Math.min(minOffset, data.getStartOffset());
        }
        if (needScroll && minOffset != Integer.MAX_VALUE) {
            LogicalPosition pos = this.myEditor.offsetToLogicalPosition(minOffset);
            this.myEditor.getScrollingModel().scrollTo(pos, ScrollType.MAKE_VISIBLE);
        }
    }

    private boolean isOffsetVisible(int startOffset) {
        return this.myEditor.getScrollingModel().getVisibleArea().contains(this.myEditor.logicalPositionToXY(this.myEditor.offsetToLogicalPosition(startOffset)));
    }

    public void stopBlinking() {
        this.myBlinkingAlarm.cancelAllRequests();
    }

    private List<HighlightData> startBlinkingHighlights(EditorEx editor, String attrKey, SyntaxHighlighter highlighter, boolean show, Alarm alarm, int count, ColorSettingsPage page) {
        if (show && count <= 0) {
            return Collections.emptyList();
        }
        SimpleEditorPreview.removeDecorations(editor);
        boolean found = false;
        ArrayList<HighlightData> highlights = new ArrayList<HighlightData>();
        ArrayList<HighlightData> matchingHighlights = new ArrayList<HighlightData>();
        for (HighlightData highlightData : this.myHighlightData) {
            boolean highlight = show && highlightData.getHighlightType().equals(attrKey);
            highlightData.addToCollection(highlights, highlight);
            if (!highlight) continue;
            matchingHighlights.add(highlightData);
            found = true;
        }
        if (!found && highlighter != null) {
            HighlighterIterator iterator = editor.getHighlighter().createIterator(0);
            do {
                TextAttributesKey[] tokenHighlights;
                IElementType tokenType = iterator.getTokenType();
                for (TextAttributesKey tokenHighlight : tokenHighlights = highlighter.getTokenHighlights(tokenType)) {
                    String type = tokenHighlight.getExternalName();
                    if (!show || type == null || !type.equals(attrKey)) continue;
                    HighlightData highlightData = new HighlightData(iterator.getStart(), iterator.getEnd(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
                    highlights.add(highlightData);
                    matchingHighlights.add(highlightData);
                }
                iterator.advance();
            } while (!iterator.atEnd());
        }
        Map<TextAttributesKey, String> displayText = ColorSettingsUtil.keyToDisplayTextMap(page);
        Collections.sort(highlights, Comparator.comparingInt(HighlightData::getStartOffset));
        for (int i2 = highlights.size() - 1; i2 >= 0; --i2) {
            HighlightData prevHighlightData;
            HighlightData highlightData = (HighlightData)highlights.get(i2);
            int startOffset = highlightData.getStartOffset();
            HighlightData highlightData2 = prevHighlightData = i2 == 0 ? null : (HighlightData)highlights.get(i2 - 1);
            if (prevHighlightData != null && startOffset <= prevHighlightData.getEndOffset() && highlightData.getHighlightType().equals(prevHighlightData.getHighlightType())) {
                prevHighlightData.setEndOffset(highlightData.getEndOffset());
                continue;
            }
            highlightData.addHighlToView(editor, this.myOptions.getSelectedScheme(), displayText);
        }
        alarm.cancelAllRequests();
        alarm.addComponentRequest(() -> this.startBlinkingHighlights(editor, attrKey, highlighter, !show, alarm, count - 1, page), 400);
        return matchingHighlights;
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/application/options/colors/SimpleEditorPreview", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
        this.stopBlinking();
    }

    private void setCursor(@JdkConstants.CursorType int type) {
        Cursor cursor = type == 2 ? UIUtil.getTextCursor((Color)this.myEditor.getBackgroundColor()) : Cursor.getPredefinedCursor(type);
        this.myEditor.getContentComponent().setCursor(cursor);
    }

    public void setupRainbow(@NotNull EditorColorsScheme colorsScheme, @NotNull RainbowColorSettingsPage page) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbow"));
        }
        if (page == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "page", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbow"));
        }
        ArrayList<HighlightData> initialMarkup = new ArrayList<HighlightData>();
        this.myHighlightsExtractor.extractHighlights(page.getDemoText(), initialMarkup);
        List<HighlightData> rainbowMarkup = this.setupRainbowHighlighting(page, initialMarkup, new RainbowHighlighter((TextAttributesScheme)colorsScheme).getRainbowTempKeys(), RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)colorsScheme, page.getLanguage()));
        this.myHighlightData.clear();
        this.myHighlightData.addAll(rainbowMarkup);
    }

    @NotNull
    private List<HighlightData> setupRainbowHighlighting(@NotNull RainbowColorSettingsPage page, @NotNull List<HighlightData> initialMarkup, @NotNull TextAttributesKey[] rainbowTempKeys, boolean isRainbowOn) {
        if (page == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "page", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbowHighlighting"));
        }
        if (initialMarkup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialMarkup", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbowHighlighting"));
        }
        if (rainbowTempKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rainbowTempKeys", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbowHighlighting"));
        }
        int colorCount = rainbowTempKeys.length;
        if (colorCount == 0) {
            List<HighlightData> list = initialMarkup;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbowHighlighting"));
            }
            return list;
        }
        ArrayList<HighlightData> rainbowMarkup = new ArrayList<HighlightData>();
        int tempKeyIndex = 0;
        boolean repeatAnchor = true;
        for (HighlightData d : initialMarkup) {
            boolean rainbowDemoType;
            TextAttributesKey highlightKey = d.getHighlightKey();
            boolean rainbowType = page.isRainbowType(highlightKey);
            boolean bl = rainbowDemoType = highlightKey == RainbowHighlighter.RAINBOW_GRADIENT_DEMO;
            if (rainbowType || rainbowDemoType) {
                HighlightData rainbowAnchor = new HighlightData(d.getStartOffset(), d.getEndOffset(), RainbowHighlighter.RAINBOW_ANCHOR);
                if (isRainbowOn) {
                    HighlightData rainbowTemp;
                    if (rainbowType) {
                        rainbowTemp = this.getRainbowTemp(rainbowTempKeys, d.getStartOffset(), d.getEndOffset());
                    } else {
                        rainbowTemp = new HighlightData(d.getStartOffset(), d.getEndOffset(), rainbowTempKeys[tempKeyIndex % colorCount]);
                        if (repeatAnchor && tempKeyIndex == colorCount / 2) {
                            repeatAnchor = false;
                        } else {
                            ++tempKeyIndex;
                        }
                    }
                    rainbowMarkup.add(rainbowTemp);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(rainbowTemp);
                    continue;
                }
                if (rainbowType) {
                    rainbowMarkup.add(d);
                    rainbowMarkup.add(rainbowAnchor);
                    rainbowMarkup.add(d);
                    continue;
                }
                rainbowMarkup.add(rainbowAnchor);
                continue;
            }
            if (RainbowHighlighter.isRainbowTempKey(highlightKey) || highlightKey == RainbowHighlighter.RAINBOW_ANCHOR) continue;
            rainbowMarkup.add(d);
        }
        ArrayList<HighlightData> arrayList = rainbowMarkup;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SimpleEditorPreview", "setupRainbowHighlighting"));
        }
        return arrayList;
    }

    @NotNull
    private HighlightData getRainbowTemp(@NotNull TextAttributesKey[] rainbowTempKeys, int startOffset, int endOffset) {
        if (rainbowTempKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rainbowTempKeys", "com/intellij/application/options/colors/SimpleEditorPreview", "getRainbowTemp"));
        }
        String id = this.myEditor.getDocument().getText(TextRange.create((int)startOffset, (int)endOffset));
        int index = UsedColors.getOrAddColorIndex((UserDataHolderEx)((EditorImpl)this.myEditor), id, rainbowTempKeys.length);
        HighlightData highlightData = new HighlightData(startOffset, endOffset, rainbowTempKeys[index]);
        if (highlightData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SimpleEditorPreview", "getRainbowTemp"));
        }
        return highlightData;
    }
}

