/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public abstract class MultiCaretCodeInsightAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "actionPerformed"));
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Editor hostEditor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (hostEditor == null) {
            return;
        }
        this.actionPerformedImpl(project2, hostEditor);
    }

    public void actionPerformedImpl(Project project2, Editor hostEditor) {
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            MultiCaretCodeInsightActionHandler handler2 = this.getHandler();
            try {
                MultiCaretCodeInsightAction.iterateOverCarets(project2, hostEditor, handler2);
            }
            finally {
                handler2.postInvoke();
            }
        }), this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)hostEditor.getDocument()));
        hostEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "beforeActionPerformedUpdate"));
        }
        Project project2 = e.getProject();
        if (project2 != null) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor hostEditor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (hostEditor == null) {
            presentation.setEnabled(false);
            return;
        }
        final Ref enabled = new Ref((Object)Boolean.FALSE);
        MultiCaretCodeInsightAction.iterateOverCarets(project2, hostEditor, new MultiCaretCodeInsightActionHandler(){

            @Override
            public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1", "invoke"));
                }
                if (caret == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1", "invoke"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$1", "invoke"));
                }
                if (MultiCaretCodeInsightAction.this.isValidFor(project2, editor, caret, file2)) {
                    enabled.set((Object)Boolean.TRUE);
                }
            }
        });
        presentation.setEnabled(((Boolean)enabled.get()).booleanValue());
    }

    private static void iterateOverCarets(final @NotNull Project project2, final @NotNull Editor hostEditor, final @NotNull MultiCaretCodeInsightActionHandler handler2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        final PsiFile hostFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(hostEditor.getDocument());
        hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                PsiFile file2;
                Caret injectedCaret;
                Editor editor = hostEditor;
                if (hostFile != null && (injectedCaret = InjectedLanguageUtil.getCaretForInjectedLanguageNoCommit(caret, hostFile)) != null) {
                    caret = injectedCaret;
                    editor = caret.getEditor();
                }
                if ((file2 = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project2)) != null) {
                    handler2.invoke(project2, editor, caret, file2);
                }
            }
        });
    }

    protected boolean isValidFor(@NotNull Project project2, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        return true;
    }

    @NotNull
    protected abstract MultiCaretCodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }
}

