/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodCallElement
extends LookupItem<PsiMethod>
implements TypedLookupItem,
StaticallyImportable {
    public static final ClassConditionKey<JavaMethodCallElement> CLASS_CONDITION_KEY = ClassConditionKey.create(JavaMethodCallElement.class);
    @Nullable
    private final PsiClass myContainingClass;
    private final PsiMethod myMethod;
    private final MemberLookupHelper myHelper;
    private PsiSubstitutor myQualifierSubstitutor;
    private PsiSubstitutor myInferenceSubstitutor;
    private boolean myMayNeedExplicitTypeParameters;
    private String myForcedQualifier;
    public static final Key<JavaMethodCallElement> ARGUMENT_TEMPLATE_ACTIVE = Key.create((String)"ARGUMENT_TEMPLATE_ACTIVE");

    public JavaMethodCallElement(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/completion/JavaMethodCallElement", "<init>"));
        }
        this(method2, method2.getName());
    }

    public JavaMethodCallElement(@NotNull PsiMethod method2, String methodName) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/completion/JavaMethodCallElement", "<init>"));
        }
        super(method2, methodName);
        this.myQualifierSubstitutor = PsiSubstitutor.EMPTY;
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myForcedQualifier = "";
        this.myMethod = method2;
        this.myHelper = null;
        this.myContainingClass = method2.getContainingClass();
    }

    public JavaMethodCallElement(PsiMethod method2, boolean shouldImportStatic, boolean mergedOverloads) {
        super(method2, method2.getName());
        String className;
        this.myQualifierSubstitutor = PsiSubstitutor.EMPTY;
        this.myInferenceSubstitutor = PsiSubstitutor.EMPTY;
        this.myForcedQualifier = "";
        this.myMethod = method2;
        this.myContainingClass = method2.getContainingClass();
        this.myHelper = new MemberLookupHelper((PsiMember)method2, this.myContainingClass, shouldImportStatic, mergedOverloads);
        if (!shouldImportStatic && this.myContainingClass != null && (className = this.myContainingClass.getName()) != null) {
            this.addLookupStrings(new String[]{className + "." + this.myMethod.getName()});
        }
    }

    void setForcedQualifier(@NotNull String forcedQualifier) {
        if (forcedQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forcedQualifier", "com/intellij/codeInsight/completion/JavaMethodCallElement", "setForcedQualifier"));
        }
        this.myForcedQualifier = forcedQualifier;
        this.setLookupString(forcedQualifier + this.getLookupString());
    }

    @Override
    public PsiType getType() {
        return this.getSubstitutor().substitute(this.getInferenceSubstitutor().substitute(((PsiMethod)this.getObject()).getReturnType()));
    }

    public void setInferenceSubstitutor(@NotNull PsiSubstitutor substitutor, PsiElement place) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/completion/JavaMethodCallElement", "setInferenceSubstitutor"));
        }
        this.myInferenceSubstitutor = substitutor;
        this.myMayNeedExplicitTypeParameters = JavaMethodCallElement.mayNeedTypeParameters(place);
    }

    public JavaMethodCallElement setQualifierSubstitutor(@NotNull PsiSubstitutor qualifierSubstitutor) {
        if (qualifierSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierSubstitutor", "com/intellij/codeInsight/completion/JavaMethodCallElement", "setQualifierSubstitutor"));
        }
        this.myQualifierSubstitutor = qualifierSubstitutor;
        return this;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.myQualifierSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaMethodCallElement", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor getInferenceSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.myInferenceSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaMethodCallElement", "getInferenceSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.canBeImported() && this.myHelper.willBeImported();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodCallElement)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.myInferenceSubstitutor.equals(((JavaMethodCallElement)o).myInferenceSubstitutor);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myInferenceSubstitutor.hashCode();
        return result2;
    }

    @Override
    public void handleInsert(InsertionContext context) {
        Document document = context.getDocument();
        PsiFile file2 = context.getFile();
        PsiMethod method2 = (PsiMethod)this.getObject();
        LookupElement[] allItems = context.getElements();
        boolean overloadsMatter = allItems.length == 1 && this.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) == null;
        boolean hasParams = MethodParenthesesHandler.hasParams((LookupElement)this, (LookupElement[])allItems, (boolean)overloadsMatter, (PsiMethod)method2);
        JavaCompletionUtil.insertParentheses(context, (LookupElement)this, overloadsMatter, hasParams);
        int startOffset = context.getStartOffset();
        OffsetKey refStart = context.trackOffset(startOffset, true);
        if (this.shouldInsertTypeParameters() && JavaMethodCallElement.mayNeedTypeParameters(context.getFile().findElementAt(context.getStartOffset()))) {
            this.qualifyMethodCall(file2, startOffset, document);
            this.insertExplicitTypeParameters(context, refStart);
        } else if (this.myHelper != null) {
            context.commitDocument();
            this.importOrQualify(document, file2, method2, startOffset);
        }
        PsiType type = method2.getReturnType();
        if (context.getCompletionChar() == '!' && type != null && PsiType.BOOLEAN.isAssignableFrom(type)) {
            context.setAddCompletionChar(false);
            context.commitDocument();
            int offset = context.getOffset(refStart);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(methodCall.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
        context.commitDocument();
        if (hasParams && context.getCompletionChar() != '\r' && Registry.is((String)"java.completion.argument.live.template")) {
            this.startArgumentLiveTemplate(context, method2);
        }
    }

    private void importOrQualify(Document document, PsiFile file2, PsiMethod method2, int startOffset) {
        if (this.willBeImported()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)startOffset, PsiReferenceExpression.class, (boolean)false);
            if (ref != null && this.myContainingClass != null && !ref.isReferenceTo((PsiElement)method2)) {
                ref.bindToElementViaStaticImport(this.myContainingClass);
            }
            return;
        }
        this.qualifyMethodCall(file2, startOffset, document);
    }

    @NotNull
    private static Template createArgTemplate(PsiMethod method2, int caretOffset, PsiExpressionList argList, TextRange argRange) {
        Template template = TemplateManager.getInstance(method2.getProject()).createTemplate("", "");
        template.addTextSegment(argList.getText().substring(0, caretOffset - argRange.getStartOffset()));
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (i2 > 0) {
                template.addTextSegment(", ");
            }
            String name = StringUtil.notNullize((String)parameters[i2].getName());
            Expression expression = Registry.is((String)"java.completion.argument.live.template.completion") ? new AutoPopupCompletion() : new ConstantNode(name);
            template.addVariable(name, expression, new ConstantNode(name), true);
        }
        boolean finishInsideParens = method2.isVarArgs();
        if (finishInsideParens) {
            template.addEndVariable();
        }
        template.addTextSegment(argList.getText().substring(caretOffset - argRange.getStartOffset(), argList.getTextLength()));
        if (!finishInsideParens) {
            template.addEndVariable();
        }
        Template template2 = template;
        if (template2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaMethodCallElement", "createArgTemplate"));
        }
        return template2;
    }

    private void startArgumentLiveTemplate(InsertionContext context, PsiMethod method2) {
        int caretOffset;
        PsiExpressionList argList;
        Editor editor = context.getEditor();
        PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiCallExpression.class, (boolean)false);
        PsiExpressionList psiExpressionList = argList = call == null ? null : call.getArgumentList();
        if (argList == null || argList.getExpressions().length > 0) {
            return;
        }
        TextRange argRange = argList.getTextRange();
        if (!argRange.contains(caretOffset = editor.getCaretModel().getOffset())) {
            return;
        }
        Template template = JavaMethodCallElement.createArgTemplate(method2, caretOffset, argList, argRange);
        context.getDocument().deleteString(argRange.getStartOffset(), argRange.getEndOffset());
        TemplateManager.getInstance(method2.getProject()).startTemplate(editor, template);
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState == null) {
            return;
        }
        JavaMethodCallElement.setupNonFilledArgumentRemoving(editor, templateState);
        editor.putUserData(ARGUMENT_TEMPLATE_ACTIVE, (Object)this);
        Disposer.register((Disposable)templateState, () -> {
            if (editor.getUserData(ARGUMENT_TEMPLATE_ACTIVE) == this) {
                editor.putUserData(ARGUMENT_TEMPLATE_ACTIVE, null);
            }
        });
    }

    private static void setupNonFilledArgumentRemoving(final Editor editor, final TemplateState templateState) {
        final AtomicInteger maxEditedVariable = new AtomicInteger(-1);
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                maxEditedVariable.set(Math.max(maxEditedVariable.get(), templateState.getCurrentVariableNumber()));
            }
        }, (Disposable)templateState);
        templateState.addTemplateStateListener(new TemplateEditingAdapter(){

            @Override
            public void currentVariableChanged(TemplateState templateState2, Template template, int oldIndex, int newIndex) {
                maxEditedVariable.set(Math.max(maxEditedVariable.get(), oldIndex));
            }

            @Override
            public void beforeTemplateFinished(TemplateState state, Template template, boolean brokenOff) {
                if (brokenOff) {
                    this.removeUntouchedArguments((TemplateImpl)template);
                }
            }

            private void removeUntouchedArguments(TemplateImpl template) {
                int firstUnchangedVar = maxEditedVariable.get() + 1;
                if (firstUnchangedVar >= template.getVariableCount()) {
                    return;
                }
                TextRange startRange = templateState.getVariableRange(template.getVariableNameAt(firstUnchangedVar));
                TextRange endRange = templateState.getVariableRange(template.getVariableNameAt(template.getVariableCount() - 1));
                if (startRange == null || endRange == null) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), () -> editor.getDocument().deleteString(startRange.getStartOffset(), endRange.getEndOffset()));
            }
        });
    }

    private boolean shouldInsertTypeParameters() {
        return this.myMayNeedExplicitTypeParameters && !this.getInferenceSubstitutor().equals(PsiSubstitutor.EMPTY) && this.myMethod.getParameterList().getParametersCount() == 0;
    }

    public static boolean mayNeedTypeParameters(@Nullable PsiElement leaf) {
        if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiConditionalExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiModifierListOwner.class}) == null) {
            return false;
        }
        if (PsiUtil.getLanguageLevel((PsiElement)leaf).isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiElement parent = leaf.getParent();
        return !(parent instanceof PsiReferenceExpression) || ((PsiReferenceExpression)parent).getTypeParameters().length <= 0;
    }

    private void insertExplicitTypeParameters(InsertionContext context, OffsetKey refStart) {
        context.commitDocument();
        String typeParams = this.getTypeParamsText(false);
        if (typeParams != null) {
            context.getDocument().insertString(context.getOffset(refStart), (CharSequence)typeParams);
            JavaCompletionUtil.shortenReference(context.getFile(), context.getOffset(refStart));
        }
    }

    private void qualifyMethodCall(PsiFile file2, int startOffset, Document document) {
        PsiReference reference = file2.findReferenceAt(startOffset);
        if (reference instanceof PsiReferenceExpression && ((PsiReferenceExpression)reference).isQualified()) {
            return;
        }
        PsiMethod method2 = (PsiMethod)this.getObject();
        if (!method2.hasModifierProperty("static")) {
            document.insertString(startOffset, (CharSequence)"this.");
            return;
        }
        if (this.myContainingClass == null) {
            return;
        }
        document.insertString(startOffset, (CharSequence)".");
        JavaCompletionUtil.insertClassReference(this.myContainingClass, file2, startOffset);
    }

    @Nullable
    private String getTypeParamsText(boolean presentable) {
        PsiMethod method2 = (PsiMethod)this.getObject();
        PsiSubstitutor substitutor = this.getInferenceSubstitutor();
        PsiTypeParameter[] parameters = method2.getTypeParameters();
        assert (parameters.length > 0);
        StringBuilder builder = new StringBuilder("<");
        boolean first = true;
        for (PsiTypeParameter parameter : parameters) {
            String text;
            if (!first) {
                builder.append(", ");
            }
            first = false;
            PsiType type = substitutor.substitute(parameter);
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getExtendsBound();
            }
            if (type == null || type instanceof PsiCapturedWildcardType) {
                return null;
            }
            if (type.equals(TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter))) {
                return null;
            }
            String string = text = presentable ? type.getPresentableText() : type.getCanonicalText();
            if (text.indexOf(63) >= 0) {
                return null;
            }
            builder.append(text);
        }
        return builder.append(">").toString();
    }

    public boolean isValid() {
        return super.isValid() && this.myInferenceSubstitutor.isValid() && this.getSubstitutor().isValid();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        String typeParamsText;
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)this));
        MemberLookupHelper helper = this.myHelper != null ? this.myHelper : new MemberLookupHelper((PsiMember)this.myMethod, this.myContainingClass, false, false);
        helper.renderElement(presentation, this.myHelper != null, this.myHelper != null && !this.myHelper.willBeImported(), this.getSubstitutor());
        if (!this.myForcedQualifier.isEmpty()) {
            presentation.setItemText(this.myForcedQualifier + presentation.getItemText());
        }
        if (this.shouldInsertTypeParameters() && (typeParamsText = this.getTypeParamsText(true)) != null) {
            if (typeParamsText.length() > 10) {
                typeParamsText = typeParamsText.substring(0, 10) + "...>";
            }
            String itemText = presentation.getItemText();
            assert (itemText != null);
            int i2 = itemText.indexOf(46);
            if (i2 > 0) {
                presentation.setItemText(itemText.substring(0, i2 + 1) + typeParamsText + itemText.substring(i2 + 1));
            }
        }
    }

    private static class AutoPopupCompletion
    extends Expression {
        private AutoPopupCompletion() {
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            return new InvokeActionResult(() -> AutoPopupController.getInstance(context.getProject()).scheduleAutoPopup(context.getEditor()));
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return null;
        }
    }
}

