/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.IntStack;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance((String)ControlFlowUtil.class.getName());

    private ControlFlowUtil() {
    }

    public static int[] postOrder(Instruction[] flow) {
        int length = flow.length;
        int[] result2 = new int[length];
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        IntStack stack = new IntStack(length);
        int N = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (visited[i2]) continue;
            visited[i2] = true;
            stack.clear();
            stack.push(i2);
            while (!stack.empty()) {
                int num = stack.pop();
                result2[N++] = num;
                for (Instruction succ : flow[num].allSucc()) {
                    int succNum = succ.num();
                    if (visited[succNum]) continue;
                    visited[succNum] = true;
                    stack.push(succNum);
                }
            }
        }
        LOG.assertTrue(N == length);
        return result2;
    }

    public static int findInstructionNumberByElement(Instruction[] flow, PsiElement element) {
        for (int i2 = 0; i2 < flow.length; ++i2) {
            ProgressManager.checkCanceled();
            if (element != flow[i2].getElement()) continue;
            return i2;
        }
        return -1;
    }

    public static boolean process(Instruction[] flow, int start, Processor<Instruction> processor2) {
        int length = flow.length;
        boolean[] visited = new boolean[length];
        Arrays.fill(visited, false);
        IntStack stack = new IntStack(length);
        stack.push(start);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instruction = flow[num];
            if (!processor2.process((Object)instruction)) {
                return false;
            }
            for (Instruction succ : instruction.allSucc()) {
                int succNum = succ.num();
                if (visited[succNum]) continue;
                visited[succNum] = true;
                stack.push(succNum);
            }
        }
        return true;
    }

    public static void iteratePrev(int startInstruction, @NotNull Instruction[] instructions, @NotNull Function<Instruction, Operation> closure) {
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/intellij/codeInsight/controlflow/ControlFlowUtil", "iteratePrev"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "com/intellij/codeInsight/controlflow/ControlFlowUtil", "iteratePrev"));
        }
        IntStack stack = new IntStack(instructions.length);
        boolean[] visited = new boolean[instructions.length];
        stack.push(startInstruction);
        while (!stack.empty()) {
            ProgressManager.checkCanceled();
            int num = stack.pop();
            Instruction instr = instructions[num];
            Operation nextOperation = (Operation)((Object)closure.fun((Object)instr));
            if (nextOperation == Operation.CONTINUE) continue;
            if (nextOperation == Operation.BREAK) break;
            assert (nextOperation == Operation.NEXT);
            for (Instruction pred : instr.allPred()) {
                int predNum = pred.num();
                if (visited[predNum]) continue;
                visited[predNum] = true;
                stack.push(predNum);
            }
        }
    }

    public static enum Operation {
        CONTINUE,
        BREAK,
        NEXT;

    }
}

