/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileConvertor {
    private final Map<String, HighlightDisplayLevel> myDisplayLevelMap;
    @NonNls
    public static final String OLD_HIGHTLIGHTING_SETTINGS_PROFILE = "EditorHighlightingSettings";
    @NonNls
    public static final String OLD_DEFAUL_PROFILE = "OldDefaultProfile";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsConvertor");
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String VERSION_ATT = "version";
    @NonNls
    private static final String OPTION_TAG = "option";
    @NonNls
    private static final String DISPLAY_LEVEL_MAP_OPTION = "DISPLAY_LEVEL_MAP";
    @NonNls
    protected static final String VALUE_ATT = "value";
    @NonNls
    private static final String DEFAULT_XML = "Default.xml";
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    @NonNls
    public static final String LEVEL_ATT = "level";
    private final InspectionProfileManager myManager;

    public InspectionProfileConvertor(@NotNull InspectionProfileManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "<init>"));
        }
        this.myDisplayLevelMap = new HashMap<String, HighlightDisplayLevel>();
        this.myManager = manager;
        InspectionProfileConvertor.renameOldDefaultsProfile();
    }

    private boolean retrieveOldSettings(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "retrieveOldSettings"));
        }
        boolean hasOldSettings = false;
        for (Element option : element.getChildren(OPTION_TAG)) {
            String name = option.getAttributeValue(NAME_ATT);
            if (name == null) continue;
            hasOldSettings |= this.processElement(option, name);
        }
        return hasOldSettings;
    }

    protected boolean processElement(Element option, String name) {
        if (name.equals(DISPLAY_LEVEL_MAP_OPTION)) {
            for (Element e : option.getChild(VALUE_ATT).getChildren()) {
                HighlightDisplayLevel level;
                String key2 = e.getName();
                String levelName = e.getAttributeValue(LEVEL_ATT);
                HighlightSeverity severity = this.myManager.getSeverityRegistrar().getSeverity(levelName);
                HighlightDisplayLevel highlightDisplayLevel = level = severity == null ? null : HighlightDisplayLevel.find((HighlightSeverity)severity);
                if (level == null) continue;
                this.myDisplayLevelMap.put(key2, level);
            }
            return true;
        }
        return false;
    }

    public void storeEditorHighlightingProfile(@NotNull Element element, @NotNull InspectionProfile editorProfile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "storeEditorHighlightingProfile"));
        }
        if (editorProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProfile", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "storeEditorHighlightingProfile"));
        }
        if (this.retrieveOldSettings(element)) {
            InspectionProfileImpl editorProfileModel = (InspectionProfileImpl)editorProfile.getModifiableModel();
            this.fillErrorLevels(editorProfileModel);
            editorProfileModel.commit();
        }
    }

    private static void renameOldDefaultsProfile() {
        String directoryPath = PathManager.getConfigPath() + File.separator + "inspection";
        File profileDirectory = new File(directoryPath);
        if (!profileDirectory.exists()) {
            return;
        }
        File[] files = profileDirectory.listFiles(pathname -> pathname.getPath().endsWith(File.separator + DEFAULT_XML));
        if (files == null || files.length != 1 || !files[0].isFile() || files[0].length() == 0L) {
            return;
        }
        try {
            Element root = JDOMUtil.load((File)files[0]);
            if (root.getAttributeValue(VERSION_ATT) == null) {
                JDOMUtil.writeParent((Parent)root, (OutputStream)new FileOutputStream(new File(profileDirectory, "OldDefaultProfile.xml")), (String)"\n");
                FileUtil.delete((File)files[0]);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void fillErrorLevels(InspectionProfileImpl profile) {
        InspectionToolWrapper[] toolWrappers = profile.getInspectionTools(null);
        LOG.assertTrue(toolWrappers != null, (Object)"Profile was not correctly init");
        for (String shortName : this.myDisplayLevelMap.keySet()) {
            HighlightDisplayLevel level = this.myDisplayLevelMap.get(shortName);
            HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
            if (key2 == null) continue;
            if (level != HighlightDisplayLevel.DO_NOT_SHOW) {
                profile.enableTool(shortName, null, null);
            }
            if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
                level = HighlightDisplayLevel.WARNING;
            }
            profile.setErrorLevel(key2, level, null);
        }
    }
}

