/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RainbowVisitor
implements HighlightVisitor {
    private HighlightInfoHolder myHolder;
    private RainbowHighlighter myRainbowHighlighter;

    @Override
    @NotNull
    public abstract HighlightVisitor clone();

    @NotNull
    protected RainbowHighlighter getHighlighter() {
        RainbowHighlighter rainbowHighlighter = this.myRainbowHighlighter;
        if (rainbowHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/RainbowVisitor", "getHighlighter"));
        }
        return rainbowHighlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/RainbowVisitor", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/RainbowVisitor", "analyze"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/RainbowVisitor", "analyze"));
        }
        this.myHolder = holder;
        this.myRainbowHighlighter = new RainbowHighlighter(this.myHolder.getColorsScheme());
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
            this.myRainbowHighlighter = null;
        }
        return true;
    }

    @Override
    public int order() {
        return 1;
    }

    protected void addInfo(@Nullable HighlightInfo highlightInfo) {
        this.myHolder.add(highlightInfo);
    }

    protected HighlightInfo getInfo(@NotNull PsiElement context, @NotNull PsiElement rainbowElement, @NotNull String name, @Nullable TextAttributesKey colorKey) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/RainbowVisitor", "getInfo"));
        }
        if (rainbowElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rainbowElement", "com/intellij/codeInsight/daemon/RainbowVisitor", "getInfo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/RainbowVisitor", "getInfo"));
        }
        int colorIndex = UsedColors.getOrAddColorIndex((UserDataHolderEx)context, name, this.getHighlighter().getColorsCount());
        return this.getHighlighter().getInfo(colorIndex, rainbowElement, colorKey);
    }
}

