/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PassExecutorService
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PassExecutorService");
    private static final boolean CHECK_CONSISTENCY = ApplicationManager.getApplication().isUnitTestMode();
    private final Map<ScheduledPass, Job<Void>> mySubmittedPasses;
    private final Project myProject;
    private volatile boolean isDisposed;
    private final AtomicInteger nextPassId;
    private static final Key<Throwable> THROWABLE_KEY = Key.create((String)"THROWABLE_KEY");

    PassExecutorService(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "<init>"));
        }
        this.mySubmittedPasses = new ConcurrentHashMap<ScheduledPass, Job<Void>>();
        this.nextPassId = new AtomicInteger(100);
        this.myProject = project2;
    }

    public void dispose() {
        this.cancelAll(true);
        this.isDisposed = true;
    }

    void cancelAll(boolean waitForTermination) {
        for (Job<Void> submittedPass : this.mySubmittedPasses.values()) {
            submittedPass.cancel();
        }
        if (waitForTermination) {
            try {
                while (!this.waitFor(50)) {
                    boolean bl = false;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
        this.mySubmittedPasses.clear();
    }

    void submitPasses(@NotNull Map<FileEditor, HighlightingPass[]> passesMap, @NotNull DaemonProgressIndicator updateProgress) {
        FileEditor fileEditor;
        if (passesMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passesMap", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submitPasses"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProgress", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submitPasses"));
        }
        if (this.isDisposed()) {
            return;
        }
        MultiMap documentToEditors = MultiMap.createSet();
        MultiMap documentBoundPasses = MultiMap.createSmart();
        MultiMap editorBoundPasses = MultiMap.createSmart();
        ArrayList<Pair> passesWithNoDocuments = new ArrayList<Pair>();
        HashSet<VirtualFile> vFiles = new HashSet<VirtualFile>();
        for (Map.Entry<FileEditor, HighlightingPass[]> entry : passesMap.entrySet()) {
            Document document;
            FileEditor fileEditor2 = entry.getKey();
            HighlightingPass[] passes = entry.getValue();
            if (fileEditor2 instanceof TextEditor) {
                Editor editor = ((TextEditor)fileEditor2).getEditor();
                LOG.assertTrue(!(editor instanceof EditorWindow));
                document = editor.getDocument();
            } else {
                VirtualFile virtualFile = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor2);
                Document document2 = document = virtualFile == null ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
            }
            if (document != null) {
                vFiles.add(FileDocumentManager.getInstance().getFile(document));
            }
            int prevId = 0;
            for (HighlightingPass pass : passes) {
                if (pass instanceof EditorBoundHighlightingPass) {
                    EditorBoundHighlightingPass editorPass = (EditorBoundHighlightingPass)pass;
                    editorPass.setId(this.nextPassId.incrementAndGet());
                    editorBoundPasses.putValue((Object)fileEditor2, (Object)editorPass);
                    continue;
                }
                TextEditorHighlightingPass textEditorHighlightingPass = this.convertToTextHighlightingPass(pass, document, this.nextPassId, prevId);
                document = textEditorHighlightingPass.getDocument();
                documentBoundPasses.putValue((Object)fileEditor2, (Object)textEditorHighlightingPass);
                if (document == null) {
                    passesWithNoDocuments.add(Pair.create((Object)fileEditor2, (Object)textEditorHighlightingPass));
                } else {
                    documentToEditors.putValue((Object)document, (Object)fileEditor2);
                }
                prevId = textEditorHighlightingPass.getId();
            }
        }
        ArrayList<ScheduledPass> freePasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 5);
        ArrayList<ScheduledPass> dependentPasses = new ArrayList<ScheduledPass>(documentToEditors.size() * 10);
        THashMap toBeSubmitted = new THashMap(passesMap.size());
        AtomicInteger threadsToStartCountdown = new AtomicInteger(0);
        for (Map.Entry entry : documentToEditors.entrySet()) {
            Collection fileEditors = (Collection)entry.getValue();
            Document document = (Document)entry.getKey();
            FileEditor preferredFileEditor = this.getPreferredFileEditor(document, fileEditors);
            List passes = (List)documentBoundPasses.get((Object)preferredFileEditor);
            if (passes.isEmpty()) continue;
            PassExecutorService.sortById(passes);
            for (TextEditorHighlightingPass currentPass : passes) {
                this.createScheduledPass(preferredFileEditor, currentPass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, passes, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Map.Entry entry : editorBoundPasses.entrySet()) {
            fileEditor = (FileEditor)entry.getKey();
            Collection createdEditorBoundPasses = (Collection)entry.getValue();
            List createdDocumentBoundPasses = (List)documentBoundPasses.get((Object)fileEditor);
            ArrayList<TextEditorHighlightingPass> allCreatedPasses = new ArrayList<TextEditorHighlightingPass>(createdDocumentBoundPasses);
            allCreatedPasses.addAll(createdEditorBoundPasses);
            for (EditorBoundHighlightingPass pass : createdEditorBoundPasses) {
                this.createScheduledPass(fileEditor, pass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, allCreatedPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
            }
        }
        for (Pair pair : passesWithNoDocuments) {
            fileEditor = (FileEditor)pair.first;
            TextEditorHighlightingPass pass = (TextEditorHighlightingPass)pair.second;
            this.createScheduledPass(fileEditor, pass, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, ContainerUtil.emptyList(), freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        if (CHECK_CONSISTENCY && !ApplicationInfoImpl.isInPerformanceTest()) {
            this.assertConsistency(freePasses, (Map<Pair<FileEditor, Integer>, ScheduledPass>)toBeSubmitted, threadsToStartCountdown);
        }
        PassExecutorService.log(updateProgress, null, vFiles + " ----- starting " + threadsToStartCountdown.get(), freePasses);
        for (ScheduledPass dependentPass : dependentPasses) {
            this.mySubmittedPasses.put(dependentPass, Job.NULL_JOB);
        }
        for (ScheduledPass freePass : freePasses) {
            this.submit(freePass);
        }
    }

    private void assertConsistency(List<ScheduledPass> freePasses, Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, AtomicInteger threadsToStartCountdown) {
        assert (threadsToStartCountdown.get() == toBeSubmitted.size());
        TIntObjectHashMap id2Visits = new TIntObjectHashMap();
        for (ScheduledPass freePass : freePasses) {
            id2Visits.put(freePass.myPass.getId(), (Object)Pair.create((Object)freePass, (Object)0));
            this.checkConsistency(freePass, (TIntObjectHashMap<Pair<ScheduledPass, Integer>>)id2Visits);
        }
        id2Visits.forEachEntry((id, pair) -> {
            int count = (Integer)pair.second;
            assert (count == 0) : id;
            return true;
        });
        assert (id2Visits.size() == threadsToStartCountdown.get());
    }

    private void checkConsistency(ScheduledPass pass, TIntObjectHashMap<Pair<ScheduledPass, Integer>> id2Visits) {
        for (ScheduledPass succ : ContainerUtil.concat((Iterable[])new Iterable[]{pass.mySuccessorsOnCompletion, pass.mySuccessorsOnSubmit})) {
            int succId = succ.myPass.getId();
            Pair succPair = (Pair)id2Visits.get(succId);
            if (succPair == null) {
                succPair = Pair.create((Object)succ, (Object)succ.myRunningPredecessorsCount.get());
                id2Visits.put(succId, (Object)succPair);
            }
            int newPred = (Integer)succPair.second - 1;
            id2Visits.put(succId, (Object)Pair.create((Object)succ, (Object)newPred));
            assert (newPred >= 0);
            if (newPred != 0) continue;
            this.checkConsistency(succ, id2Visits);
        }
    }

    @NotNull
    private TextEditorHighlightingPass convertToTextHighlightingPass(final @NotNull HighlightingPass pass, Document document, @NotNull AtomicInteger id, int previousPassId) {
        TextEditorHighlightingPass textEditorHighlightingPass;
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "convertToTextHighlightingPass"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "convertToTextHighlightingPass"));
        }
        if (pass instanceof TextEditorHighlightingPass) {
            textEditorHighlightingPass = (TextEditorHighlightingPass)pass;
        } else {
            textEditorHighlightingPass = new TextEditorHighlightingPass(this.myProject, document, true){

                @Override
                public void doCollectInformation(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PassExecutorService$1", "doCollectInformation"));
                    }
                    pass.collectInformation(progress);
                }

                @Override
                public void doApplyInformationToEditor() {
                    pass.applyInformationToEditor();
                }
            };
            textEditorHighlightingPass.setId(id.incrementAndGet());
            if (previousPassId != 0) {
                textEditorHighlightingPass.setCompletionPredecessorIds(new int[]{previousPassId});
            }
        }
        TextEditorHighlightingPass textEditorHighlightingPass2 = textEditorHighlightingPass;
        if (textEditorHighlightingPass2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "convertToTextHighlightingPass"));
        }
        return textEditorHighlightingPass2;
    }

    @NotNull
    private FileEditor getPreferredFileEditor(Document document, @NotNull Collection<FileEditor> fileEditors) {
        FileEditor selected;
        VirtualFile file2;
        if (fileEditors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditors", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getPreferredFileEditor"));
        }
        assert (!fileEditors.isEmpty());
        if (document != null && (file2 = FileDocumentManager.getInstance().getFile(document)) != null && (selected = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2)) != null && fileEditors.contains(selected)) {
            FileEditor fileEditor = selected;
            if (fileEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getPreferredFileEditor"));
            }
            return fileEditor;
        }
        FileEditor fileEditor = fileEditors.iterator().next();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getPreferredFileEditor"));
        }
        return fileEditor;
    }

    @NotNull
    private ScheduledPass createScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        ScheduledPass predecessor;
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (toBeSubmitted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toBeSubmitted", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditorHighlightingPasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (freePasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freePasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (dependentPasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentPasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProgress", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadsToStartCountdown", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        int passId = pass.getId();
        Pair key2 = Pair.create((Object)fileEditor, (Object)passId);
        ScheduledPass scheduledPass = toBeSubmitted.get(key2);
        if (scheduledPass != null) {
            ScheduledPass scheduledPass2 = scheduledPass;
            if (scheduledPass2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
            }
            return scheduledPass2;
        }
        scheduledPass = new ScheduledPass(fileEditor, pass, updateProgress, threadsToStartCountdown);
        threadsToStartCountdown.incrementAndGet();
        toBeSubmitted.put((Pair<FileEditor, Integer>)key2, scheduledPass);
        for (int predecessorId : pass.getCompletionPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnCompletion(scheduledPass);
        }
        for (int predecessorId : pass.getStartingPredecessorIds()) {
            predecessor = this.findOrCreatePredecessorPass(fileEditor, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown, predecessorId);
            if (predecessor == null) continue;
            predecessor.addSuccessorOnSubmit(scheduledPass);
        }
        if (scheduledPass.myRunningPredecessorsCount.get() == 0 && !freePasses.contains(scheduledPass)) {
            freePasses.add(scheduledPass);
        } else if (!dependentPasses.contains(scheduledPass)) {
            dependentPasses.add(scheduledPass);
        }
        if (pass.isRunIntentionPassAfter() && fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            ShowIntentionsPass ip = new ShowIntentionsPass(this.myProject, editor, -1);
            ip.setId(this.nextPassId.incrementAndGet());
            ip.setCompletionPredecessorIds(new int[]{scheduledPass.myPass.getId()});
            this.createScheduledPass(fileEditor, ip, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, threadsToStartCountdown);
        }
        ScheduledPass scheduledPass3 = scheduledPass;
        if (scheduledPass3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "createScheduledPass"));
        }
        return scheduledPass3;
    }

    private ScheduledPass findOrCreatePredecessorPass(@NotNull FileEditor fileEditor, @NotNull Map<Pair<FileEditor, Integer>, ScheduledPass> toBeSubmitted, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses, @NotNull List<ScheduledPass> freePasses, @NotNull List<ScheduledPass> dependentPasses, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger myThreadsToStartCountdown, int predecessorId) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (toBeSubmitted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toBeSubmitted", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditorHighlightingPasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (freePasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freePasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (dependentPasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentPasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProgress", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        if (myThreadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myThreadsToStartCountdown", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findOrCreatePredecessorPass"));
        }
        Pair predKey = Pair.create((Object)fileEditor, (Object)predecessorId);
        ScheduledPass predecessor = toBeSubmitted.get(predKey);
        if (predecessor == null) {
            TextEditorHighlightingPass textEditorPass = PassExecutorService.findPassById(predecessorId, textEditorHighlightingPasses);
            predecessor = textEditorPass == null ? null : this.createScheduledPass(fileEditor, textEditorPass, toBeSubmitted, textEditorHighlightingPasses, freePasses, dependentPasses, updateProgress, myThreadsToStartCountdown);
        }
        return predecessor;
    }

    private static TextEditorHighlightingPass findPassById(int id, @NotNull List<TextEditorHighlightingPass> textEditorHighlightingPasses) {
        if (textEditorHighlightingPasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditorHighlightingPasses", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "findPassById"));
        }
        return (TextEditorHighlightingPass)ContainerUtil.find(textEditorHighlightingPasses, pass -> pass.getId() == id);
    }

    private void submit(@NotNull ScheduledPass pass) {
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "submit"));
        }
        if (!pass.myUpdateProgress.isCanceled()) {
            Job<Void> job = JobLauncher.getInstance().submitToJobThread(pass, (Consumer<Future>)((Consumer)future2 -> {
                try {
                    if (!future2.isCancelled()) {
                        future2.get();
                    }
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    LOG.error(e.getCause());
                }
            }));
            this.mySubmittedPasses.put(pass, job);
        }
    }

    private void applyInformationToEditorsLater(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator updateProgress, @NotNull AtomicInteger threadsToStartCountdown) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (pass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (updateProgress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProgress", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        if (threadsToStartCountdown == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadsToStartCountdown", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "applyInformationToEditorsLater"));
        }
        ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> {
            if (updateProgress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateProgress", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "lambda$applyInformationToEditorsLater$3"));
            }
            if (pass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "lambda$applyInformationToEditorsLater$3"));
            }
            if (fileEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "lambda$applyInformationToEditorsLater$3"));
            }
            if (threadsToStartCountdown == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadsToStartCountdown", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "lambda$applyInformationToEditorsLater$3"));
            }
            if (this.isDisposed() || this.myProject.isDisposed()) {
                updateProgress.cancel();
            }
            if (updateProgress.isCanceled()) {
                PassExecutorService.log(updateProgress, pass, " is canceled during apply, sorry");
                return;
            }
            Document document = pass.getDocument();
            try {
                if (fileEditor.getComponent().isDisplayable() || ApplicationManager.getApplication().isUnitTestMode()) {
                    pass.applyInformationToEditor();
                    FileStatusMap fileStatusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
                    if (document != null) {
                        fileStatusMap.markFileUpToDate(document, pass.getId());
                    }
                    PassExecutorService.log(updateProgress, pass, " Applied");
                }
            }
            catch (ProcessCanceledException e) {
                PassExecutorService.log(updateProgress, pass, "Error " + (Object)((Object)e));
                throw e;
            }
            catch (RuntimeException e) {
                VirtualFile file2 = document == null ? null : FileDocumentManager.getInstance().getFile(document);
                FileType fileType = file2 == null ? null : file2.getFileType();
                String message = "Exception while applying information to " + fileEditor + "(" + fileType + ")";
                PassExecutorService.log(updateProgress, pass, message + e);
                throw new RuntimeException(message, e);
            }
            if (threadsToStartCountdown.decrementAndGet() == 0) {
                PassExecutorService.log(updateProgress, pass, "Stopping ");
                updateProgress.stopIfRunning();
            } else {
                PassExecutorService.log(updateProgress, pass, "Finished but there are passes in the queue: " + threadsToStartCountdown.get());
            }
        }), Registry.is((String)"ide.perProjectModality") ? ModalityState.defaultModalityState() : ModalityState.stateForComponent((Component)fileEditor.getComponent()));
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    @NotNull
    List<TextEditorHighlightingPass> getAllSubmittedPasses() {
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(this.mySubmittedPasses.size());
        for (ScheduledPass scheduledPass : this.mySubmittedPasses.keySet()) {
            if (scheduledPass.myUpdateProgress.isCanceled()) continue;
            result2.add(scheduledPass.myPass);
        }
        PassExecutorService.sortById(result2);
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getAllSubmittedPasses"));
        }
        return arrayList;
    }

    private static void sortById(@NotNull List<TextEditorHighlightingPass> result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "sortById"));
        }
        ContainerUtil.quickSort(result2, (o1, o2) -> o1.getId() - o2.getId());
    }

    private static int getThreadNum() {
        Matcher matcher = Pattern.compile("JobScheduler FJ pool (\\d*)/(\\d*)").matcher(Thread.currentThread().getName());
        String num = matcher.matches() ? matcher.group(1) : null;
        return StringUtil.parseInt((String)num, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void log(ProgressIndicator progressIndicator, TextEditorHighlightingPass pass, Object ... info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "log"));
        }
        if (!LOG.isDebugEnabled()) return;
        String docText = pass == null || pass.getDocument() == null ? "" : ": '" + StringUtil.first((CharSequence)pass.getDocument().getCharsSequence(), (int)10, (boolean)true) + "'";
        Class<PassExecutorService> clazz = PassExecutorService.class;
        synchronized (PassExecutorService.class) {
            String infos = StringUtil.join((Object[])info, (Function)Functions.TO_STRING(), (String)" ");
            String message = StringUtil.repeatSymbol((char)' ', (int)(PassExecutorService.getThreadNum() * 4)) + " " + pass + " " + infos + "; progress=" + (progressIndicator == null ? null : Integer.valueOf(progressIndicator.hashCode())) + " " + (progressIndicator == null ? "?" : (progressIndicator.isCanceled() ? "X" : "V")) + docText;
            LOG.debug(message);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static void saveException(@NotNull Throwable e, @NotNull DaemonProgressIndicator indicator) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "saveException"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "saveException"));
        }
        indicator.putUserDataIfAbsent(THROWABLE_KEY, e);
    }

    static Throwable getSavedException(@NotNull DaemonProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/PassExecutorService", "getSavedException"));
        }
        return (Throwable)indicator.getUserData(THROWABLE_KEY);
    }

    boolean waitFor(int millis) throws Throwable {
        try {
            for (Job<Void> job : this.mySubmittedPasses.values()) {
                job.waitForCompletion(millis);
            }
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private class ScheduledPass
    implements Runnable {
        private final FileEditor myFileEditor;
        private final TextEditorHighlightingPass myPass;
        private final AtomicInteger myThreadsToStartCountdown;
        private final AtomicInteger myRunningPredecessorsCount;
        private final Collection<ScheduledPass> mySuccessorsOnCompletion;
        private final Collection<ScheduledPass> mySuccessorsOnSubmit;
        private final DaemonProgressIndicator myUpdateProgress;

        private ScheduledPass(@NotNull FileEditor fileEditor, @NotNull TextEditorHighlightingPass pass, @NotNull DaemonProgressIndicator progressIndicator, AtomicInteger threadsToStartCountdown) {
            if (fileEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (pass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pass", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (progressIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            if (threadsToStartCountdown == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadsToStartCountdown", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "<init>"));
            }
            this.myRunningPredecessorsCount = new AtomicInteger(0);
            this.mySuccessorsOnCompletion = new ArrayList<ScheduledPass>();
            this.mySuccessorsOnSubmit = new ArrayList<ScheduledPass>();
            this.myFileEditor = fileEditor;
            this.myPass = pass;
            this.myThreadsToStartCountdown = threadsToStartCountdown;
            this.myUpdateProgress = progressIndicator;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Error | RuntimeException e) {
                PassExecutorService.saveException(e, this.myUpdateProgress);
                throw e;
            }
        }

        private void doRun() {
            int predecessorsToRun;
            if (this.myUpdateProgress.isCanceled()) {
                return;
            }
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Started. ");
            for (ScheduledPass successor : this.mySuccessorsOnSubmit) {
                predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                if (predecessorsToRun != 0) continue;
                PassExecutorService.this.submit(successor);
            }
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                boolean success = ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    try {
                        if (DumbService.getInstance((Project)PassExecutorService.this.myProject).isDumb() && !DumbService.isDumbAware((Object)this.myPass)) {
                            return;
                        }
                        if (!this.myUpdateProgress.isCanceled() && !PassExecutorService.this.myProject.isDisposed()) {
                            this.myPass.collectInformation(this.myUpdateProgress);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        PassExecutorService.log(this.myUpdateProgress, this.myPass, "Canceled ");
                        if (!this.myUpdateProgress.isCanceled()) {
                            this.myUpdateProgress.cancel(e);
                        }
                    }
                    catch (Error | RuntimeException e) {
                        this.myUpdateProgress.cancel(e);
                        LOG.error(e);
                        throw e;
                    }
                });
                if (!success) {
                    this.myUpdateProgress.cancel();
                }
            }, (ProgressIndicator)this.myUpdateProgress);
            PassExecutorService.log(this.myUpdateProgress, this.myPass, "Finished. ");
            if (!this.myUpdateProgress.isCanceled()) {
                PassExecutorService.this.applyInformationToEditorsLater(this.myFileEditor, this.myPass, this.myUpdateProgress, this.myThreadsToStartCountdown);
                for (ScheduledPass successor : this.mySuccessorsOnCompletion) {
                    predecessorsToRun = successor.myRunningPredecessorsCount.decrementAndGet();
                    if (predecessorsToRun != 0) continue;
                    PassExecutorService.this.submit(successor);
                }
            }
        }

        @NonNls
        public String toString() {
            return "SP: " + this.myPass;
        }

        private void addSuccessorOnCompletion(@NotNull ScheduledPass successor) {
            if (successor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successor", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "addSuccessorOnCompletion"));
            }
            this.mySuccessorsOnCompletion.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }

        private void addSuccessorOnSubmit(@NotNull ScheduledPass successor) {
            if (successor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successor", "com/intellij/codeInsight/daemon/impl/PassExecutorService$ScheduledPass", "addSuccessorOnSubmit"));
            }
            this.mySuccessorsOnSubmit.add(successor);
            successor.myRunningPredecessorsCount.incrementAndGet();
        }
    }
}

