/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public class SdkSetupNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    static final Key<EditorNotificationPanel> KEY = Key.create((String)"SdkSetupNotification");
    private final Project myProject;

    public SdkSetupNotificationProvider(Project project2, final EditorNotifications notifications) {
        this.myProject = project2;
        this.myProject.getMessageBus().connect((Disposable)project2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "getKey"));
        }
        return key2;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        ProjectSdkSetupValidator[] validators;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "createNotificationPanel"));
        }
        for (ProjectSdkSetupValidator validator : validators = (ProjectSdkSetupValidator[])Extensions.getExtensions(ProjectSdkSetupValidator.PROJECT_SDK_SETUP_VALIDATOR_EP)) {
            if (!validator.isApplicableFor(this.myProject, file2)) continue;
            String errorMessage = validator.getErrorMessage(this.myProject, file2);
            if (errorMessage != null) {
                return SdkSetupNotificationProvider.createPanel(errorMessage, () -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "lambda$createNotificationPanel$0"));
                    }
                    validator.doFix(this.myProject, file2);
                });
            }
            return null;
        }
        return null;
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull String message, @NotNull Runnable fix) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "createPanel"));
        }
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "createPanel"));
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(message);
        panel2.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), fix);
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/SdkSetupNotificationProvider", "createPanel"));
        }
        return editorNotificationPanel;
    }
}

