/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedSymbolUtil {
    private static final ImplicitUsageProvider[] ourImplicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);

    public static boolean isInjected(@NotNull Project project2, @NotNull PsiModifierListOwner modifierListOwner) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isInjected"));
        }
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isInjected"));
        }
        return EntryPointsManagerBase.getInstance(project2).isEntryPoint((PsiElement)modifierListOwner);
    }

    public static boolean isImplicitUsage(@NotNull Project project2, @NotNull PsiModifierListOwner element, @NotNull ProgressIndicator progress) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitUsage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitUsage"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitUsage"));
        }
        if (UnusedSymbolUtil.isInjected(project2, element)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@NotNull Project project2, @NotNull PsiVariable element, @NotNull ProgressIndicator progress) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitRead"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitRead"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitRead"));
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return UnusedSymbolUtil.isInjected(project2, (PsiModifierListOwner)element);
    }

    public static boolean isImplicitWrite(@NotNull Project project2, @NotNull PsiVariable element, @NotNull ProgressIndicator progress) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitWrite"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitWrite"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isImplicitWrite"));
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance((Project)project2).isImplicitWrite((PsiElement)element);
    }

    @Nullable
    public static HighlightInfo createUnusedSymbolInfo(@NotNull PsiElement element, @NotNull String message, @NotNull HighlightInfoType highlightInfoType) {
        UnusedDeclarationFixProvider[] fixProviders;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "createUnusedSymbolInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "createUnusedSymbolInfo"));
        }
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "createUnusedSymbolInfo"));
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(element).descriptionAndTooltip(message).create();
        if (info == null) {
            return null;
        }
        for (UnusedDeclarationFixProvider provider : fixProviders = (UnusedDeclarationFixProvider[])Extensions.getExtensions((ExtensionPointName)UnusedDeclarationFixProvider.EP_NAME)) {
            IntentionAction[] fixes;
            for (IntentionAction fix : fixes = provider.getQuickFixes(element)) {
                QuickFixAction.registerQuickFixAction(info, fix);
            }
        }
        return info;
    }

    public static boolean isFieldUnused(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiField field, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isFieldUnused"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isFieldUnused"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isFieldUnused"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isFieldUnused"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isFieldUnused"));
        }
        if (helper.isLocallyUsed((PsiNamedElement)field)) {
            return false;
        }
        if (field instanceof PsiEnumConstant && UnusedSymbolUtil.isEnumValuesMethodUsed(project2, containingFile, (PsiMember)field, progress, helper)) {
            return false;
        }
        return UnusedSymbolUtil.weAreSureThereAreNoUsages(project2, containingFile, (PsiMember)field, progress, helper);
    }

    public static boolean isMethodReferenced(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiMethod method2, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isMethodReferenced"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isMethodReferenced"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isMethodReferenced"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isMethodReferenced"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isMethodReferenced"));
        }
        if (helper.isLocallyUsed((PsiNamedElement)method2)) {
            return true;
        }
        boolean isPrivate = method2.hasModifierProperty("private");
        PsiClass containingClass = method2.getContainingClass();
        if (JavaHighlightUtil.isSerializationRelatedMethod(method2, containingClass)) {
            return true;
        }
        if (isPrivate) {
            if (UnusedSymbolUtil.isIntentionalPrivateConstructor(method2, containingClass)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project2, (PsiModifierListOwner)method2, progress)) {
                return true;
            }
            if (!helper.isCurrentFileAlreadyChecked()) {
                return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project2, containingFile, (PsiMember)method2, progress, helper);
            }
        } else {
            boolean isConstructor = method2.isConstructor();
            if (containingClass != null && isConstructor && containingClass.getConstructors().length == 1 && UnusedSymbolUtil.isClassUsed(project2, containingFile, containingClass, progress, helper)) {
                return true;
            }
            if (UnusedSymbolUtil.isImplicitUsage(project2, (PsiModifierListOwner)method2, progress)) {
                return true;
            }
            if (!isConstructor && FindSuperElementsHelper.findSuperElements((PsiElement)method2).length != 0) {
                return true;
            }
            if (!UnusedSymbolUtil.weAreSureThereAreNoUsages(project2, containingFile, (PsiMember)method2, progress, helper)) {
                return true;
            }
        }
        return false;
    }

    private static boolean weAreSureThereAreNoUsages(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "weAreSureThereAreNoUsages"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "weAreSureThereAreNoUsages"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "weAreSureThereAreNoUsages"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "weAreSureThereAreNoUsages"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "weAreSureThereAreNoUsages"));
        }
        UnusedSymbolUtil.log("* " + member.getName() + ": call wearesure");
        if (!helper.shouldCheckUsages(member)) {
            UnusedSymbolUtil.log("* " + member.getName() + ": should not check");
            return false;
        }
        PsiFile ignoreFile = helper.isCurrentFileAlreadyChecked() ? containingFile : null;
        boolean sure = UnusedSymbolUtil.processUsages(project2, containingFile, member, progress, ignoreFile, (Processor<UsageInfo>)((Processor)info -> {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "lambda$weAreSureThereAreNoUsages$0"));
            }
            PsiFile psiFile = info.getFile();
            if (psiFile == ignoreFile || psiFile == null) {
                return true;
            }
            int offset = info.getNavigationOffset();
            if (offset == -1) {
                return true;
            }
            PsiElement element = psiFile.findElementAt(offset);
            boolean inComment = element instanceof PsiComment;
            UnusedSymbolUtil.log("*     " + member.getName() + ": usage :" + element);
            return inComment;
        }));
        UnusedSymbolUtil.log("*     " + member.getName() + ": result:" + sure);
        return sure;
    }

    private static void log(String s) {
    }

    public static boolean processUsages(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @Nullable PsiFile ignoreFile, @NotNull Processor<UsageInfo> usageInfoProcessor) {
        FindUsagesOptions options;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "processUsages"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "processUsages"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "processUsages"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "processUsages"));
        }
        if (usageInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfoProcessor", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "processUsages"));
        }
        String name = member.getName();
        if (name == null) {
            UnusedSymbolUtil.log("* " + member.getName() + " no name; false");
            return false;
        }
        SearchScope useScope = member.getUseScope();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project2);
        if (useScope instanceof GlobalSearchScope) {
            SearchScope fileScope;
            String propertyName;
            PsiSearchHelper.SearchCostResult cheapEnough;
            if (member instanceof PsiClass) {
                useScope = GlobalSearchScope.projectScope((Project)project2).uniteWith((GlobalSearchScope)useScope);
            }
            PsiSearchHelper.SearchCostResult searchCostResult = cheapEnough = RefResolveService.ENABLED && RefResolveService.getInstance((Project)project2).isUpToDate() ? PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES : searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)useScope, ignoreFile, progress);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many usages; false");
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !UnusedSymbolUtil.canBeReferencedViaWeirdNames(member, containingFile)) {
                UnusedSymbolUtil.log("* " + member.getName() + " 0 usages; true");
                return true;
            }
            if (member instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)member)) != null && (fileScope = containingFile.getUseScope()) instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(propertyName, (GlobalSearchScope)fileScope, ignoreFile, progress) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                UnusedSymbolUtil.log("* " + member.getName() + " too many prop usages; false");
                return false;
            }
        }
        if (member instanceof PsiPackage) {
            options = new JavaPackageFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        } else if (member instanceof PsiClass) {
            options = new JavaClassFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        } else if (member instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)member;
            options = new JavaMethodFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = method2.isConstructor();
        } else if (member instanceof PsiVariable) {
            options = new JavaVariableFindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = false;
        } else {
            options = new FindUsagesOptions(useScope);
            options.isSearchForTextOccurrences = true;
        }
        options.isUsages = true;
        return JavaFindUsagesHelper.processElementUsages((PsiElement)member, options, usageInfoProcessor);
    }

    private static boolean isEnumValuesMethodUsed(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isEnumValuesMethodUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isEnumValuesMethodUsed"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isEnumValuesMethodUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isEnumValuesMethodUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isEnumValuesMethodUsed"));
        }
        PsiClass containingClass = member.getContainingClass();
        if (!(containingClass instanceof PsiClassImpl)) {
            return true;
        }
        PsiMethod valuesMethod = ((PsiClassImpl)containingClass).getValuesMethod();
        return valuesMethod == null || UnusedSymbolUtil.isMethodReferenced(project2, containingFile, valuesMethod, progress, helper);
    }

    private static boolean canBeReferencedViaWeirdNames(@NotNull PsiMember member, @NotNull PsiFile containingFile) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "canBeReferencedViaWeirdNames"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "canBeReferencedViaWeirdNames"));
        }
        if (member instanceof PsiClass) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    public static boolean isClassUsed(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isClassUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isClassUsed"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isClassUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isClassUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isClassUsed"));
        }
        Boolean result2 = helper.unusedClassCache.get(aClass);
        if (result2 == null) {
            result2 = UnusedSymbolUtil.isReallyUsed(project2, containingFile, aClass, progress, helper);
            helper.unusedClassCache.put(aClass, result2);
        }
        return result2;
    }

    private static boolean isReallyUsed(@NotNull Project project2, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isReallyUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isReallyUsed"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isReallyUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isReallyUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isReallyUsed"));
        }
        if (UnusedSymbolUtil.isImplicitUsage(project2, (PsiModifierListOwner)aClass, progress) || helper.isLocallyUsed((PsiNamedElement)aClass)) {
            return true;
        }
        if (helper.isCurrentFileAlreadyChecked() && (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter)) {
            return false;
        }
        return !UnusedSymbolUtil.weAreSureThereAreNoUsages(project2, containingFile, (PsiMember)aClass, progress, helper);
    }

    private static boolean isIntentionalPrivateConstructor(@NotNull PsiMethod method2, PsiClass containingClass) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/UnusedSymbolUtil", "isIntentionalPrivateConstructor"));
        }
        return method2.isConstructor() && containingClass != null && containingClass.getConstructors().length == 1;
    }
}

