/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.application.options.editor.AutoImportOptionsConfigurable;
import com.intellij.application.options.editor.JavaAutoImportOptions;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportAction
implements QuestionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.actions.AddImportAction");
    private final Project myProject;
    private final PsiReference myReference;
    private final PsiClass[] myTargetClasses;
    private final Editor myEditor;

    public AddImportAction(@NotNull Project project2, @NotNull PsiReference ref, @NotNull Editor editor, PsiClass ... targetClasses) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction", "<init>"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction", "<init>"));
        }
        if (targetClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClasses", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction", "<init>"));
        }
        this.myProject = project2;
        this.myReference = ref;
        this.myTargetClasses = targetClasses;
        this.myEditor = editor;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (!this.myReference.getElement().isValid()) {
            return false;
        }
        for (PsiClass myTargetClass : this.myTargetClasses) {
            if (myTargetClass.isValid()) continue;
            return false;
        }
        if (this.myTargetClasses.length == 1) {
            this.addImport(this.myReference, this.myTargetClasses[0]);
        } else {
            this.chooseClassAndImport();
        }
        return true;
    }

    private void chooseClassAndImport() {
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])this.myTargetClasses, (PsiReference)this.myReference);
        BaseListPopupStep<PsiClass> step = new BaseListPopupStep<PsiClass>(QuickFixBundle.message("class.to.import.chooser.title", new Object[0]), this.myTargetClasses){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(PsiClass selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> {
                        PsiDocumentManager.getInstance((Project)AddImportAction.this.myProject).commitAllDocuments();
                        AddImportAction.this.addImport(AddImportAction.this.myReference, selectedValue);
                    });
                }
                return AddImportAction.getExcludesStep(selectedValue.getQualifiedName(), AddImportAction.this.myProject);
            }

            public boolean hasSubstep(PsiClass selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiClass value) {
                String string = (String)ObjectUtils.assertNotNull((Object)value.getQualifiedName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$1", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(PsiClass aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                final PopupListElementRenderer baseRenderer = (PopupListElementRenderer)super.getListElementRenderer();
                final DefaultPsiElementCellRenderer psiRenderer = new DefaultPsiElementCellRenderer();
                return new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        JPanel panel2 = new JPanel(new BorderLayout());
                        baseRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        panel2.add((Component)baseRenderer.getNextStepLabel(), "East");
                        panel2.add(psiRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus));
                        return panel2;
                    }
                };
            }
        };
        popup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public static PopupStep getExcludesStep(String qname, final Project project2) {
        if (qname == null) {
            return PopupStep.FINAL_CHOICE;
        }
        List<String> toExclude = AddImportAction.getAllExcludableStrings(qname);
        return new BaseListPopupStep<String>(null, toExclude){

            @NotNull
            public String getTextFor(String value) {
                String string = "Exclude '" + value + "' from auto-import";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction$3", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    AddImportAction.excludeFromImport(project2, selectedValue);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        };
    }

    public static void excludeFromImport(Project project2, String prefix) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project2.isDisposed()) {
                return;
            }
            AutoImportOptionsConfigurable configurable = new AutoImportOptionsConfigurable(project2);
            ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> {
                JavaAutoImportOptions options = (JavaAutoImportOptions)ContainerUtil.findInstance(configurable.getConfigurables(), JavaAutoImportOptions.class);
                options.addExcludePackage(prefix);
            });
        });
    }

    public static List<String> getAllExcludableStrings(@NotNull String qname) {
        if (qname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname", "com/intellij/codeInsight/daemon/impl/actions/AddImportAction", "getAllExcludableStrings"));
        }
        ArrayList<String> toExclude = new ArrayList<String>();
        while (true) {
            toExclude.add(qname);
            int i2 = qname.lastIndexOf(46);
            if (i2 < 0 || i2 == qname.indexOf(46)) break;
            qname = qname.substring(0, i2);
        }
        return toExclude;
    }

    private void addImport(PsiReference ref, PsiClass targetClass) {
        StatisticsManager.getInstance().incUseCount(JavaStatisticsManager.createInfo(null, (PsiMember)targetClass));
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> this._addImport(ref, targetClass))), QuickFixBundle.message("add.import", new Object[0]), null);
    }

    private void _addImport(PsiReference ref, PsiClass targetClass) {
        if (!ref.getElement().isValid() || !targetClass.isValid() || ref.resolve() == targetClass) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(ref.getElement())) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        RangeMarker caretMarker = this.myEditor.getDocument().createRangeMarker(caretOffset, caretOffset);
        int col = this.myEditor.getCaretModel().getLogicalPosition().column;
        int colByOffset = this.myEditor.offsetToLogicalPosition((int)caretOffset).column;
        int virtualSpace = col == colByOffset ? 0 : col - colByOffset;
        int line = this.myEditor.getCaretModel().getLogicalPosition().line;
        LogicalPosition pos = new LogicalPosition(line, 0);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        try {
            this.bindReference(ref, targetClass);
            if (CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
                Document document = this.myEditor.getDocument();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                new OptimizeImportsProcessor(this.myProject, psiFile).runWithoutProgress();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        line = this.myEditor.getCaretModel().getLogicalPosition().line;
        LogicalPosition pos1 = new LogicalPosition(line, col);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos1);
        if (caretMarker.isValid()) {
            LogicalPosition pos2 = this.myEditor.offsetToLogicalPosition(caretMarker.getStartOffset());
            int newCol = pos2.column + virtualSpace;
            this.myEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(pos2.line, newCol));
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void bindReference(PsiReference ref, PsiClass targetClass) {
        ref.bindToElement((PsiElement)targetClass);
    }
}

