/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.UnusedImportProvider;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

class PostHighlightingVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PostHighlightingPass");
    private final LanguageLevel myLanguageLevel;
    private final RefCountHolder myRefCountHolder;
    @NotNull
    private final Project myProject;
    private final PsiFile myFile;
    @NotNull
    private final Document myDocument;
    private boolean myHasRedundantImports;
    private int myCurrentEntryIndex;
    private boolean myHasMissortedImports;
    private final UnusedSymbolLocalInspectionBase myUnusedSymbolInspection;
    private final HighlightDisplayKey myDeadCodeKey;
    private final HighlightInfoType myDeadCodeInfoType;
    private final UnusedDeclarationInspectionBase myDeadCodeInspection;
    private final Map<PsiMethod, Boolean> isOverriddenOrOverrides;

    private void optimizeImportsOnTheFlyLater(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "optimizeImportsOnTheFlyLater"));
        }
        if ((this.myHasRedundantImports || this.myHasMissortedImports) && !progress.isCanceled()) {
            Disposable invokeFixLater = () -> TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, () -> {
                if (!this.myFile.isValid() || !this.myFile.isWritable()) {
                    return;
                }
                IntentionAction optimizeImportsFix = QuickFixFactory.getInstance().createOptimizeImportsFix(true);
                if (optimizeImportsFix.isAvailable(this.myProject, null, this.myFile)) {
                    optimizeImportsFix.invoke(this.myProject, null, this.myFile);
                }
            });
            try {
                Disposer.register((Disposable)((DaemonProgressIndicator)progress), (Disposable)invokeFixLater);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (progress.isCanceled()) {
                Disposer.dispose((Disposable)invokeFixLater);
                Disposer.dispose((Disposable)((DaemonProgressIndicator)progress));
                progress.checkCanceled();
            }
        }
    }

    PostHighlightingVisitor(@NotNull PsiFile file2, @NotNull Document document, @NotNull RefCountHolder refCountHolder) throws ProcessCanceledException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "<init>"));
        }
        if (refCountHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refCountHolder", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "<init>"));
        }
        this.isOverriddenOrOverrides = new ConcurrentFactoryMap<PsiMethod, Boolean>(){

            @Nullable
            protected Boolean create(PsiMethod method2) {
                boolean overrides = SuperMethodsSearch.search((PsiMethod)method2, null, (boolean)true, (boolean)false).findFirst() != null;
                return overrides || OverridingMethodsSearch.search((PsiMethod)method2).findFirst() != null;
            }
        };
        this.myProject = file2.getProject();
        this.myFile = file2;
        this.myDocument = document;
        this.myCurrentEntryIndex = -1;
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)file2);
        this.myRefCountHolder = refCountHolder;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        this.myDeadCodeKey = HighlightDisplayKey.find((String)"unused");
        this.myDeadCodeInspection = (UnusedDeclarationInspectionBase)profile.getUnwrappedTool("unused", (PsiElement)this.myFile);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || this.myDeadCodeInspection != null);
        this.myUnusedSymbolInspection = this.myDeadCodeInspection != null ? this.myDeadCodeInspection.getSharedLocalInspectionTool() : null;
        this.myDeadCodeInfoType = this.myDeadCodeKey == null ? HighlightInfoType.UNUSED_SYMBOL : new HighlightInfoType.HighlightInfoTypeImpl(profile.getErrorLevel(this.myDeadCodeKey, (PsiElement)this.myFile).getSeverity(), HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
    }

    void collectHighlights(@NotNull HighlightInfoHolder result2, @NotNull ProgressIndicator progress) {
        PsiImportList importList;
        HighlightDisplayKey unusedImportKey;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "collectHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "collectHighlights"));
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        boolean unusedSymbolEnabled = profile.isToolEnabled(this.myDeadCodeKey, (PsiElement)this.myFile);
        GlobalUsageHelper globalUsageHelper = this.myRefCountHolder.getGlobalUsageHelper(this.myFile, this.myDeadCodeInspection, unusedSymbolEnabled);
        boolean errorFound = false;
        if (unusedSymbolEnabled) {
            FileViewProvider viewProvider = this.myFile.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                progress.checkCanceled();
                PsiFile psiRoot = viewProvider.getPsi(language);
                if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot)) continue;
                List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, 0, this.myFile.getTextLength());
                for (PsiElement element : elements) {
                    PsiIdentifier identifier;
                    HighlightInfo info;
                    progress.checkCanceled();
                    if (!(element instanceof PsiIdentifier) || (info = this.processIdentifier(identifier = (PsiIdentifier)element, progress, globalUsageHelper)) == null) continue;
                    errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                    result2.add(info);
                }
            }
        }
        if (this.isUnusedImportEnabled(unusedImportKey = HighlightDisplayKey.find((String)"UNUSED_IMPORT")) && (importList = ((PsiJavaFile)this.myFile).getImportList()) != null) {
            PsiImportStatementBase[] imports;
            for (PsiImportStatementBase statement2 : imports = importList.getAllImportStatements()) {
                progress.checkCanceled();
                HighlightInfo info = this.processImport(statement2, unusedImportKey);
                if (info == null) continue;
                errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                result2.add(info);
            }
        }
        if (errorFound) {
            fileStatusMap.setErrorFoundFlag(this.myProject, this.myDocument, true);
        }
        this.optimizeImportsOnTheFlyLater(progress);
    }

    private boolean isUnusedImportEnabled(HighlightDisplayKey unusedImportKey) {
        ImplicitUsageProvider[] implicitUsageProviders;
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        if (profile.isToolEnabled(unusedImportKey, (PsiElement)this.myFile) && this.myFile instanceof PsiJavaFile && HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)this.myFile)) {
            return true;
        }
        for (ImplicitUsageProvider provider : implicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
            if (!(provider instanceof UnusedImportProvider) || !((UnusedImportProvider)provider).isUnusedImportEnabled((PsiElement)this.myFile)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private HighlightInfo processIdentifier(@NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        PsiElement declarationScope;
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processIdentifier"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processIdentifier"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processIdentifier"));
        }
        PsiElement parent = identifier.getParent();
        if (!(parent instanceof PsiVariable) && !(parent instanceof PsiMember)) {
            return null;
        }
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)identifier, (LocalInspectionTool)this.myUnusedSymbolInspection)) {
            return null;
        }
        if (parent instanceof PsiLocalVariable && this.myUnusedSymbolInspection.LOCAL_VARIABLE) {
            return this.processLocalVariable((PsiLocalVariable)parent, identifier, progress);
        }
        if (parent instanceof PsiField && PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, this.myUnusedSymbolInspection.getFieldVisibility())) {
            return this.processField(this.myProject, (PsiField)parent, identifier, progress, helper);
        }
        if (parent instanceof PsiParameter && ((declarationScope = ((PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod ? PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)declarationScope, this.myUnusedSymbolInspection.getParameterVisibility()) : this.myUnusedSymbolInspection.LOCAL_VARIABLE)) {
            if (SuppressionUtil.isSuppressed((PsiElement)identifier, "UnusedParameters")) {
                return null;
            }
            return this.processParameter(this.myProject, (PsiParameter)parent, identifier, progress);
        }
        if (parent instanceof PsiMethod) {
            if (this.myUnusedSymbolInspection.isIgnoreAccessors() && PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)parent))) {
                return null;
            }
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, this.myUnusedSymbolInspection.getMethodVisibility())) {
                return this.processMethod(this.myProject, (PsiMethod)parent, identifier, progress, helper);
            }
        }
        if (parent instanceof PsiClass) {
            String acceptedVisibility;
            String string = acceptedVisibility = ((PsiClass)parent).getContainingClass() == null ? this.myUnusedSymbolInspection.getClassVisibility() : this.myUnusedSymbolInspection.getInnerClassVisibility();
            if (PostHighlightingVisitor.compareVisibilities((PsiModifierListOwner)parent, acceptedVisibility)) {
                return this.processClass(this.myProject, (PsiClass)parent, identifier, progress, helper);
            }
        }
        return null;
    }

    private static boolean compareVisibilities(PsiModifierListOwner listOwner, String visibility) {
        if (visibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)listOwner.getModifierList()), (String)visibility) >= 0) {
                    return true;
                }
                listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)listOwner, PsiModifierListOwner.class, (boolean)true);
            }
        }
        return false;
    }

    @Nullable
    private HighlightInfo processLocalVariable(@NotNull PsiLocalVariable variable, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processLocalVariable"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processLocalVariable"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processLocalVariable"));
        }
        if (variable instanceof PsiResourceVariable && PsiUtil.isIgnoredName((String)variable.getName())) {
            return null;
        }
        if (UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)variable, progress)) {
            return null;
        }
        if (!this.myRefCountHolder.isReferenced((PsiElement)variable)) {
            String message = JavaErrorMessages.message("local.variable.is.never.used", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
            IntentionAction fix = variable instanceof PsiResourceVariable ? QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)variable) : QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix, this.myDeadCodeKey);
            return highlightInfo;
        }
        boolean referenced = this.myRefCountHolder.isReferencedForRead((PsiVariable)variable);
        if (!referenced && !UnusedSymbolUtil.isImplicitRead(this.myProject, (PsiVariable)variable, progress)) {
            String message = JavaErrorMessages.message("local.variable.is.not.used.for.reading", identifier.getText());
            HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable), this.myDeadCodeKey);
            return highlightInfo;
        }
        if (!(variable.hasInitializer() || (referenced = this.myRefCountHolder.isReferencedForWrite((PsiVariable)variable)) || UnusedSymbolUtil.isImplicitWrite(this.myProject, (PsiVariable)variable, progress))) {
            String message = JavaErrorMessages.message("local.variable.is.not.assigned", identifier.getText());
            HighlightInfo unusedSymbolInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
            QuickFixAction.registerQuickFixAction(unusedSymbolInfo, (IntentionAction)new EmptyIntentionAction(UnusedSymbolLocalInspectionBase.DISPLAY_NAME), this.myDeadCodeKey);
            return unusedSymbolInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo processField(@NotNull Project project2, @NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processField"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processField"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processField"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processField"));
        }
        if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
            return null;
        }
        if (field.hasModifierProperty("private")) {
            QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
            if (!this.myRefCountHolder.isReferenced((PsiElement)field) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.used", identifier.getText());
                HighlightInfo highlightInfo = this.suggestionsToMakeFieldUsed(field, identifier, message);
                if (!field.hasInitializer() && !field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), quickFixFactory.createCreateConstructorParameterFromFieldFix(field));
                }
                return highlightInfo;
            }
            boolean readReferenced = this.myRefCountHolder.isReferencedForRead((PsiVariable)field);
            if (!readReferenced && !UnusedSymbolUtil.isImplicitRead(project2, (PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.used.for.reading", identifier.getText());
                return this.suggestionsToMakeFieldUsed(field, identifier, message);
            }
            if (field.hasInitializer()) {
                return null;
            }
            boolean writeReferenced = this.myRefCountHolder.isReferencedForWrite((PsiVariable)field);
            if (!writeReferenced && !UnusedSymbolUtil.isImplicitWrite(project2, (PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.assigned", identifier.getText());
                HighlightInfo info = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
                QuickFixAction.registerQuickFixAction(info, quickFixFactory.createCreateGetterOrSetterFix(false, true, field), this.myDeadCodeKey);
                if (!field.hasModifierProperty("final")) {
                    QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange((PsiElement)field), quickFixFactory.createCreateConstructorParameterFromFieldFix(field));
                }
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, (Processor<String>)((Processor)annoName -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "lambda$processField$2"));
                    }
                    QuickFixAction.registerQuickFixAction(info, quickFixFactory.createAddToDependencyInjectionAnnotationsFix(project2, annoName, "fields"));
                    return true;
                }));
                return info;
            }
        } else {
            if (UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)field, progress)) {
                return null;
            }
            if (UnusedSymbolUtil.isFieldUnused(this.myProject, this.myFile, field, progress, helper)) {
                return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(project2, "field.is.not.used", (PsiNameIdentifierOwner)field, "fields", this.myDeadCodeKey, this.myDeadCodeInfoType, (PsiElement)identifier);
            }
        }
        return null;
    }

    private HighlightInfo suggestionsToMakeFieldUsed(@NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull String message) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "suggestionsToMakeFieldUsed"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "suggestionsToMakeFieldUsed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "suggestionsToMakeFieldUsed"));
        }
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, false, field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(false, true, field), this.myDeadCodeKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, true, field), this.myDeadCodeKey);
        return highlightInfo;
    }

    private boolean isOverriddenOrOverrides(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "isOverriddenOrOverrides"));
        }
        return this.isOverriddenOrOverrides.get(method2);
    }

    @Nullable
    private HighlightInfo processParameter(@NotNull Project project2, @NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        HighlightInfo highlightInfo;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processParameter"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processParameter"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processParameter"));
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)declarationScope;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)method2)) {
                return null;
            }
            if ((method2.isConstructor() || method2.hasModifierProperty("private") || method2.hasModifierProperty("static") || !method2.hasModifierProperty("abstract") && !this.isOverriddenOrOverrides(method2)) && !method2.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod(method2, method2.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod(method2)) {
                if (UnusedSymbolUtil.isInjected(project2, (PsiModifierListOwner)method2)) {
                    return null;
                }
                HighlightInfo highlightInfo2 = this.checkUnusedParameter(parameter, identifier, progress);
                if (highlightInfo2 != null) {
                    QuickFixFactory.getInstance().registerFixesForUnusedParameter(parameter, (Object)highlightInfo2);
                    return highlightInfo2;
                }
            }
        } else if (declarationScope instanceof PsiForeachStatement && !PsiUtil.isIgnoredName((String)parameter.getName()) && (highlightInfo = this.checkUnusedParameter(parameter, identifier, progress)) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)parameter), this.myDeadCodeKey);
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo checkUnusedParameter(@NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "checkUnusedParameter"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "checkUnusedParameter"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "checkUnusedParameter"));
        }
        if (!this.myRefCountHolder.isReferenced((PsiElement)parameter) && !UnusedSymbolUtil.isImplicitUsage(this.myProject, (PsiModifierListOwner)parameter, progress)) {
            String message = JavaErrorMessages.message("parameter.is.not.used", identifier.getText());
            return UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, this.myDeadCodeInfoType);
        }
        return null;
    }

    @Nullable
    private HighlightInfo processMethod(@NotNull Project project2, @NotNull PsiMethod method2, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processMethod"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processMethod"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processMethod"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processMethod"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processMethod"));
        }
        if (UnusedSymbolUtil.isMethodReferenced(this.myProject, this.myFile, method2, progress, helper)) {
            return null;
        }
        HighlightInfoType highlightInfoType = this.myDeadCodeInfoType;
        HighlightDisplayKey highlightDisplayKey = this.myDeadCodeKey;
        String key2 = method2.hasModifierProperty("private") ? (method2.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used") : (method2.isConstructor() ? "constructor.is.not.used" : "method.is.not.used");
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)method2, PsiSubstitutor.EMPTY);
        String message = JavaErrorMessages.message(key2, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo((PsiElement)identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method2), highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)method2, (Processor<String>)((Processor)annoName -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "lambda$processMethod$3"));
            }
            IntentionAction fix = QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project2, annoName, "methods");
            QuickFixAction.registerQuickFixAction(highlightInfo, fix);
            return true;
        }));
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processClass(@NotNull Project project2, @NotNull PsiClass aClass, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processClass"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processClass"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processClass"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processClass"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processClass"));
        }
        if (UnusedSymbolUtil.isClassUsed(project2, this.myFile, aClass, progress, helper)) {
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = this.myDeadCodeKey;
        HighlightInfoType highlightInfoType = this.myDeadCodeInfoType;
        String pattern = aClass.getContainingClass() != null && aClass.hasModifierProperty("private") ? (aClass.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used") : (aClass.getParent() instanceof PsiDeclarationStatement ? "local.class.is.not.used" : (aClass instanceof PsiTypeParameter ? "type.parameter.is.not.used" : "class.is.not.used"));
        return PostHighlightingVisitor.formatUnusedSymbolHighlightInfo(this.myProject, pattern, (PsiNameIdentifierOwner)aClass, "classes", highlightDisplayKey, highlightInfoType, (PsiElement)identifier);
    }

    private static HighlightInfo formatUnusedSymbolHighlightInfo(@NotNull Project project2, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String pattern, @NotNull PsiNameIdentifierOwner aClass, @NotNull String element, HighlightDisplayKey highlightDisplayKey, @NotNull HighlightInfoType highlightInfoType, @NotNull PsiElement identifier) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "formatUnusedSymbolHighlightInfo"));
        }
        String symbolName = aClass.getName();
        String message = JavaErrorMessages.message(pattern, symbolName);
        HighlightInfo highlightInfo = UnusedSymbolUtil.createUnusedSymbolInfo(identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)aClass), highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)aClass, (Processor<String>)((Processor)annoName -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "lambda$formatUnusedSymbolHighlightInfo$4"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "lambda$formatUnusedSymbolHighlightInfo$4"));
            }
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project2, annoName, element));
            return true;
        }));
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processImport"));
        }
        if (unusedImportKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unusedImportKey", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "processImport"));
        }
        if (importStatement.isForeignFileImport()) {
            return null;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)importStatement)) {
            return null;
        }
        boolean isRedundant = this.myRefCountHolder.isRedundant(importStatement);
        if (!isRedundant && !(importStatement instanceof PsiImportStaticStatement)) {
            String qName;
            PsiElement resolved;
            String packageName = ((PsiClassOwner)importStatement.getContainingFile()).getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                isRedundant = packageName.equals(((PsiQualifiedNamedElement)resolved).getQualifiedName());
            } else if (resolved instanceof PsiClass && !importStatement.isOnDemand() && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                String name = ((PomNamedTarget)resolved).getName();
                isRedundant = qName.equals(packageName + '.' + name);
            }
        }
        if (isRedundant) {
            return this.registerRedundantImport(importStatement, unusedImportKey);
        }
        int entryIndex = JavaCodeStyleManager.getInstance((Project)this.myProject).findEntryIndex(importStatement);
        if (entryIndex < this.myCurrentEntryIndex) {
            this.myHasMissortedImports = true;
        }
        this.myCurrentEntryIndex = entryIndex;
        return null;
    }

    private HighlightInfo registerRedundantImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "registerRedundantImport"));
        }
        if (unusedImportKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unusedImportKey", "com/intellij/codeInsight/daemon/impl/analysis/PostHighlightingVisitor", "registerRedundantImport"));
        }
        String description = InspectionsBundle.message((String)"unused.import.statement", (Object[])new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.UNUSED_IMPORT).range((PsiElement)importStatement).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createOptimizeImportsFix(false), unusedImportKey);
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createEnableOptimizeImportsOnTheFlyFix(), unusedImportKey);
        this.myHasRedundantImports = true;
        return info;
    }
}

