/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix");
    private final PsiMethod myMethodPrototype;
    private final List<String> myExceptions;
    private String myText;

    public AddMethodFix(@NotNull PsiMethod methodPrototype, @NotNull PsiClass implClass) {
        if (methodPrototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodPrototype", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "<init>"));
        }
        if (implClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClass", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "<init>"));
        }
        super((PsiElement)implClass);
        this.myExceptions = new ArrayList<String>();
        this.myMethodPrototype = methodPrototype;
        this.setText(QuickFixBundle.message("add.method.text", methodPrototype.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        if (methodText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodText", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "<init>"));
        }
        if (implClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClass", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "<init>"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "<init>"));
        }
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        ContainerUtil.addAll(this.myExceptions, (Object[])exceptions);
    }

    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        try {
            return JavaPsiFacade.getInstance((Project)implClass.getProject()).getElementFactory().createMethodFromText(methodText, (PsiElement)implClass);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod reformat(Project project2, PsiMethod result2) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        result2 = (PsiMethod)codeStyleManager.reformat((PsiElement)result2);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        result2 = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result2);
        return result2;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "getText"));
        }
        return string;
    }

    protected void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "setText"));
        }
        this.myText = text;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.method.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "isAvailable"));
        }
        PsiClass myClass = (PsiClass)startElement;
        return this.myMethodPrototype.isValid() && myClass.isValid() && myClass.getManager().isInProject((PsiElement)myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)myClass, (PsiMethod)this.myMethodPrototype, (boolean)false) == null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiCodeBlock body;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "invoke"));
        }
        PsiClass myClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myClass.getContainingFile())) {
            return;
        }
        if (myClass.isInterface() && (body = this.myMethodPrototype.getBody()) != null) {
            body.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)this.myMethodPrototype, (String)exception);
        }
        PsiMethod method2 = (PsiMethod)myClass.add((PsiElement)this.myMethodPrototype);
        method2 = (PsiMethod)method2.replace((PsiElement)AddMethodFix.reformat(project2, method2));
        this.postAddAction(file2, editor, method2);
    }

    protected void postAddAction(@NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, PsiMethod newMethod) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix", "postAddAction"));
        }
        if (editor != null && newMethod.getContainingFile() == file2) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)newMethod, true);
        }
    }
}

