/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeToAppendFix
implements IntentionAction {
    private final IElementType myTokenType;
    private final PsiType myLhsType;
    private final PsiAssignmentExpression myAssignmentExpression;
    private volatile TypeInfo myTypeInfo;

    public ChangeToAppendFix(@NotNull IElementType eqOpSign, @NotNull PsiType lType, @NotNull PsiAssignmentExpression assignmentExpression) {
        if (eqOpSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eqOpSign", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        if (assignmentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "<init>"));
        }
        this.myTokenType = eqOpSign;
        this.myLhsType = lType;
        this.myAssignmentExpression = assignmentExpression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.to.append.text", ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getRExpression(), this.getTypeInfo().myUseStringValueOf, new StringBuilder(this.myAssignmentExpression.getLExpression().getText())));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.to.append.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "isAvailable"));
        }
        return JavaTokenType.PLUSEQ == this.myTokenType && this.myAssignmentExpression.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myAssignmentExpression) && this.getTypeInfo().myAppendable;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiExpression appendExpression = ChangeToAppendUtil.buildAppendExpression(this.myAssignmentExpression.getLExpression(), this.myAssignmentExpression.getRExpression());
        if (appendExpression == null) {
            return;
        }
        this.myAssignmentExpression.replace((PsiElement)appendExpression);
    }

    @NotNull
    private TypeInfo getTypeInfo() {
        if (this.myTypeInfo != null) {
            TypeInfo typeInfo = this.myTypeInfo;
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getTypeInfo"));
            }
            return typeInfo;
        }
        TypeInfo typeInfo = this.myTypeInfo = this.calculateTypeInfo();
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "getTypeInfo"));
        }
        return typeInfo;
    }

    @NotNull
    private TypeInfo calculateTypeInfo() {
        if (this.myLhsType.equalsToText("java.lang.StringBuilder") || this.myLhsType.equalsToText("java.lang.StringBuffer")) {
            TypeInfo typeInfo = new TypeInfo(true, false);
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "calculateTypeInfo"));
            }
            return typeInfo;
        }
        if (InheritanceUtil.isInheritor((PsiType)this.myLhsType, (String)"java.lang.Appendable")) {
            TypeInfo typeInfo = new TypeInfo(true, true);
            if (typeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "calculateTypeInfo"));
            }
            return typeInfo;
        }
        TypeInfo typeInfo = new TypeInfo(false, false);
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeToAppendFix", "calculateTypeInfo"));
        }
        return typeInfo;
    }

    private static class TypeInfo {
        private final boolean myAppendable;
        private final boolean myUseStringValueOf;

        TypeInfo(boolean appendable, boolean useStringValueOf) {
            this.myAppendable = appendable;
            this.myUseStringValueOf = useStringValueOf;
        }
    }
}

