/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class CreateInnerClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateInnerClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind) {
        super(kind, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", this.myKind.getDescription(), varName);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null) {
            return;
        }
        String superClassName = this.getSuperClassName(element);
        PsiClass[] targets = CreateInnerClassFromUsageFix.getPossibleTargets(element);
        LOG.assertTrue(targets.length > 0);
        if (targets.length == 1) {
            this.doInvoke(targets[0], superClassName);
        } else {
            this.chooseTargetClass(targets, editor, superClassName);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix", "isAvailable"));
        }
        return super.isAvailable(project2, editor, file2) && CreateInnerClassFromUsageFix.getPossibleTargets(this.getRefElement()).length > 0;
    }

    @NotNull
    private static PsiClass[] getPossibleTargets(PsiJavaCodeReferenceElement element) {
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        PsiJavaCodeReferenceElement run = element;
        PsiMember contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        while (contextMember != null) {
            if (contextMember instanceof PsiClass && !(contextMember instanceof PsiTypeParameter) && !CreateInnerClassFromUsageFix.isUsedInExtends((PsiElement)run, (PsiClass)contextMember)) {
                result2.add((PsiClass)contextMember);
            }
            run = contextMember;
            contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        }
        PsiClass[] psiClassArray = result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix", "getPossibleTargets"));
        }
        return psiClassArray;
    }

    private static boolean isUsedInExtends(PsiElement element, PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getExtendsList();
        PsiReferenceList implementsList = psiClass.getImplementsList();
        if (extendsList != null && PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false)) {
            return true;
        }
        return implementsList != null && PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false);
    }

    private void chooseTargetClass(PsiClass[] classes, Editor editor, String superClassName) {
        Project project2 = classes[0].getProject();
        JBList list = new JBList((Object[])classes);
        PsiClassListCellRenderer renderer = PsiClassListCellRenderer.INSTANCE;
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        Runnable runnable2 = () -> this.lambda$chooseTargetClass$2((JList)list, project2, superClassName);
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(editor);
    }

    private void doInvoke(PsiClass aClass, String superClassName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref = this.getRefElement();
        assert (ref != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)aClass)) {
            return;
        }
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        PsiClass created = this.myKind == CreateClassKind.INTERFACE ? elementFactory.createInterface(refName) : (this.myKind == CreateClassKind.CLASS ? elementFactory.createClass(refName) : elementFactory.createEnum(refName));
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (aClass.isInterface()) {
            modifierList.setModifierProperty("packageLocal", true);
        } else {
            modifierList.setModifierProperty("private", true);
        }
        if (RefactoringUtil.isInStaticContext((PsiElement)ref, aClass)) {
            modifierList.setModifierProperty("static", true);
        }
        if (superClassName != null) {
            CreateFromUsageUtils.setupSuperClassReference(created, superClassName);
        }
        CreateFromUsageBaseFix.setupGenericParameters(created, ref);
        created = (PsiClass)aClass.add((PsiElement)created);
        ref.bindToElement((PsiElement)created);
    }

    private /* synthetic */ void lambda$chooseTargetClass$2(JList list, Project project2, String superClassName) {
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        PsiClass aClass = (PsiClass)list.getSelectedValue();
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.doInvoke(aClass, superClassName);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), this.getText(), null);
    }
}

