/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePrimitiveWithBoxedTypeAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myPrimitiveName;
    private final String myBoxedTypeName;
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplacePrimitiveWithBoxedTypeAction.class.getName()));

    public ReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "<init>"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "<init>"));
        }
        if (boxedTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedTypeName", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "<init>"));
        }
        super((PsiElement)element);
        this.myPrimitiveName = typeName;
        this.myBoxedTypeName = boxedTypeName;
    }

    @NotNull
    public String getText() {
        String string = "Convert '" + this.myPrimitiveName + "' to '" + this.myBoxedTypeName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert primitive to boxed type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "getFamilyName"));
        }
        return "Convert primitive to boxed type";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "isAvailable"));
        }
        if (startElement instanceof PsiTypeElement) {
            PsiType type = ((PsiTypeElement)startElement).getType();
            if (type instanceof PsiWildcardType) {
                type = ((PsiWildcardType)type).getBound();
            }
            if (type instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type).getBoxedType(startElement) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClassType boxedType;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplacePrimitiveWithBoxedTypeAction", "invoke"));
        }
        PsiType type = ((PsiTypeElement)startElement).getType();
        if (type instanceof PsiPrimitiveType) {
            boxedType = ((PsiPrimitiveType)type).getBoxedType(startElement);
        } else {
            LOG.assertTrue(type instanceof PsiWildcardType);
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiClassType boxedBound = ((PsiPrimitiveType)wildcardType.getBound()).getBoxedType(startElement);
            LOG.assertTrue(boxedBound != null);
            boxedType = wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)startElement.getManager(), (PsiType)boxedBound) : PsiWildcardType.createSuper((PsiManager)startElement.getManager(), (PsiType)boxedBound);
        }
        LOG.assertTrue(boxedType != null);
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        startElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createTypeElement((PsiType)boxedType));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

