/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithArrayFix
extends PsiElementBaseIntentionAction {
    private final PsiCall myMethodCall;
    @Nullable
    private final PsiExpression myExpression;

    public SurroundWithArrayFix(@Nullable PsiCall methodCall, @Nullable PsiExpression expression) {
        this.myMethodCall = methodCall;
        this.myExpression = expression;
    }

    @NotNull
    public String getText() {
        if ("Surround with array initialization" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "getText"));
        }
        return "Surround with array initialization";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "isAvailable"));
        }
        return this.getExpression(element) != null;
    }

    @Nullable
    protected PsiExpression getExpression(PsiElement element) {
        if (this.myMethodCall == null || !this.myMethodCall.isValid()) {
            return this.myExpression == null || !this.myExpression.isValid() ? null : this.myExpression;
        }
        PsiMethod method2 = this.myMethodCall.resolveMethod();
        if (method2 != null) {
            PsiMethod psiMethod = method2;
            return this.checkMethod(element, psiMethod);
        }
        if (this.myMethodCall instanceof PsiMethodCallExpression) {
            Collection<PsiElement> psiElements = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)((PsiMethodCallExpression)this.myMethodCall).getMethodExpression());
            for (PsiElement psiElement : psiElements) {
                PsiExpression expression;
                if (!(psiElement instanceof PsiMethod) || (expression = this.checkMethod(element, (PsiMethod)psiElement)) == null) continue;
                return expression;
            }
        }
        return null;
    }

    @Nullable
    private PsiExpression checkMethod(PsiElement element, PsiMethod psiMethod) {
        PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
        int idx = 0;
        for (PsiExpression expression : argumentList.getExpressions()) {
            PsiType expressionType;
            PsiType paramType;
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)element, (boolean)false) && psiParameters.length > idx && (paramType = psiParameters[idx].getType()) instanceof PsiArrayType && (expressionType = expression.getType()) != null) {
                PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                if (expressionType.isAssignableFrom(componentType)) {
                    return expression;
                }
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
                if (ArrayUtilRt.find((Object[])psiMethod.getTypeParameters(), (Object)psiClass) != -1) {
                    for (PsiClassType superType : psiClass.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)expressionType)) continue;
                        return expression;
                    }
                }
            }
            ++idx;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression expression = this.getExpression(element);
        assert (expression != null);
        PsiExpression toReplace = elementFactory.createExpressionFromText(SurroundWithArrayFix.getArrayCreation(expression), element);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(expression.replace((PsiElement)toReplace));
    }

    @NonNls
    private static String getArrayCreation(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix", "getArrayCreation"));
        }
        PsiType expressionType = expression.getType();
        assert (expressionType != null);
        return "new " + expressionType.getCanonicalText() + "[]{" + expression.getText() + "}";
    }
}

