/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix");
    private final PsiType myReturnType;
    protected final String myName;

    public VariableTypeFix(@NotNull PsiVariable variable, PsiType toReturn) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "<init>"));
        }
        super((PsiElement)variable);
        this.myReturnType = GenericsUtil.getVariableTypeByExpressionType((PsiType)toReturn);
        this.myName = variable.getName();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.variable.type.text", UsageViewUtil.getType(this.getStartElement()), this.myName, this.getReturnType().getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.variable.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "isAvailable"));
        }
        PsiVariable myVariable = (PsiVariable)startElement;
        return myVariable.isValid() && myVariable.getTypeElement() != null && myVariable.getManager().isInProject((PsiElement)myVariable) && this.getReturnType() != null && this.getReturnType().isValid() && !TypeConversionUtil.isNullType((PsiType)this.getReturnType()) && !TypeConversionUtil.isVoidType((PsiType)this.getReturnType());
    }

    public void invoke(final @NotNull Project project2, final @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableTypeFix", "invoke"));
        }
        final PsiVariable myVariable = (PsiVariable)startElement;
        if (this.changeMethodSignatureIfNeeded(myVariable)) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
            return;
        }
        new WriteCommandAction.Simple(project2, this.getText(), new PsiFile[]{file2}){

            protected void run() throws Throwable {
                try {
                    myVariable.normalizeDeclaration();
                    PsiTypeElement typeElement = myVariable.getTypeElement();
                    LOG.assertTrue(typeElement != null, myVariable.getClass());
                    PsiTypeElement newTypeElement = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory().createTypeElement(VariableTypeFix.this.getReturnType());
                    typeElement.replace((PsiElement)newTypeElement);
                    JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)myVariable);
                    UndoUtil.markPsiFileForUndo((PsiFile)file2);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }.execute();
    }

    private boolean changeMethodSignatureIfNeeded(PsiVariable myVariable) {
        PsiElement scope;
        if (myVariable instanceof PsiParameter && (scope = ((PsiParameter)myVariable).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)scope;
            PsiMethod psiMethod = SuperMethodWarningUtil.checkSuperMethod(method2, RefactoringBundle.message((String)"to.refactor"));
            if (psiMethod == null) {
                return true;
            }
            int parameterIndex = method2.getParameterList().getParameterIndex((PsiParameter)myVariable);
            if (!FileModificationService.getInstance().prepareFileForWrite(psiMethod.getContainingFile())) {
                return true;
            }
            ArrayList<ParameterInfoImpl> infos = new ArrayList<ParameterInfoImpl>();
            int i2 = 0;
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                boolean changeType = i2 == parameterIndex;
                infos.add(new ParameterInfoImpl(i2++, parameter.getName(), changeType ? this.getReturnType() : parameter.getType()));
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                JavaChangeSignatureDialog dialog2 = new JavaChangeSignatureDialog(psiMethod.getProject(), psiMethod, false, (PsiElement)myVariable);
                dialog2.setParameterInfos(infos);
                dialog2.show();
            } else {
                ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(psiMethod.getProject(), psiMethod, false, null, psiMethod.getName(), psiMethod.getReturnType(), infos.toArray(new ParameterInfoImpl[infos.size()]));
                processor2.run();
            }
            return true;
        }
        return false;
    }

    protected PsiType getReturnType() {
        return this.myReturnType;
    }
}

