/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapObjectWithOptionalOfNullableFix
extends MethodArgumentFix
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(WrapObjectWithOptionalOfNullableFix.class);
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapObjectWithOptionalOfNullableFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "<init>"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "<init>"));
        }
        if (fixerActionFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixerActionFactory", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "<init>"));
        }
        super(list, i2, toType, fixerActionFactory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("wrap.with.optional.parameter.text", this.myIndex + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) && super.isAvailable(project2, editor, file2);
    }

    public static IntentionAction createFix(@Nullable PsiType type, @NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "createFix"));
        }
        class MyFix
        extends LocalQuickFixAndIntentionActionOnPsiElement
        implements HighPriorityAction {
            final /* synthetic */ PsiType val$type;

            protected MyFix(PsiElement psiElement) {
                this.val$type = psiElement;
                super((PsiElement)element);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "getFamilyName"));
                }
                return string;
            }

            public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "invoke"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "invoke"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "invoke"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "invoke"));
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                    return;
                }
                startElement.replace((PsiElement)WrapObjectWithOptionalOfNullableFix.getModifiedExpression((PsiExpression)this.getStartElement()));
            }

            public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "isAvailable"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "isAvailable"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "isAvailable"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "isAvailable"));
                }
                return startElement.isValid() && startElement.getManager().isInProject(startElement) && PsiUtil.isLanguageLevel8OrHigher((PsiElement)startElement) && WrapObjectWithOptionalOfNullableFix.areConvertible(((PsiExpression)startElement).getType(), this.val$type);
            }

            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$1MyFix", "getText"));
                }
                return string;
            }
        }
        return new MyFix((PsiElement)expression, type);
    }

    private static boolean areConvertible(@Nullable PsiType exprType, @Nullable PsiType parameterType) {
        if (!(exprType != null && exprType.isValid() && parameterType instanceof PsiClassType && parameterType.isValid())) {
            return false;
        }
        PsiClassType.ClassResolveResult resolve = ((PsiClassType)parameterType).resolveGenerics();
        PsiClass resolvedClass = resolve.getElement();
        if (resolvedClass == null || !"java.util.Optional".equals(resolvedClass.getQualifiedName())) {
            return false;
        }
        Collection values = resolve.getSubstitutor().getSubstitutionMap().values();
        if (values.size() == 0) {
            return true;
        }
        if (values.size() > 1) {
            return false;
        }
        PsiType optionalTypeParameter = (PsiType)ContainerUtil.getFirstItem(values);
        if (optionalTypeParameter == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable((PsiType)optionalTypeParameter, (PsiType)exprType);
    }

    @NotNull
    private static PsiExpression getModifiedExpression(PsiExpression expression) {
        PsiElement resolved;
        Project project2 = expression.getProject();
        PsiMethod toCheckNullability = null;
        if (expression instanceof PsiMethodCallExpression) {
            toCheckNullability = ((PsiMethodCallExpression)expression).resolveMethod();
        } else if (expression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expression).resolve()) instanceof PsiModifierListOwner) {
            toCheckNullability = (PsiModifierListOwner)resolved;
        }
        Nullness nullability = toCheckNullability == null ? Nullness.NOT_NULL : DfaPsiUtil.getElementNullability(expression.getType(), (PsiModifierListOwner)toCheckNullability);
        String methodName = nullability == Nullness.NOT_NULL ? "of" : "ofNullable";
        String newExpressionText = "java.util.Optional." + methodName + "(" + expression.getText() + ")";
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(newExpressionText, (PsiElement)expression);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix", "getModifiedExpression"));
        }
        return psiExpression;
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return WrapObjectWithOptionalOfNullableFix.getModifiedExpression(expression);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            return parameterType.isConvertibleFrom(exprType) || WrapObjectWithOptionalOfNullableFix.areConvertible(exprType, parameterType);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new WrapObjectWithOptionalOfNullableFix(list, i2, toType, this);
        }
    }

    public static class MyIntentionAction
    extends LocalQuickFixAndIntentionActionOnPsiElement
    implements HighPriorityAction {
        @Nullable
        private final PsiType myType;

        protected MyIntentionAction(@NotNull PsiExpression element, @Nullable PsiType type) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "<init>"));
            }
            super((PsiElement)element);
            this.myType = type;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "invoke"));
            }
            startElement.replace((PsiElement)WrapObjectWithOptionalOfNullableFix.getModifiedExpression((PsiExpression)this.getStartElement()));
        }

        public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "isAvailable"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "isAvailable"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "isAvailable"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "isAvailable"));
            }
            return startElement.isValid() && startElement.getManager().isInProject(startElement) && PsiUtil.isLanguageLevel8OrHigher((PsiElement)startElement) && WrapObjectWithOptionalOfNullableFix.areConvertible(((PsiExpression)startElement).getType(), this.myType);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyIntentionAction", "getText"));
            }
            return string;
        }
    }
}

