/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.JavaParameterHintManager;
import com.intellij.codeInsight.hints.MethodInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "defaultBlackList", "", "", "getDefaultBlackList", "()Ljava/util/Set;", "getMethodInfo", "Lcom/intellij/codeInsight/hints/MethodInfo;", "element", "Lcom/intellij/psi/PsiElement;", "method", "Lcom/intellij/psi/PsiMethod;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "java-impl"})
public final class JavaInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    private final Set<String> defaultBlackList = SetsKt.setOf((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "*Exception", "*.add(*)", "*.set(*,*)", "*.get(*)", "*.create(*)", "*.getProperty(*)", "*.setProperty(*,*)", "*.print(*)", "*.println(*)", "*.append(*)", "*.charAt(*)", "*.indexOf(*)", "*.contains(*)", "*.startsWith(*)", "*.endsWith(*)", "*.equals(*)", "*.equal(*)", "java.lang.Math.*", "org.slf4j.Logger.*"});

    @Nullable
    public MethodInfo getMethodInfo(@NotNull PsiElement element) {
        PsiElement resolvedElement;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCallExpression && (resolvedElement = ((PsiCallExpression)element).resolveMethodGenerics().getElement()) instanceof PsiMethod) {
            return this.getMethodInfo((PsiMethod)resolvedElement);
        }
        return null;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCallExpression) {
            List<InlayInfo> list = new JavaParameterHintManager((PsiCallExpression)element).getDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"JavaParameterHintManager(element).descriptors");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final MethodInfo getMethodInfo(PsiMethod method2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        PsiClass psiClass = method2.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass containingClass = psiClass;
        String fullMethodName = StringUtil.getQualifiedName((String)containingClass.getQualifiedName(), (String)method2.getName());
        Object[] objectArray = method2.getParameterList().getParameters();
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(((void)$receiver$iv).length);
        for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
            void it;
            void item$iv$iv = $receiver$iv$iv[j];
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            void var14_10 = destination$iv$iv;
            String string = it.getName();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            var14_10.add(string2);
        }
        List paramNames = (List)destination$iv$iv;
        String string = fullMethodName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fullMethodName");
        return new MethodInfo(string, paramNames);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return this.defaultBlackList;
    }

    @Nullable
    public Language getBlackListDependencyLanguage() {
        return InlayParameterHintsProvider.DefaultImpls.getBlackListDependencyLanguage((InlayParameterHintsProvider)this);
    }
}

