/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParameterHintManager {
    @NotNull
    private final List<InlayInfo> myDescriptors;

    public JavaParameterHintManager(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInsight/hints/JavaParameterHintManager", "<init>"));
        }
        PsiExpression[] callArguments = JavaParameterHintManager.getArguments(callExpression);
        JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
        List<Object> descriptors = Collections.emptyList();
        if (resolveResult.getElement() instanceof PsiMethod && JavaParameterHintManager.isMethodToShowParams(callExpression, resolveResult) && JavaParameterHintManager.hasUnclearExpressions(callArguments)) {
            PsiMethod method2 = (PsiMethod)resolveResult.getElement();
            PsiParameter[] parameters = method2.getParameterList().getParameters();
            descriptors = JavaParameterHintManager.buildDescriptorsForLiteralArguments(callArguments, parameters, resolveResult);
        }
        this.myDescriptors = descriptors;
    }

    private static boolean isMethodToShowParams(@NotNull PsiCallExpression callExpression, @NotNull JavaResolveResult resolveResult) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInsight/hints/JavaParameterHintManager", "isMethodToShowParams"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/hints/JavaParameterHintManager", "isMethodToShowParams"));
        }
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            return !JavaParameterHintManager.isSetter(method2) && !JavaParameterHintManager.isBuilder(callExpression, method2);
        }
        return false;
    }

    private static boolean isBuilder(PsiCallExpression expression, PsiMethod method2) {
        String calledMethodFqn;
        if (expression instanceof PsiNewExpression) {
            return false;
        }
        PsiType returnType = TypeConversionUtil.erasure((PsiType)method2.getReturnType());
        PsiClass aClass = method2.getContainingClass();
        String string = calledMethodFqn = aClass != null ? aClass.getQualifiedName() : null;
        if (calledMethodFqn != null && returnType != null) {
            return returnType.equalsToText(calledMethodFqn);
        }
        return false;
    }

    private static boolean hasSingleParameter(PsiMethod method2) {
        return method2.getParameterList().getParametersCount() == 1;
    }

    private static boolean isSetter(PsiMethod method2) {
        String methodName = method2.getName();
        return JavaParameterHintManager.hasSingleParameter(method2) && methodName.startsWith("set") && (methodName.length() == 3 || methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)));
    }

    static boolean isUnclearExpression(@Nullable PsiElement callArgument) {
        if (callArgument instanceof PsiLiteralExpression) {
            return true;
        }
        if (callArgument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expr = (PsiPrefixExpression)callArgument;
            IElementType tokenType = expr.getOperationTokenType();
            return (JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType)) && expr.getOperand() instanceof PsiLiteralExpression;
        }
        return callArgument instanceof PsiThisExpression || callArgument instanceof PsiBinaryExpression || callArgument instanceof PsiPolyadicExpression;
    }

    @NotNull
    private static PsiExpression[] getArguments(@NotNull PsiCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/hints/JavaParameterHintManager", "getArguments"));
        }
        PsiExpressionList callArgumentsList = call.getArgumentList();
        PsiExpression[] psiExpressionArray = callArgumentsList == null ? PsiExpression.EMPTY_ARRAY : callArgumentsList.getExpressions();
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/JavaParameterHintManager", "getArguments"));
        }
        return psiExpressionArray;
    }

    @NotNull
    public List<InlayInfo> getDescriptors() {
        List<InlayInfo> list = this.myDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/JavaParameterHintManager", "getDescriptors"));
        }
        return list;
    }

    @NotNull
    private static List<InlayInfo> buildDescriptorsForLiteralArguments(@NotNull PsiExpression[] callArguments, @NotNull PsiParameter[] parameters, @NotNull JavaResolveResult resolveResult) {
        if (callArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArguments", "com/intellij/codeInsight/hints/JavaParameterHintManager", "buildDescriptorsForLiteralArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/hints/JavaParameterHintManager", "buildDescriptorsForLiteralArguments"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/hints/JavaParameterHintManager", "buildDescriptorsForLiteralArguments"));
        }
        ArrayList descriptors = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < Math.min(callArguments.length, parameters.length); ++i2) {
            PsiExpression arg = callArguments[i2];
            PsiParameter param = parameters[i2];
            if ((!JavaParameterHintManager.isVarargParam(param.getType(), arg.getType()) || !JavaParameterHintManager.hasUnclearExpressionStartingFrom(i2, callArguments)) && !JavaParameterHintManager.shouldInlineParameterName(arg, param, resolveResult)) continue;
            descriptors.add(JavaParameterHintManager.createInlayInfo(arg, param));
        }
        ArrayList arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/JavaParameterHintManager", "buildDescriptorsForLiteralArguments"));
        }
        return arrayList;
    }

    @NotNull
    private static InlayInfo createInlayInfo(@NotNull PsiExpression callArgument, @NotNull PsiParameter methodParam) {
        if (callArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArgument", "com/intellij/codeInsight/hints/JavaParameterHintManager", "createInlayInfo"));
        }
        if (methodParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParam", "com/intellij/codeInsight/hints/JavaParameterHintManager", "createInlayInfo"));
        }
        String paramName = (methodParam.getType() instanceof PsiEllipsisType ? "..." : "") + methodParam.getName();
        InlayInfo inlayInfo = new InlayInfo(paramName, callArgument.getTextRange().getStartOffset());
        if (inlayInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/JavaParameterHintManager", "createInlayInfo"));
        }
        return inlayInfo;
    }

    private static boolean shouldInlineParameterName(@NotNull PsiExpression argument, @NotNull PsiParameter parameter, @NotNull JavaResolveResult resolveResult) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/hints/JavaParameterHintManager", "shouldInlineParameterName"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/hints/JavaParameterHintManager", "shouldInlineParameterName"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/hints/JavaParameterHintManager", "shouldInlineParameterName"));
        }
        PsiType argType = argument.getType();
        PsiType paramType = parameter.getType();
        if (argType != null && JavaParameterHintManager.isUnclearExpression((PsiElement)argument)) {
            PsiType parameterType = resolveResult.getSubstitutor().substitute(paramType);
            return TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argType);
        }
        return false;
    }

    private static boolean hasUnclearExpressionStartingFrom(int index, PsiExpression[] callArguments) {
        for (int i2 = index; i2 < callArguments.length; ++i2) {
            PsiExpression arg = callArguments[i2];
            if (!JavaParameterHintManager.isUnclearExpression((PsiElement)arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVarargParam(@Nullable PsiType paramType, @Nullable PsiType argType) {
        if (paramType == null || argType == null) {
            return false;
        }
        PsiType deepType = paramType.getDeepComponentType();
        return paramType instanceof PsiEllipsisType && TypeConversionUtil.isAssignable((PsiType)deepType, (PsiType)argType);
    }

    private static boolean hasUnclearExpressions(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/hints/JavaParameterHintManager", "hasUnclearExpressions"));
        }
        for (PsiExpression argument : arguments) {
            if (!JavaParameterHintManager.isUnclearExpression((PsiElement)argument)) continue;
            return true;
        }
        return false;
    }
}

