/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfo;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private static final Key<Boolean> REPEATED_PASS = Key.create((String)"RepeatedParameterHintsPass");

    public ParameterHintsPassFactory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
        super(project2);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        return new ParameterHintsPass(file2, editor);
    }

    private static class ParameterHintsPass
    extends EditorBoundHighlightingPass {
        private final Map<Integer, String> myAnnotations;

        private ParameterHintsPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hints/ParameterHintsPassFactory$ParameterHintsPass", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPassFactory$ParameterHintsPass", "<init>"));
            }
            super(editor, file2, true);
            this.myAnnotations = new HashMap<Integer, String>();
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/hints/ParameterHintsPassFactory$ParameterHintsPass", "doCollectInformation"));
            }
            assert (this.myDocument != null);
            this.myAnnotations.clear();
            if (!ParameterHintsPass.isEnabled()) {
                return;
            }
            Language language = this.myFile.getLanguage();
            InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
            if (provider == null) {
                return;
            }
            Set<String> blackList = ParameterHintsPass.getBlackList(language);
            Language dependentLanguage = provider.getBlackListDependencyLanguage();
            if (dependentLanguage != null) {
                blackList.addAll(ParameterHintsPass.getBlackList(dependentLanguage));
            }
            List matchers = blackList.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher((String)item)).filter(e -> e != null).collect(Collectors.toList());
            SyntaxTraverser.psiTraverser((PsiElement)this.myFile).forEach(element -> this.process((PsiElement)element, provider, matchers));
        }

        private static Set<String> getBlackList(Language language) {
            InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
            if (provider != null) {
                ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
                Diff diff = settings.getBlackListDiff(language);
                return diff.applyOn(provider.getDefaultBlackList());
            }
            return ContainerUtil.newHashOrEmptySet((Iterable)ContainerUtil.emptyIterable());
        }

        private static boolean isEnabled() {
            return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
        }

        private static boolean isMatchedByAny(MethodInfo info, List<Matcher> matchers) {
            return matchers.stream().anyMatch(e -> e.isMatching(info.getFullyQualifiedName(), info.getParamNames()));
        }

        private void process(PsiElement element, InlayParameterHintsProvider provider, List<Matcher> blackListMatchers) {
            List hints = provider.getParameterHints(element);
            if (hints.isEmpty()) {
                return;
            }
            MethodInfo info = provider.getMethodInfo(element);
            if (info != null && !ParameterHintsPass.isMatchedByAny(info, blackListMatchers)) {
                hints.forEach(h -> this.myAnnotations.put(h.getOffset(), h.getText()));
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            int offset;
            assert (this.myDocument != null);
            boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
            ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
            HashSet removedHints = new HashSet();
            TIntObjectHashMap caretMap = new TIntObjectHashMap();
            CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caretMap.put(caret.getOffset(), (Object)caret);
            }
            for (Inlay inlay : this.myEditor.getInlayModel().getInlineElementsInRange(0, this.myDocument.getTextLength())) {
                String oldText;
                if (!presentationManager.isParameterHint(inlay)) continue;
                offset = inlay.getOffset();
                String newText = this.myAnnotations.remove(offset);
                if (this.delayRemoval(inlay, (TIntObjectHashMap<Caret>)caretMap) || Objects.equals(newText, oldText = presentationManager.getHintText(inlay))) continue;
                if (newText == null) {
                    removedHints.add(oldText);
                    presentationManager.deleteHint(this.myEditor, inlay);
                    continue;
                }
                presentationManager.replaceHint(this.myEditor, inlay, newText);
            }
            for (Map.Entry entry : this.myAnnotations.entrySet()) {
                offset = (Integer)entry.getKey();
                String text = (String)entry.getValue();
                presentationManager.addHint(this.myEditor, offset, text, !firstTime && !removedHints.contains(text));
            }
            keeper.restoreOriginalLocation();
            this.myEditor.putUserData(REPEATED_PASS, (Object)Boolean.TRUE);
        }

        private boolean delayRemoval(Inlay inlay, TIntObjectHashMap<Caret> caretMap) {
            int offset = inlay.getOffset();
            Caret caret = (Caret)caretMap.get(offset);
            if (caret == null) {
                return false;
            }
            char afterCaret = this.myEditor.getDocument().getImmutableCharSequence().charAt(offset);
            if (afterCaret != ',' && afterCaret != ')') {
                return false;
            }
            VisualPosition afterInlayPosition = this.myEditor.offsetToVisualPosition(offset, true, false);
            return caret.getVisualPosition().equals((Object)afterInlayPosition);
        }
    }
}

