/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfo;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\b\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0011\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010*\u00020\u000fH\u0002\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0007\u00a8\u0006\u0012"}, d2={"addMethodAtCaretToBlackList", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getMethodInfoAtOffset", "Lcom/intellij/codeInsight/hints/MethodInfo;", "hasParameterHintAtOffset", "", "isPossibleHintNearOffset", "offset", "", "refreshAllOpenEditors", "capitalize", "", "Lorg/jetbrains/annotations/NotNull;", "toPattern", "lang-impl"})
public final class PopupActionsKt {
    private static final String capitalize(@NotNull String $receiver) {
        return StringUtil.capitalizeWords((String)$receiver, (boolean)true);
    }

    private static final boolean hasParameterHintAtOffset(Editor editor, PsiFile file2) {
        Object v2;
        block2: {
            if (editor instanceof EditorWindow) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            PsiElement psiElement = element;
            int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
            PsiElement psiElement2 = element;
            int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
            Iterable iterable = editor.getInlayModel().getInlineElementsInRange(startOffset, endOffset);
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Inlay it = (Inlay)t;
                if (!ParameterHintsPresentationManager.getInstance().isParameterHint(it)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2 != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void refreshAllOpenEditors() {
        Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
        for (int j = 0; j < $receiver$iv.length; ++j) {
            void $receiver$iv2;
            Object element$iv = $receiver$iv[j];
            Project it = (Project)element$iv;
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            Object[] objectArray = fileEditorManager.getSelectedFiles();
            for (int k = 0; k < ((void)$receiver$iv2).length; ++k) {
                PsiFile psiFile;
                void element$iv2 = $receiver$iv2[k];
                VirtualFile it2 = (VirtualFile)element$iv2;
                if (psiManager.findFile(it2) == null) continue;
                PsiFile it3 = psiFile;
                daemonCodeAnalyzer.restart(it3);
            }
        }
    }

    private static final MethodInfo getMethodInfoAtOffset(Editor editor, PsiFile file2) {
        PsiElement method2;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)((Condition)new Condition<PsiElement>(hintsProvider){
            final /* synthetic */ InlayParameterHintsProvider $hintsProvider;

            public final boolean value(PsiElement e) {
                PsiElement psiElement = e;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"e");
                return this.$hintsProvider.getMethodInfo(psiElement) != null;
            }
            {
                this.$hintsProvider = inlayParameterHintsProvider;
            }
        }));
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = method2 = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"method");
        return hintsProvider.getMethodInfo(psiElement2);
    }

    private static final void addMethodAtCaretToBlackList(Editor editor, PsiFile file2) {
        MethodInfo methodInfo = PopupActionsKt.getMethodInfoAtOffset(editor, file2);
        if (methodInfo == null) {
            return;
        }
        MethodInfo info = methodInfo;
        ParameterNameHintsSettings parameterNameHintsSettings = ParameterNameHintsSettings.Companion.getInstance();
        Language language = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"file.language");
        parameterNameHintsSettings.addIgnorePattern(language, PopupActionsKt.toPattern(info));
        PopupActionsKt.refreshAllOpenEditors();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPossibleHintNearOffset(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return false;
        }
        InlayParameterHintsProvider hintProvider = inlayParameterHintsProvider;
        PsiElement element = file2.findElementAt(offset);
        int n = 0;
        int n2 = 3;
        if (n <= n2) {
            while (true) {
                void i2;
                if (element == null) {
                    return false;
                }
                List hints = hintProvider.getParameterHints(element);
                Collection collection = hints;
                if (!collection.isEmpty()) {
                    return true;
                }
                element = element.getParent();
                if (i2 == n2) break;
                ++i2;
            }
        }
        return false;
    }

    @NotNull
    public static final String toPattern(@NotNull MethodInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$receiver.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    @Nullable
    public static final /* synthetic */ MethodInfo access$getMethodInfoAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        return PopupActionsKt.getMethodInfoAtOffset(editor, file2);
    }

    public static final /* synthetic */ boolean access$hasParameterHintAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        return PopupActionsKt.hasParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$addMethodAtCaretToBlackList(@NotNull Editor editor, @NotNull PsiFile file2) {
        PopupActionsKt.addMethodAtCaretToBlackList(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    @NotNull
    public static final /* synthetic */ String access$capitalize(@NotNull String $receiver) {
        return PopupActionsKt.capitalize($receiver);
    }
}

