/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameHintsConfigurable
extends DialogWrapper {
    public JPanel myConfigurable;
    private EditorTextField myEditorTextField;
    private ComboBox<Language> myCurrentLanguageCombo;
    private final Language myInitiallySelectedLanguage;
    private final String myNewPreselectedItem;
    private final Map<Language, String> myBlackLists;

    public ParameterNameHintsConfigurable() {
        this(null, null);
    }

    public ParameterNameHintsConfigurable(@Nullable Language selectedLanguage, @Nullable String newPreselectedPattern) {
        super(null);
        this.myInitiallySelectedLanguage = selectedLanguage;
        this.myNewPreselectedItem = newPreselectedPattern;
        this.$$$setupUI$$$();
        this.myBlackLists = ContainerUtil.newHashMap();
        this.setTitle("Configure Parameter Name Hints Blacklist");
        this.init();
    }

    private void updateOkEnabled() {
        String text = this.myEditorTextField.getText();
        List rules = StringUtil.split((String)text, (String)"\n");
        boolean hasAnyInvalid = rules.stream().filter(e -> !e.trim().isEmpty()).map(s -> MatcherConstructor.INSTANCE.createMatcher((String)s)).anyMatch(e -> e == null);
        this.getOKAction().setEnabled(!hasAnyInvalid);
    }

    protected void doOKAction() {
        super.doOKAction();
        Language language = (Language)this.myCurrentLanguageCombo.getModel().getSelectedItem();
        this.myBlackLists.put(language, this.myEditorTextField.getText());
        this.myBlackLists.entrySet().forEach(entry -> {
            Language lang = (Language)entry.getKey();
            String text = (String)entry.getValue();
            ParameterNameHintsConfigurable.storeBlackListDiff(lang, text);
        });
    }

    private static void storeBlackListDiff(@NotNull Language language, @NotNull String text) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "storeBlackListDiff"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "storeBlackListDiff"));
        }
        Set updatedBlackList = StringUtil.split((String)text, (String)"\n").stream().filter(e -> !e.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlackList = provider.getDefaultBlackList();
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.getInstance().setBlackListDiff(language, diff);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myConfigurable;
    }

    private void createUIComponents() {
        List<Language> languages = ParameterNameHintsConfigurable.getBaseLanguagesWithProviders();
        Language selected = this.myInitiallySelectedLanguage;
        if (selected == null) {
            selected = languages.get(0);
        }
        String text = ParameterNameHintsConfigurable.getLanguageBlackList(selected);
        this.myEditorTextField = ParameterNameHintsConfigurable.createEditor(text, this.myNewPreselectedItem);
        this.myEditorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ParameterNameHintsConfigurable.this.updateOkEnabled();
            }
        });
        this.initLanguageCombo(languages, selected);
    }

    private void initLanguageCombo(List<Language> languages, Language selected) {
        ListComboBoxModel model = new ListComboBoxModel(languages);
        this.myCurrentLanguageCombo = new ComboBox((ComboBoxModel)model);
        this.myCurrentLanguageCombo.setSelectedItem((Object)selected);
        this.myCurrentLanguageCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this.myCurrentLanguageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Language language = (Language)e.getItem();
                if (e.getStateChange() == 2) {
                    ParameterNameHintsConfigurable.this.myBlackLists.put(language, ParameterNameHintsConfigurable.this.myEditorTextField.getText());
                } else if (e.getStateChange() == 1) {
                    String text = (String)ParameterNameHintsConfigurable.this.myBlackLists.get(language);
                    if (text == null) {
                        text = ParameterNameHintsConfigurable.getLanguageBlackList(language);
                    }
                    ParameterNameHintsConfigurable.this.myEditorTextField.setText(text);
                }
            }
        });
    }

    @NotNull
    private static String getLanguageBlackList(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
        }
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
            }
            return "";
        }
        Diff diff = ParameterNameHintsSettings.getInstance().getBlackListDiff(language);
        Set<String> blackList = diff.applyOn(hintsProvider.getDefaultBlackList());
        String string = StringUtil.join(blackList, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getLanguageBlackList"));
        }
        return string;
    }

    @NotNull
    private static List<Language> getBaseLanguagesWithProviders() {
        List<Language> list = Language.getRegisteredLanguages().stream().filter(lang -> lang.getBaseLanguage() == null).filter(lang -> InlayParameterHintsExtension.INSTANCE.forLanguage(lang) != null).sorted(Comparator.comparingInt(l -> l.getDisplayName().length())).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "getBaseLanguagesWithProviders"));
        }
        return list;
    }

    private static EditorTextField createEditor(@NotNull String text, @Nullable String newPreselectedItem) {
        TextRange range;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createEditor"));
        }
        if (newPreselectedItem != null) {
            text = text + "\n";
            int startOffset = text.length();
            text = text + newPreselectedItem;
            range = new TextRange(startOffset, text.length());
        } else {
            range = null;
        }
        return ParameterNameHintsConfigurable.createEditorField(text, range);
    }

    @NotNull
    private static EditorTextField createEditorField(@NotNull String text, @Nullable TextRange rangeToSelect) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createEditorField"));
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        EditorTextField field = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(200, 350));
        field.addSettingsProvider(editor -> {
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            if (rangeToSelect != null) {
                editor.getCaretModel().moveToOffset(rangeToSelect.getStartOffset());
                editor.getScrollingModel().scrollVertically(document.getTextLength() - 1);
                editor.getSelectionModel().setSelection(rangeToSelect.getStartOffset(), rangeToSelect.getEndOffset());
            }
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable", "createEditorField"));
        }
        return editorTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigurable = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        EditorTextField editorTextField = this.myEditorTextField;
        jPanel3.add((Component)((Object)editorTextField), new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html>\nNo in-line parameter name hints will be shown for methods matching any of these patterns.<br>\nPatterns are matched on fully qualified method name, parameter count and parameter names.\n<ul>\n<li><code>java.lang</code> matches all methods from <em>java.lang</em> package</li>\n<li><code>java.lang.*(*, *)</code> matches all methods from the <em>java.lang</em> package with two parameters</li>\n<li><code>(*info)</code> matches all single parameter methods where the parameter name ends with <em>info</em></li>\n<li><code>(key, value)</code> matches all methods with parameters <em>key</em> and <em>value</em></li>\n<li><code>*.put(key, value)</code> matches all <em>put</em> methods with <em>key</em> and <em>value</em> parameters\n</ul>\n</html>");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Language:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<Language> comboBox = this.myCurrentLanguageCombo;
        jPanel5.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurable;
    }
}

