/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.daemon.impl.JavaColorProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.impl.JavaElementLookupRenderer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableLookupItem
extends LookupItem<PsiVariable>
implements TypedLookupItem,
StaticallyImportable {
    @Nullable
    private final MemberLookupHelper myHelper;
    private final Color myColor;
    private final String myTailText;
    private PsiSubstitutor mySubstitutor = PsiSubstitutor.EMPTY;

    public VariableLookupItem(PsiVariable var) {
        super(var, var.getName());
        this.myHelper = null;
        this.myColor = VariableLookupItem.getInitializerColor(var);
        this.myTailText = this.getInitializerText(var);
    }

    public VariableLookupItem(PsiField field, boolean shouldImport) {
        super(field, field.getName());
        this.myHelper = new MemberLookupHelper((PsiMember)field, field.getContainingClass(), shouldImport, false);
        if (!shouldImport) {
            for (String s : JavaCompletionUtil.getAllLookupStrings((PsiMember)field)) {
                this.setLookupString(s);
            }
        }
        this.myColor = VariableLookupItem.getInitializerColor((PsiVariable)field);
        this.myTailText = this.getInitializerText((PsiVariable)field);
    }

    @Nullable
    private String getInitializerText(PsiVariable var) {
        String initText;
        if (this.myColor != null || !var.hasModifierProperty("final") || !var.hasModifierProperty("static")) {
            return null;
        }
        PsiExpression initializer = var instanceof PsiEnumConstant ? ((PsiEnumConstant)var).getArgumentList() : VariableLookupItem.getInitializer(var);
        String string = initText = initializer == null ? null : initializer.getText();
        if (StringUtil.isEmpty((String)initText)) {
            return null;
        }
        String prefix = var instanceof PsiEnumConstant ? "" : " = ";
        String suffix = var instanceof PsiEnumConstant && ((PsiEnumConstant)var).getInitializingClass() != null ? " {...}" : "";
        return StringUtil.trimLog((String)(prefix + initText + suffix), (int)30);
    }

    private static PsiExpression getInitializer(@NotNull PsiVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInsight/lookup/VariableLookupItem", "getInitializer"));
        }
        PsiElement navigationElement = var.getNavigationElement();
        if (navigationElement instanceof PsiVariable) {
            var = (PsiVariable)navigationElement;
        }
        return var instanceof PsiFieldImpl ? ((PsiFieldImpl)var).getDetachedInitializer() : var.getInitializer();
    }

    @Nullable
    private static Color getInitializerColor(@NotNull PsiVariable var) {
        PsiElement target;
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInsight/lookup/VariableLookupItem", "getInitializerColor"));
        }
        if (!JavaColorProvider.isColorType(var.getType())) {
            return null;
        }
        PsiExpression expression = VariableLookupItem.getInitializer(var);
        if (expression instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable) {
            return (Color)RecursionManager.doPreventingRecursion((Object)expression, (boolean)true, () -> VariableLookupItem.getInitializerColor((PsiVariable)target));
        }
        return JavaColorProvider.getJavaColorFromExpression((PsiElement)expression);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getSubstitutor().substitute(((PsiVariable)this.getObject()).getType());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/VariableLookupItem", "getType"));
        }
        return psiType;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/VariableLookupItem", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    public VariableLookupItem setSubstitutor(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/lookup/VariableLookupItem", "setSubstitutor"));
        }
        this.mySubstitutor = substitutor;
        return this;
    }

    @Override
    public void setShouldBeImported(boolean shouldImportStatic) {
        assert (this.myHelper != null);
        this.myHelper.setShouldBeImported(shouldImportStatic);
    }

    @Override
    public boolean canBeImported() {
        return this.myHelper != null;
    }

    @Override
    public boolean willBeImported() {
        return this.myHelper != null && this.myHelper.willBeImported();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        boolean qualify = this.myHelper != null && !this.myHelper.willBeImported();
        PsiVariable variable = (PsiVariable)this.getObject();
        String name = variable.getName();
        if (qualify && variable instanceof PsiField && ((PsiField)variable).getContainingClass() != null) {
            name = ((PsiField)variable).getContainingClass().getName() + "." + name;
        }
        presentation.setItemText(name);
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)this, presentation.isReal()));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)this));
        if (this.myHelper != null) {
            this.myHelper.renderElement(presentation, qualify, true, this.getSubstitutor());
        }
        if (this.myColor != null) {
            presentation.setTypeText("", (Icon)new ColorIcon(12, this.myColor));
        } else {
            presentation.setTypeText(this.getType().getPresentableText());
        }
        if (this.myTailText != null && StringUtil.isEmpty((String)presentation.getTailText())) {
            presentation.setTailText(this.myTailText, true);
        }
    }

    @Override
    public void handleInsert(InsertionContext context) {
        char completionChar;
        PsiElement target;
        PsiReferenceExpression ref;
        PsiVariable variable = (PsiVariable)this.getObject();
        Document document = context.getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)variable.getName());
        context.commitDocument();
        if (variable instanceof PsiField) {
            if (this.willBeImported()) {
                RangeMarker toDelete = JavaCompletionUtil.insertTemporary(context.getTailOffset(), document, " ");
                context.commitDocument();
                PsiReferenceExpression ref2 = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiReferenceExpression.class, (boolean)false);
                if (ref2 != null) {
                    if (ref2.isQualified()) {
                        return;
                    }
                    ref2.bindToElementViaStaticImport(((PsiField)variable).getContainingClass());
                    PostprocessReformattingAspect.getInstance(ref2.getProject()).doPostponedFormatting();
                }
                if (toDelete.isValid()) {
                    document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                }
                context.commitDocument();
            } else if (this.shouldQualify((PsiField)variable, context)) {
                VariableLookupItem.qualifyFieldReference(context, (PsiField)variable);
            }
        }
        if ((ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(context.getTailOffset() - 1), PsiReferenceExpression.class, (boolean)false)) != null) {
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences((PsiElement)ref);
        }
        PsiElement psiElement = target = (ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(context.getTailOffset() - 1), PsiReferenceExpression.class, (boolean)false)) == null ? null : ref.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            VariableLookupItem.makeFinalIfNeeded(context, (PsiVariable)target);
        }
        if ((completionChar = context.getCompletionChar()) == '=') {
            context.setAddCompletionChar(false);
            TailType.EQ.processTail(context.getEditor(), context.getTailOffset());
        } else if (completionChar == ',' && this.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) {
            context.setAddCompletionChar(false);
            TailType.COMMA.processTail(context.getEditor(), context.getTailOffset());
            AutoPopupController.getInstance(context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        } else if (completionChar == ':' && this.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) {
            context.setAddCompletionChar(false);
            TailType.COND_EXPR_COLON.processTail(context.getEditor(), context.getTailOffset());
        } else if (completionChar == '.') {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        } else if (completionChar == '!' && PsiType.BOOLEAN.isAssignableFrom(variable.getType())) {
            context.setAddCompletionChar(false);
            if (ref != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByExclamation");
                document.insertString(ref.getTextRange().getStartOffset(), (CharSequence)"!");
            }
        }
    }

    public static void makeFinalIfNeeded(@NotNull InsertionContext context, @NotNull PsiVariable variable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/VariableLookupItem", "makeFinalIfNeeded"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/lookup/VariableLookupItem", "makeFinalIfNeeded"));
        }
        PsiElement place = context.getFile().findElementAt(context.getTailOffset() - 1);
        if (!Registry.is((String)"java.completion.make.outer.variables.final") || place == null || PsiUtil.isLanguageLevel8OrHigher((PsiElement)place) || JspPsiUtil.isInJspFile((PsiElement)place)) {
            return;
        }
        if (HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, place) != null && !HighlightControlFlowUtil.isReassigned(variable, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)new HashMap())) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
        }
    }

    private boolean shouldQualify(PsiField field, InsertionContext context) {
        if (this.myHelper != null && !this.myHelper.willBeImported()) {
            return true;
        }
        PsiReference reference = context.getFile().findReferenceAt(context.getStartOffset());
        if (reference instanceof PsiReferenceExpression && !((PsiReferenceExpression)reference).isQualified()) {
            PsiVariable target = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper().resolveReferencedVariable(field.getName(), (PsiElement)reference);
            return !field.getManager().areElementsEquivalent((PsiElement)target, (PsiElement)CompletionUtil.getOriginalOrSelf(field));
        }
        return false;
    }

    private static void qualifyFieldReference(InsertionContext context, PsiField field) {
        context.commitDocument();
        PsiFile file2 = context.getFile();
        PsiReference reference = file2.findReferenceAt(context.getStartOffset());
        if (reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).isQualified()) {
            return;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass != null && containingClass.getName() != null) {
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)".");
            JavaCompletionUtil.insertClassReference(containingClass, file2, context.getStartOffset());
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
        }
    }
}

