/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetAbbreviationBalloon;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetLexer;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingTemplate
extends CustomLiveTemplateBase {
    public static final char MARKER = '\u0000';
    private static final String EMMET_RECENT_WRAP_ABBREVIATIONS_KEY = "emmet.recent.wrap.abbreviations";
    private static final String EMMET_LAST_WRAP_ABBREVIATIONS_KEY = "emmet.last.wrap.abbreviations";
    private static final Logger LOG = Logger.getInstance(ZenCodingTemplate.class);

    @Nullable
    public static ZenCodingGenerator findApplicableDefaultGenerator(@NotNull PsiElement context, boolean wrapping) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "findApplicableDefaultGenerator"));
        }
        if (!context.isValid()) {
            return null;
        }
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!generator.isMyContext(context, wrapping) || !generator.isAppliedByDefault(context)) continue;
            return generator;
        }
        return null;
    }

    @Nullable
    public static ZenCodingNode parse(@NotNull String text, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator, @Nullable String surroundedText) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        List<ZenCodingToken> tokens = new EmmetLexer().lex(text);
        if (tokens == null) {
            return null;
        }
        if (!ZenCodingTemplate.validate(tokens, generator)) {
            return null;
        }
        EmmetParser parser = generator.createParser(tokens, callback, generator, surroundedText != null);
        ZenCodingNode node = parser.parse();
        if (parser.getIndex() != tokens.size() || node instanceof TextNode) {
            return null;
        }
        return node;
    }

    private static boolean validate(@NotNull List<ZenCodingToken> tokens, @NotNull ZenCodingGenerator generator) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validate"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validate"));
        }
        for (ZenCodingToken token : tokens) {
            if (!(token instanceof TextToken) || generator instanceof XmlZenCodingGenerator) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTemplateKey(@NotNull String key2, CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "checkTemplateKey"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "checkTemplateKey"));
        }
        return ZenCodingTemplate.parse(key2, callback, generator, null) != null;
    }

    @Override
    public void expand(@NotNull String key2, @NotNull CustomTemplateCallback callback) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), false);
        if (defaultGenerator == null) {
            LOG.error("Cannot find defaultGenerator for key `" + key2 + "` at " + callback.getEditor().getCaretModel().getOffset() + " offset", new Attachment[]{AttachmentFactory.createAttachment(callback.getEditor().getDocument())});
            return;
        }
        try {
            ZenCodingTemplate.expand(key2, callback, defaultGenerator, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        }
        catch (EmmetException e) {
            CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)"Emmet error", (String)"");
        }
    }

    @Nullable
    private static ZenCodingGenerator findApplicableGenerator(ZenCodingNode node, PsiElement context, boolean wrapping) {
        ZenCodingGenerator[] generators;
        ZenCodingGenerator defaultGenerator = null;
        for (ZenCodingGenerator generator : generators = ZenCodingGenerator.getInstances()) {
            if (!generator.isMyContext(context, wrapping) || !generator.isAppliedByDefault(context)) continue;
            defaultGenerator = generator;
            break;
        }
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String suffix = filterNode.getFilter();
            for (ZenCodingGenerator generator : generators) {
                if (!generator.isMyContext(context, wrapping) || suffix == null || !suffix.equals(generator.getSuffix())) continue;
                return generator;
            }
            node = filterNode.getNode();
        }
        return defaultGenerator;
    }

    private static List<ZenCodingFilter> getFilters(ZenCodingNode node, PsiElement context) {
        ArrayList<ZenCodingFilter> result2 = new ArrayList<ZenCodingFilter>();
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String filterSuffix = filterNode.getFilter();
            for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
                if (!filter.isMyContext(context) || !filter.getSuffix().equals(filterSuffix)) continue;
                result2.add(filter);
            }
            node = filterNode.getNode();
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!filter.isMyContext(context) || !filter.isAppliedByDefault(context)) continue;
            result2.add(filter);
        }
        Collections.reverse(result2);
        return result2;
    }

    public static void expand(@NotNull String key2, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator defaultGenerator, @NotNull Collection<? extends ZenCodingFilter> extraFilters, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (defaultGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultGenerator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (extraFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFilters", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        ZenCodingNode node = ZenCodingTemplate.parse(key2, callback, defaultGenerator, null);
        if (node == null) {
            return;
        }
        if (node instanceof TemplateNode && key2.equals(((TemplateNode)node).getTemplateToken().getKey()) && callback.findApplicableTemplates(key2).size() > 1) {
            Map<TemplateImpl, String> template2Argument;
            TemplateManagerImpl templateManager = (TemplateManagerImpl)callback.getTemplateManager();
            Runnable runnable2 = templateManager.startNonCustomTemplates(template2Argument = templateManager.findMatchingTemplates(callback.getFile(), callback.getEditor(), null, TemplateSettings.getInstance()), callback.getEditor(), null);
            if (runnable2 != null) {
                runnable2.run();
            }
            return;
        }
        PsiElement context = callback.getContext();
        ZenCodingGenerator generator = (ZenCodingGenerator)ObjectUtils.notNull((Object)ZenCodingTemplate.findApplicableGenerator(node, context, false), (Object)defaultGenerator);
        List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
        filters.addAll(extraFilters);
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        callback.deleteTemplateKey(key2);
        ZenCodingTemplate.expand(node, generator, filters, null, callback, expandPrimitiveAbbreviations, segmentsLimit);
    }

    private static void expand(ZenCodingNode node, ZenCodingGenerator generator, List<ZenCodingFilter> filters, String surroundedText, CustomTemplateCallback callback, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        if (surroundedText != null) {
            surroundedText = surroundedText.trim();
        }
        GenerationNode fakeParentNode = new GenerationNode(TemplateToken.EMPTY_TEMPLATE_TOKEN, -1, 1, surroundedText, true, null);
        node.expand(-1, 1, surroundedText, callback, true, fakeParentNode);
        if (!expandPrimitiveAbbreviations && ZenCodingTemplate.isPrimitiveNode(node)) {
            return;
        }
        List<GenerationNode> genNodes = fakeParentNode.getChildren();
        LiveTemplateBuilder builder = new LiveTemplateBuilder(EmmetOptions.getInstance().isAddEditPointAtTheEndOfTemplate(), segmentsLimit);
        int end = -1;
        int genNodesSize = genNodes.size();
        for (int i2 = 0; i2 < genNodesSize; ++i2) {
            GenerationNode genNode = genNodes.get(i2);
            TemplateImpl template = genNode.generate(callback, generator, filters, true, segmentsLimit);
            int e = builder.insertTemplate(builder.length(), template, null);
            if (i2 < genNodesSize - 1 && genNode.isInsertNewLineBetweenNodes()) {
                builder.insertText(e, "\n", false);
                ++e;
            }
            if (end != -1 || end >= builder.length()) continue;
            end = e;
        }
        for (ZenCodingFilter filter : filters) {
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            builder.setIsToReformat(false);
            break;
        }
        callback.startTemplate(builder.buildTemplate(), null, null);
    }

    private static void checkTemplateOutputLength(ZenCodingNode node, CustomTemplateCallback callback) throws EmmetException {
        int predictedOutputLength = node.getApproximateOutputLength(callback);
        if (predictedOutputLength > 15360) {
            throw new EmmetException();
        }
    }

    private static boolean isPrimitiveNode(@NotNull ZenCodingNode node) {
        TemplateToken token;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "isPrimitiveNode"));
        }
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null) {
            Map<String, String> attributes = token.getAttributes();
            return attributes.isEmpty() || attributes.containsKey("class") && StringUtil.isEmpty((String)attributes.get("class"));
        }
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, final @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "wrap"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "wrap"));
        }
        new EmmetAbbreviationBalloon(EMMET_RECENT_WRAP_ABBREVIATIONS_KEY, EMMET_LAST_WRAP_ABBREVIATIONS_KEY, new EmmetAbbreviationBalloon.Callback(){

            @Override
            public void onEnter(@NotNull String abbreviation) {
                if (abbreviation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$1", "onEnter"));
                }
                ZenCodingTemplate.doWrap(abbreviation, callback);
            }
        }, XmlBundle.message((String)"emmet.title", (Object[])new Object[0])).show(callback);
    }

    public static boolean checkTemplateKey(String inputString, CustomTemplateCallback callback) {
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), true);
        if (generator == null) {
            int offset = callback.getEditor().getCaretModel().getOffset();
            LOG.error("Emmet is disabled for context for file " + callback.getFileType().getName() + " in offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment(callback.getEditor().getDocument())});
            return false;
        }
        return ZenCodingTemplate.checkTemplateKey(inputString, callback, generator);
    }

    @Override
    public boolean isApplicable(PsiFile file2, int offset, boolean wrapping) {
        if (file2 == null) {
            return false;
        }
        PsiElement element = CustomTemplateCallback.getContext(file2, offset);
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(element, wrapping);
        return applicableGenerator != null && applicableGenerator.isEnabled();
    }

    @Override
    public boolean hasCompletionItem(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "hasCompletionItem"));
        }
        PsiElement element = CustomTemplateCallback.getContext(file2, offset);
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(element, false);
        return applicableGenerator != null && applicableGenerator.isEnabled() && applicableGenerator.hasCompletionItem();
    }

    public static void doWrap(final @NotNull String abbreviation, final @NotNull CustomTemplateCallback callback) {
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "doWrap"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "doWrap"));
        }
        final ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), true);
        assert (defaultGenerator != null);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "lambda$doWrap$1"));
            }
            if (abbreviation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "lambda$doWrap$1"));
            }
            CommandProcessor.getInstance().executeCommand(callback.getProject(), () -> {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "lambda$null$0"));
                }
                if (abbreviation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "lambda$null$0"));
                }
                callback.getEditor().getCaretModel().runForEachCaret(new CaretAction(){

                    public void perform(Caret caret) {
                        String selectedText = callback.getEditor().getSelectionModel().getSelectedText();
                        if (selectedText != null) {
                            String selection = selectedText.trim();
                            ZenCodingNode node = ZenCodingTemplate.parse(abbreviation, callback, defaultGenerator, selection);
                            assert (node != null);
                            PsiElement context = callback.getContext();
                            ZenCodingGenerator generator = ZenCodingTemplate.findApplicableGenerator(node, context, true);
                            List filters = ZenCodingTemplate.getFilters(node, context);
                            EditorModificationUtil.deleteSelectedText((Editor)callback.getEditor());
                            PsiDocumentManager.getInstance((Project)callback.getProject()).commitAllDocuments();
                            try {
                                ZenCodingTemplate.expand(node, generator, filters, selection, callback, true, Registry.intValue((String)"emmet.segments.limit"));
                            }
                            catch (EmmetException e) {
                                CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)"Emmet error", (String)"");
                            }
                        }
                    }
                });
            }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = XmlBundle.message((String)"emmet.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "getTitle"));
        }
        return string;
    }

    @Override
    public char getShortcut() {
        return (char)EmmetOptions.getInstance().getEmmetExpandShortcut();
    }

    @Override
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "computeTemplateKey"));
        }
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), false);
        if (generator == null) {
            return null;
        }
        return generator.computeTemplateKey(callback);
    }

    @Override
    public boolean supportsWrapping() {
        return true;
    }

    @Override
    public void addCompletions(CompletionParameters parameters, CompletionResultSet result2) {
        if (!parameters.isAutoPopup()) {
            return;
        }
        PsiFile file2 = parameters.getPosition().getContainingFile();
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(CustomTemplateCallback.getContext(file2, offset), false);
        if (generator != null && generator.hasCompletionItem()) {
            CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file2);
            String templatePrefix = this.computeTemplateKeyWithoutContextChecking(callback);
            if (templatePrefix != null) {
                List<TemplateImpl> regularTemplates = TemplateManagerImpl.listApplicableTemplates(file2, offset, false);
                boolean regularTemplateWithSamePrefixExists = !ContainerUtil.filter(regularTemplates, template -> templatePrefix.equals(template.getKey())).isEmpty();
                result2 = result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(templatePrefix));
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
                if (!regularTemplateWithSamePrefixExists) {
                    LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
                    try {
                        ZenCodingTemplate.expand(templatePrefix, callback, generator, extraFilters, false, 0);
                    }
                    catch (EmmetException emmetException) {
                        // empty catch block
                    }
                    TemplateImpl template2 = callback.getGeneratedTemplate();
                    if (template2 != null) {
                        template2.setKey(templatePrefix);
                        template2.setDescription(template2.getTemplateText());
                        CustomLiveTemplateLookupElement lookupElement = new CustomLiveTemplateLookupElement(this, template2.getKey(), template2.getKey(), template2.getDescription(), !LiveTemplateCompletionContributor.shouldShowAllTemplates(), true){

                            @Override
                            public void renderElement(LookupElementPresentation presentation) {
                                super.renderElement(presentation);
                                presentation.setTailText("\t Emmet abbreviation", true);
                            }
                        };
                        result2.addElement((LookupElement)lookupElement);
                    }
                }
            } else if (result2.getPrefixMatcher().getPrefix().isEmpty()) {
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            }
        }
    }
}

