/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import org.apache.xerces.util.XML11Char;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingUtil {
    private static final char NUMBER_IN_ITERATION_PLACE_HOLDER = '$';
    private static final String SURROUNDED_TEXT_MARKER = "$#";

    private ZenCodingUtil() {
    }

    public static boolean containsSurroundedTextMarker(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/codeInsight/template/emmet/ZenCodingUtil", "containsSurroundedTextMarker"));
        }
        return s.contains(SURROUNDED_TEXT_MARKER);
    }

    public static String replaceMarkers(String s, int numberInIteration, int totalIterations, @Nullable String surroundedText) {
        String by = Integer.toString(numberInIteration + 1);
        StringBuilder builder = new StringBuilder(s.length());
        int markerStartIndex = -1;
        int n = s.length();
        for (int i2 = 0; i2 <= n; ++i2) {
            char c;
            char c2 = c = i2 < n ? s.charAt(i2) : (char)'\u0000';
            if (c == '\\' && i2 < n - 1) {
                builder.append(s.charAt(++i2));
                continue;
            }
            if (c == '$' && (i2 == n - 1 || s.charAt(i2 + 1) != '#')) {
                if (markerStartIndex != -1) continue;
                markerStartIndex = i2;
                continue;
            }
            int markersCount = i2 - markerStartIndex;
            if (markerStartIndex != -1) {
                boolean decrement = false;
                if (i2 < n && s.charAt(i2) == '@') {
                    if (++i2 < n && s.charAt(i2) == '-') {
                        decrement = true;
                        ++i2;
                    }
                    StringBuilder base = new StringBuilder();
                    while (i2 < n && Character.isDigit(s.charAt(i2))) {
                        base.append(s.charAt(i2));
                        ++i2;
                    }
                    int baseInt = StringUtil.parseInt((String)base.toString(), (int)0) - 1;
                    int n2 = baseInt = baseInt >= 0 ? baseInt : 0;
                    if (baseInt >= 0) {
                        int byInt = decrement ? totalIterations - numberInIteration : numberInIteration + 1;
                        by = Integer.toString(byInt += baseInt);
                    }
                }
                int m = markersCount - by.length();
                for (int k = 0; k < m; ++k) {
                    builder.append('0');
                }
                builder.append(by);
                markerStartIndex = -1;
                char c3 = c = i2 < n ? s.charAt(i2) : (char)'\u0000';
            }
            if (i2 >= n) continue;
            if (c == '$' && surroundedText != null) {
                builder.append(surroundedText);
                ++i2;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String getValue(String value, int numberInIteration, int totalIterations, String surroundedText) {
        String s = ZenCodingUtil.replaceMarkers(value, numberInIteration, totalIterations, surroundedText);
        return s.replace("\"", "&quot;");
    }

    public static boolean isXML11ValidQName(String str) {
        int colon = str.indexOf(58);
        if (colon == 0 || colon == str.length() - 1) {
            return false;
        }
        if (colon > 0) {
            String prefix = str.substring(0, colon);
            String localPart = str.substring(colon + 1);
            return XML11Char.isXML11ValidNCName((String)prefix) && XML11Char.isXML11ValidNCName((String)localPart);
        }
        return XML11Char.isXML11ValidNCName((String)str);
    }

    public static boolean isHtml(CustomTemplateCallback callback) {
        FileType type = callback.getFileType();
        return type == StdFileTypes.HTML || type == StdFileTypes.XHTML;
    }

    public static boolean checkFilterSuffix(@NotNull String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/template/emmet/ZenCodingUtil", "checkFilterSuffix"));
        }
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!suffix.equals(generator.getSuffix())) continue;
            return true;
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!suffix.equals(filter.getSuffix())) continue;
            return true;
        }
        return false;
    }
}

