/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.text.BlockSupport;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeMacro
extends Macro {
    public String getName() {
        return "expectedType";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.expected.type", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("A" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/ExpectedTypeMacro", "getDefaultValue"));
        }
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/ExpectedTypeMacro", "calculateResult"));
        }
        PsiType[] types = ExpectedTypeMacro.getExpectedTypes(params, context);
        if (types == null || types.length == 0) {
            return null;
        }
        return new PsiTypeResult(types[0], context.getProject());
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/ExpectedTypeMacro", "calculateLookupItems"));
        }
        PsiType[] types = ExpectedTypeMacro.getExpectedTypes(params, context);
        if (types == null || types.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set2 = new LinkedHashSet<LookupElement>();
        for (PsiType type : types) {
            JavaTemplateUtil.addTypeLookupItem(set2, type);
        }
        return set2.toArray(new LookupElement[set2.size()]);
    }

    @Nullable
    private static PsiType[] getExpectedTypes(Expression[] params, ExpressionContext context) {
        ExpectedTypeInfo[] infos;
        if (params.length != 0) {
            return null;
        }
        Project project2 = context.getProject();
        PsiType[] types = null;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        assert (file2 != null);
        PsiFile fileCopy = (PsiFile)file2.copy();
        BlockSupport.getInstance(project2).reparseRange(fileCopy, context.getTemplateStartOffset(), context.getTemplateEndOffset(), "IntellijIdeaRulezzz ");
        PsiElement element = fileCopy.findElementAt(context.getTemplateStartOffset());
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiExpression && (infos = ExpectedTypesProvider.getExpectedTypes((PsiExpression)element.getParent(), true)).length > 0) {
            types = new PsiType[infos.length];
            for (int i2 = 0; i2 < infos.length; ++i2) {
                ExpectedTypeInfo info = infos[i2];
                types[i2] = info.getType();
            }
        }
        return types;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

