/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateExpressionSelectorBase
implements PostfixTemplateExpressionSelector {
    @NotNull
    protected final Condition<PsiElement> myAdditionalCondition;
    private static final Condition<PsiElement> PSI_ERROR_FILTER = element -> !PsiTreeUtil.hasErrorElements((PsiElement)element);

    public PostfixTemplateExpressionSelectorBase(@Nullable Condition<PsiElement> condition) {
        this.myAdditionalCondition = condition != null ? condition : Conditions.alwaysTrue();
    }

    @Override
    public boolean hasExpression(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "hasExpression"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "hasExpression"));
        }
        return !this.getExpressions(context, copyDocument, newOffset).isEmpty();
    }

    protected Condition<PsiElement> getBorderOffsetFilter(int offset) {
        return element -> element.getTextRange().getEndOffset() == offset;
    }

    @Override
    @NotNull
    public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "getExpressions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "getExpressions"));
        }
        List list = ContainerUtil.filter(this.getNonFilteredExpressions(context, document, offset), this.getFilters(offset));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "getExpressions"));
        }
        return list;
    }

    @Override
    @NotNull
    public Function<PsiElement, String> getRenderer() {
        Function function = element -> element.getText();
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateExpressionSelectorBase", "getRenderer"));
        }
        return function;
    }

    protected abstract List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    protected Condition<PsiElement> getFilters(int offset) {
        return Conditions.and(this.getBorderOffsetFilter(offset), this.myAdditionalCondition);
    }

    protected Condition<PsiElement> getPsiErrorFilter() {
        return PSI_ERROR_FILTER;
    }
}

