/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.trivialif.MergeIfAndIntention;
import org.jetbrains.annotations.NotNull;

public class SurroundWithIfFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.SurroundWithIfFix");
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SurroundWithIfFix", "getName"));
        }
        return string;
    }

    public SurroundWithIfFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToAssert", "com/intellij/codeInspection/SurroundWithIfFix", "<init>"));
        }
        this.myText = expressionToAssert.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SurroundWithIfFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SurroundWithIfFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(element, false);
        LOG.assertTrue(anchorStatement != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        if (anchorStatement.getParent() instanceof PsiLambdaExpression) {
            PsiElement body = ((PsiLambdaExpression)RefactoringUtil.expandExpressionLambdaToCodeBlock(anchorStatement)).getBody();
            LOG.assertTrue(body instanceof PsiCodeBlock);
            anchorStatement = ((PsiCodeBlock)body).getStatements()[0];
        }
        if ((editor = PsiUtilBase.findEditor((PsiElement)anchorStatement)) == null) {
            return;
        }
        PsiFile file2 = anchorStatement.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = documentManager.getDocument(file2);
        if (document == null || !FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{anchorStatement};
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchorStatement, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            elements = new PsiElement[]{prev, anchorStatement};
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project2, editor, elements);
            if (textRange == null) {
                return;
            }
            String newText = this.myText + " != null";
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset() + newText.length());
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            new MergeIfAndIntention().invoke(project2, editor, file2);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SurroundWithIfFix", "getFamilyName"));
        }
        return string;
    }

    public static boolean isAvailable(PsiExpression qualifier) {
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)qualifier, PsiStatement.class);
        if (statement2 == null) {
            return false;
        }
        PsiElement parent = statement2.getParent();
        return !(parent instanceof PsiForStatement);
    }
}

