/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffects;
import com.intellij.codeInspection.bytecodeAnalysis.HEquation;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.FileBasedIndex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBytecodeAnalysis {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.bytecodeAnalysis");
    public static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getInstance"));
        }
        return (ProjectBytecodeAnalysis)ServiceManager.getService((Project)project2, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project2) {
        this.myProject = project2;
        this.nullableMethod = Registry.is((String)NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is((String)NULLABLE_METHOD_TRANSITIVITY);
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotation"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        if (!(listOwner instanceof PsiCompiledElement)) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> {
            if (listOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "lambda$findInferredAnnotations$0"));
            }
            return CachedValueProvider.Result.create((Object)this.collectInferredAnnotations(listOwner), (Object[])new Object[]{listOwner});
        });
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "findInferredAnnotations"));
        }
        return psiAnnotationArray;
    }

    private static boolean isInsideDummyAndroidJar(@Nullable PsiFile psiFile) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = psiFile == null ? null : psiFile.getVirtualFile();
        if (file2 == null) {
            return false;
        }
        String path = file2.getPath();
        int index = path.indexOf("/android.jar!/");
        return index > 0 && path.lastIndexOf("platforms/android-", index) > 0;
    }

    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        block17: {
            block16: {
                HKey primaryKey;
                block15: {
                    block13: {
                        block14: {
                            if (ProjectBytecodeAnalysis.isInsideDummyAndroidJar(listOwner.getContainingFile())) {
                                if (PsiAnnotation.EMPTY_ARRAY == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                                }
                                return PsiAnnotation.EMPTY_ARRAY;
                            }
                            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
                            primaryKey = ProjectBytecodeAnalysis.getKey(listOwner, md);
                            if (primaryKey != null) break block13;
                            if (PsiAnnotation.EMPTY_ARRAY != null) break block14;
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                        }
                        return PsiAnnotation.EMPTY_ARRAY;
                    }
                    if (!(listOwner instanceof PsiMethod)) break block15;
                    ArrayList<HKey> allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                    MethodAnnotations methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                    PsiAnnotation[] psiAnnotationArray = this.toPsi(primaryKey, methodAnnotations);
                    if (psiAnnotationArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                    }
                    return psiAnnotationArray;
                }
                if (!(listOwner instanceof PsiParameter)) break block16;
                ParameterAnnotations parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                PsiAnnotation[] psiAnnotationArray = this.toPsi(parameterAnnotations);
                if (psiAnnotationArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                }
                return psiAnnotationArray;
            }
            try {
                if (PsiAnnotation.EMPTY_ARRAY != null) break block17;
            }
            catch (EquationsLimitException e) {
                if (LOG.isDebugEnabled()) {
                    String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false, (int)Integer.MAX_VALUE);
                    LOG.debug("Too many equations for " + externalName);
                }
                if (PsiAnnotation.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                }
                return PsiAnnotation.EMPTY_ARRAY;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Throwable)e);
                if (PsiAnnotation.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
                }
                return PsiAnnotation.EMPTY_ARRAY;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectInferredAnnotations"));
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    private PsiAnnotation[] toPsi(HKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        boolean pure = methodAnnotations.pures.contains(primaryKey);
        String contractValues = methodAnnotations.contractsValues.get(primaryKey);
        String contractPsiText = null;
        if (contractValues != null) {
            contractPsiText = pure ? "value=" + contractValues + ",pure=true" : contractValues;
        } else if (pure) {
            contractPsiText = "pure=true";
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            return new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
        }
        if (nullable && psiAnnotation != null) {
            return new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
        }
        if (notNull) {
            return new PsiAnnotation[]{this.getNotNullAnnotation()};
        }
        if (nullable) {
            return new PsiAnnotation[]{this.getNullableAnnotation()};
        }
        if (psiAnnotation != null) {
            return new PsiAnnotation[]{psiAnnotation};
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    private PsiAnnotation[] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            return new PsiAnnotation[]{this.getNotNullAnnotation()};
        }
        if (parameterAnnotations.nullable) {
            return new PsiAnnotation[]{this.getNullableAnnotation()};
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache = (Map)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ConcurrentFactoryMap<String, PsiAnnotation> map = new ConcurrentFactoryMap<String, PsiAnnotation>(){

                @Nullable
                protected PsiAnnotation create(String attrs) {
                    return ProjectBytecodeAnalysis.this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")");
                }
            };
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
        return (PsiAnnotation)cache.get(contractValue);
    }

    @Nullable
    public static HKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "getKey"));
        }
        LOG.assertTrue(owner instanceof PsiCompiledElement, (Object)owner);
        if (owner instanceof PsiMethod) {
            return BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            return BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, 0), md);
        }
        return null;
    }

    public static ArrayList<HKey> collectMethodKeys(@NotNull PsiMethod method2, HKey primaryKey) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectMethodKeys"));
        }
        return BytecodeAnalysisConverter.mkInOutKeys(method2, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull HKey notNullKey) throws EquationsLimitException {
        if (notNullKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notNullKey", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadParameterAnnotations"));
        }
        HashMap<Bytes, List<HEquations>> equationsCache = new HashMap<Bytes, List<HEquations>>();
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver, equationsCache);
        Map<HKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        HKey nullableKey = new HKey(notNullKey.key, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver, equationsCache);
        Map<HKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull HKey key2, ArrayList<HKey> allKeys) throws EquationsLimitException {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "loadMethodAnnotations"));
        }
        MethodAnnotations result2 = new MethodAnnotations();
        HashMap<Bytes, List<HEquations>> equationsCache = new HashMap<Bytes, List<HEquations>>();
        Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
        PuritySolver puritySolver = new PuritySolver();
        this.collectEquations(allKeys, outSolver, equationsCache);
        this.collectPurityEquations(key2.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(Direction.Pure)), puritySolver, equationsCache);
        Map<HKey, Value> solutions = outSolver.solve();
        Map<HKey, Set<HEffectQuantum>> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParameters().length;
        BytecodeAnalysisConverter.addMethodAnnotations(solutions, result2, key2, arity);
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result2, key2, arity);
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            HKey nullableKey = key2.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(Direction.NullableOut));
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver, equationsCache);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver, equationsCache);
            }
            Map<HKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.invertStability()) == Value.Null) {
                result2.nullables.add(key2);
            }
        }
        return result2;
    }

    private void collectPurityEquations(HKey key2, PuritySolver puritySolver, Map<Bytes, List<HEquations>> cache) throws EquationsLimitException {
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        HashSet<HKey> queued = new HashSet<HKey>();
        Stack queue = new Stack();
        queue.push((Object)key2);
        queued.add(key2);
        FileBasedIndex index = FileBasedIndex.getInstance();
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            HKey hKey = (HKey)queue.pop();
            Bytes bytes = new Bytes(hKey.key);
            List hEquationss = cache.get(bytes);
            if (hEquationss == null) {
                hEquationss = index.getValues(BytecodeAnalysisIndex.NAME, (Object)bytes, librariesScope);
                cache.put(bytes, hEquationss);
            }
            for (HEquations hEquations : hEquationss) {
                boolean stable = hEquations.stable;
                for (DirectionResultPair pair : hEquations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    Set<HEffectQuantum> effects = ((HEffects)pair.hResult).effects;
                    puritySolver.addEquation(new HKey(bytes.bytes, dirKey, stable, false), effects);
                    for (HEffectQuantum effect : effects) {
                        HKey depKey;
                        if (!(effect instanceof HEffectQuantum.CallQuantum) || queued.contains(depKey = ((HEffectQuantum.CallQuantum)effect).key)) continue;
                        queue.push((Object)depKey);
                        queued.add(depKey);
                    }
                }
            }
        }
    }

    private void collectEquations(List<HKey> keys, Solver solver, @NotNull Map<Bytes, List<HEquations>> cache) throws EquationsLimitException {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectEquations"));
        }
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        HashSet<HKey> queued = new HashSet<HKey>();
        Stack queue = new Stack();
        for (HKey key2 : keys) {
            queue.push((Object)key2);
            queued.add(key2);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            HKey hKey = (HKey)queue.pop();
            Bytes bytes = new Bytes(hKey.key);
            List hEquationss = cache.get(bytes);
            if (hEquationss == null) {
                hEquationss = index.getValues(BytecodeAnalysisIndex.NAME, (Object)bytes, librariesScope);
                cache.put(bytes, hEquationss);
            }
            for (HEquations hEquations : hEquationss) {
                boolean stable = hEquations.stable;
                for (DirectionResultPair pair : hEquations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    HResult result2 = pair.hResult;
                    solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable, false), result2));
                    if (!(result2 instanceof HPending)) continue;
                    HPending pending = (HPending)result2;
                    for (HComponent component : pending.delta) {
                        for (HKey depKey : component.ids) {
                            if (queued.contains(depKey)) continue;
                            queue.push((Object)depKey);
                            queued.add(depKey);
                        }
                    }
                }
            }
        }
    }

    private void collectSingleEquation(HKey hKey, Solver solver, @NotNull Map<Bytes, List<HEquations>> cache) throws EquationsLimitException {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "collectSingleEquation"));
        }
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        ProgressManager.checkCanceled();
        Bytes bytes = new Bytes(hKey.key);
        List hEquationss = cache.get(bytes);
        if (hEquationss == null) {
            hEquationss = index.getValues(BytecodeAnalysisIndex.NAME, (Object)bytes, librariesScope);
            cache.put(bytes, hEquationss);
        }
        for (HEquations hEquations : hEquationss) {
            boolean stable = hEquations.stable;
            for (DirectionResultPair pair : hEquations.results) {
                int dirKey = pair.directionKey;
                if (dirKey != hKey.dirKey) continue;
                HResult result2 = pair.hResult;
                solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable, false), result2));
            }
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.myProject).createAnnotationFromText(text, null);
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ProjectBytecodeAnalysis", "createAnnotationFromText"));
        }
        return psiAnnotation;
    }
}

