/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.canBeFinal.CanBeFinalAnnotator;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanBeFinalInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.canBeFinal.CanBeFinalInspection");
    public boolean REPORT_CLASSES;
    public boolean REPORT_METHODS;
    public boolean REPORT_FIELDS = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.can.be.final.display.name", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "CanBeFinal";
    @NonNls
    private static final String QUICK_FIX_NAME = InspectionsBundle.message((String)"inspection.can.be.final.accept.quickfix", (Object[])new Object[0]);

    public boolean isReportClasses() {
        return this.REPORT_CLASSES;
    }

    public boolean isReportMethods() {
        return this.REPORT_METHODS;
    }

    public boolean isReportFields() {
        return this.REPORT_FIELDS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "getAnnotator"));
        }
        return new CanBeFinalAnnotator(refManager);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "checkElement"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "checkElement"));
        }
        if (refEntity instanceof RefJavaElement) {
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (refElement instanceof RefParameter) {
                return null;
            }
            if (!refElement.isReferenced()) {
                return null;
            }
            if (refElement.isSyntheticJSP()) {
                return null;
            }
            if (refElement.isFinal()) {
                return null;
            }
            if (!((RefElementImpl)refElement).checkFlag(CanBeFinalAnnotator.CAN_BE_FINAL_MASK)) {
                return null;
            }
            PsiMember psiMember = (PsiMember)refElement.getElement();
            if (psiMember == null || !CanBeFinalHandler.allowToBeFinal(psiMember)) {
                return null;
            }
            PsiIdentifier psiIdentifier = null;
            if (refElement instanceof RefClass) {
                RefClass refClass = (RefClass)refElement;
                if (refClass.isInterface() || refClass.isAnonymous() || refClass.isAbstract()) {
                    return null;
                }
                if (!this.isReportClasses()) {
                    return null;
                }
                psiIdentifier = ((PsiClass)psiMember).getNameIdentifier();
            } else if (refElement instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)refElement;
                if (refMethod.getOwnerClass().isFinal()) {
                    return null;
                }
                if (!this.isReportMethods()) {
                    return null;
                }
                psiIdentifier = ((PsiMethod)psiMember).getNameIdentifier();
            } else if (refElement instanceof RefField) {
                if (!this.isReportFields()) {
                    return null;
                }
                psiIdentifier = ((PsiField)psiMember).getNameIdentifier();
            }
            if (psiIdentifier != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiIdentifier, InspectionsBundle.message((String)"inspection.export.results.can.be.final.description", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "queryExternalUsagesRequests"));
        }
        if (problemsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsProcessor", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "queryExternalUsagesRequests"));
        }
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints()) {
            problemsProcessor.ignoreElement((RefEntity)entryPoint);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$1", "visitElement"));
                }
                if (problemsProcessor.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitMethod(final @NotNull RefMethod refMethod) {
                        if (refMethod == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$1$1", "visitMethod"));
                        }
                        if (!(refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    ((RefElementImpl)refMethod).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    }

                    public void visitClass(final @NotNull RefClass refClass) {
                        if (refClass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$1$1", "visitClass"));
                        }
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, new GlobalJavaInspectionContext.DerivedClassesProcessor(){

                                public boolean process(PsiClass inheritor) {
                                    ((RefClassImpl)refClass).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refClass);
                                    return false;
                                }
                            });
                        }
                    }

                    public void visitField(final @NotNull RefField refField) {
                        if (refField == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$1$1", "visitField"));
                        }
                        globalContext.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                            public boolean process(PsiReference psiReference) {
                                PsiElement expression = psiReference.getElement();
                                if (expression instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression))) {
                                    ((RefFieldImpl)refField).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refField);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        });
        return false;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggested(null);
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;

        public AcceptSuggested(RefManager manager) {
            this.myManager = manager;
        }

        @NotNull
        public String getFamilyName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/canBeFinal/CanBeFinalInspection$AcceptSuggested", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            PsiModifierListOwner psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
            if (psiElement != null) {
                RefJavaElement refElement = (RefJavaElement)(this.myManager != null ? this.myManager.getReference((PsiElement)psiElement) : null);
                try {
                    if (psiElement instanceof PsiVariable) {
                        ((PsiVariable)psiElement).normalizeDeclaration();
                    }
                    PsiModifierList modifierList = psiElement.getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", true);
                    modifierList.setModifierProperty("volatile", false);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (refElement != null) {
                    RefJavaUtil.getInstance().setIsFinal(refElement, true);
                }
            }
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportClassesCheckbox;
        private final JCheckBox myReportMethodsCheckbox;
        private final JCheckBox myReportFieldsCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportClassesCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option", (Object[])new Object[0]));
            this.myReportClassesCheckbox.setSelected(CanBeFinalInspection.this.REPORT_CLASSES);
            this.myReportClassesCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_CLASSES = OptionsPanel.this.myReportClassesCheckbox.isSelected();
                }
            });
            gc.gridy = 0;
            this.add((Component)this.myReportClassesCheckbox, gc);
            this.myReportMethodsCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option1", (Object[])new Object[0]));
            this.myReportMethodsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_METHODS);
            this.myReportMethodsCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_METHODS = OptionsPanel.this.myReportMethodsCheckbox.isSelected();
                }
            });
            ++gc.gridy;
            this.add((Component)this.myReportMethodsCheckbox, gc);
            this.myReportFieldsCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.can.be.final.option2", (Object[])new Object[0]));
            this.myReportFieldsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_FIELDS);
            this.myReportFieldsCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CanBeFinalInspection.this.REPORT_FIELDS = OptionsPanel.this.myReportFieldsCheckbox.isSelected();
                }
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportFieldsCheckbox, gc);
        }
    }
}

