/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.InferredAnnotationsManagerImpl;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.ContractInspection;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditContractIntention
extends BaseIntentionAction
implements LowPriorityAction {
    private static final String ourPrompt = "<html>Please specify the contract text<p>Example: <code>_, null -> false</code><br><small>See intention action description for more details</small></html>";

    @NotNull
    public String getFamilyName() {
        if ("Edit method contract" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/EditContractIntention", "getFamilyName"));
        }
        return "Edit method contract";
    }

    @Nullable
    private static PsiMethod getTargetMethod(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "getTargetMethod"));
        }
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner instanceof PsiMethod && ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            PsiElement original = owner.getOriginalElement();
            return original instanceof PsiMethod ? (PsiMethod)original : (PsiMethod)owner;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "isAvailable"));
        }
        PsiMethod method2 = EditContractIntention.getTargetMethod(project2, editor, file2);
        if (method2 != null) {
            boolean hasContract = ControlFlowAnalyzer.findContractAnnotation(method2) != null;
            this.setText(hasContract ? "Edit method contract of '" + method2.getName() + "'" : "Add method contract to '" + method2.getName() + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "invoke"));
        }
        final PsiMethod method2 = EditContractIntention.getTargetMethod(project2, editor, file2);
        assert (method2 != null);
        Contract existingAnno = (Contract)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method2, Contract.class);
        String oldContract = existingAnno == null ? null : existingAnno.value();
        boolean oldPure = existingAnno != null && existingAnno.pure();
        final JBTextField contractText = new JBTextField(oldContract);
        JCheckBox pureCB = EditContractIntention.createPureCheckBox(oldPure);
        final DialogBuilder builder = EditContractIntention.createDialog(project2, contractText, pureCB);
        contractText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String error = EditContractIntention.getErrorMessage(contractText.getText(), method2);
                builder.setOkActionEnabled(error == null);
                builder.setErrorText(error);
            }
        });
        if (builder.showAndGet()) {
            EditContractIntention.updateContract(method2, contractText.getText(), pureCB.isSelected());
        }
    }

    private static DialogBuilder createDialog(@NotNull Project project2, JBTextField contractText, JCheckBox pureCB) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/EditContractIntention", "createDialog"));
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)ourPrompt), "North");
        panel2.add((Component)contractText, "Center");
        panel2.add((Component)pureCB, "South");
        DialogBuilder builder = new DialogBuilder(project2).setNorthPanel((JComponent)panel2).title("Edit Method Contract");
        builder.setPreferredFocusComponent((JComponent)contractText);
        return builder;
    }

    private static JCheckBox createPureCheckBox(boolean selected) {
        NonFocusableCheckBox pureCB = new NonFocusableCheckBox("Method is pure (has no side effects)");
        pureCB.setMnemonic('p');
        pureCB.setSelected(selected);
        return pureCB;
    }

    private static void updateContract(PsiMethod method2, String contract, boolean pure) {
        Project project2 = method2.getProject();
        WriteAction.run(() -> {
            ExternalAnnotationsManager manager = ExternalAnnotationsManager.getInstance((Project)project2);
            manager.deannotate((PsiModifierListOwner)method2, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT);
            PsiAnnotation mockAnno = InferredAnnotationsManagerImpl.createContractAnnotation(project2, pure, contract);
            if (mockAnno != null) {
                manager.annotateExternally((PsiModifierListOwner)method2, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, method2.getContainingFile(), mockAnno.getParameterList().getAttributes());
            }
        });
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }

    @Nullable
    private static String getErrorMessage(String contract, PsiMethod method2) {
        return StringUtil.isEmpty((String)contract) ? null : ContractInspection.checkContract(method2, contract);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

