/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceFromSourceUtil {
    static boolean shouldInferFromSource(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "shouldInferFromSource"));
        }
        if (method2 instanceof SyntheticElement || method2 instanceof LightElement) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method2, () -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "lambda$shouldInferFromSource$0"));
            }
            return CachedValueProvider.Result.create((Object)InferenceFromSourceUtil.calcShouldInferFromSource(method2), (Object[])new Object[]{method2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean calcShouldInferFromSource(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "calcShouldInferFromSource"));
        }
        if (InferenceFromSourceUtil.isLibraryCode(method2) || method2.hasModifierProperty("abstract") || PsiUtil.canBeOverriden((PsiMethod)method2) || method2.getBody() == null) {
            return false;
        }
        if (method2.hasModifierProperty("static")) {
            return true;
        }
        return !InferenceFromSourceUtil.isUnusedInAnonymousClass(method2);
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "isUnusedInAnonymousClass"));
        }
        PsiClass containingClass = method2.getContainingClass();
        if (!(containingClass instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method2.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method2, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "isLibraryCode"));
        }
        if (method2 instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method2);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method2.getProject()).isInLibrarySource(virtualFile);
    }

    static boolean isReturnTypeCompatible(@Nullable PsiType returnType, @NotNull MethodContract.ValueConstraint returnValue) {
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil", "isReturnTypeCompatible"));
        }
        if (returnValue == MethodContract.ValueConstraint.ANY_VALUE || returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            return true;
        }
        if (PsiType.VOID.equals((Object)returnType)) {
            return false;
        }
        if (PsiType.BOOLEAN.equals((Object)returnType)) {
            return returnValue == MethodContract.ValueConstraint.TRUE_VALUE || returnValue == MethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (!(returnType instanceof PsiPrimitiveType)) {
            return returnValue == MethodContract.ValueConstraint.NULL_VALUE || returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        return false;
    }

    static boolean suppressNullable(PsiMethod method2) {
        if (method2.getParameterList().getParametersCount() == 0) {
            return false;
        }
        for (MethodContract contract : ControlFlowAnalyzer.getMethodContracts(method2)) {
            if (contract.returnValue != MethodContract.ValueConstraint.NULL_VALUE) continue;
            return true;
        }
        return false;
    }
}

