/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SideEffectFilter
extends PreContract {
    private final List<PsiExpression> myExpressionsToCheck;
    private final List<PreContract> myContracts;

    SideEffectFilter(List<PsiExpression> expressionsToCheck, List<PreContract> contracts) {
        this.myExpressionsToCheck = expressionsToCheck;
        this.myContracts = contracts;
    }

    @Override
    @NotNull
    List<MethodContract> toContracts(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/SideEffectFilter", "toContracts"));
        }
        if (ContainerUtil.exists(this.myExpressionsToCheck, d -> SideEffectChecker.mayHaveSideEffects(d))) {
            List<MethodContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/SideEffectFilter", "toContracts"));
            }
            return list;
        }
        List list = ContainerUtil.concat(this.myContracts, c -> {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/SideEffectFilter", "lambda$toContracts$1"));
            }
            return c.toContracts(method2);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/SideEffectFilter", "toContracts"));
        }
        return list;
    }
}

