/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends Instruction {
    @Nullable
    private final PsiCall myCall;
    @Nullable
    private final PsiType myType;
    @NotNull
    private final PsiExpression[] myArgs;
    private final boolean myShouldFlushFields;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiMethod myTargetMethod;
    private final List<MethodContract> myContracts;
    private final MethodType myMethodType;
    @Nullable
    private final DfaValue myPrecalculatedReturnValue;
    private final boolean myOfNullable;
    private final boolean myVarArgCall;
    private final Map<PsiExpression, Nullness> myArgRequiredNullability;
    private boolean myOnlyNullArgs;
    private boolean myOnlyNotNullArgs;

    public MethodCallInstruction(@NotNull PsiExpression context, MethodType methodType, @Nullable PsiType resultType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "<init>"));
        }
        this.myOnlyNullArgs = true;
        this.myOnlyNotNullArgs = true;
        this.myContext = context;
        this.myContracts = Collections.emptyList();
        this.myMethodType = methodType;
        this.myCall = null;
        this.myArgs = PsiExpression.EMPTY_ARRAY;
        this.myType = resultType;
        this.myShouldFlushFields = false;
        this.myPrecalculatedReturnValue = null;
        this.myTargetMethod = null;
        this.myVarArgCall = false;
        this.myOfNullable = false;
        this.myArgRequiredNullability = Collections.emptyMap();
    }

    public MethodCallInstruction(@NotNull PsiCall call, @Nullable DfaValue precalculatedReturnValue, List<MethodContract> contracts) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "<init>"));
        }
        this.myOnlyNullArgs = true;
        this.myOnlyNotNullArgs = true;
        this.myContext = call;
        this.myContracts = contracts;
        this.myMethodType = MethodType.REGULAR_METHOD_CALL;
        this.myCall = call;
        PsiExpressionList argList = call.getArgumentList();
        this.myArgs = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        this.myType = this.myCall instanceof PsiCallExpression ? ((PsiCallExpression)this.myCall).getType() : null;
        JavaResolveResult result2 = call.resolveMethodGenerics();
        this.myTargetMethod = (PsiMethod)result2.getElement();
        PsiSubstitutor substitutor = result2.getSubstitutor();
        if (argList != null && this.myTargetMethod != null) {
            PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
            this.myVarArgCall = MethodCallInstruction.isVarArgCall(this.myTargetMethod, substitutor, this.myArgs, parameters);
            this.myArgRequiredNullability = this.calcArgRequiredNullability(substitutor, parameters);
        } else {
            this.myVarArgCall = false;
            this.myArgRequiredNullability = Collections.emptyMap();
        }
        this.myShouldFlushFields = (!(call instanceof PsiNewExpression) || this.myType == null || this.myType.getArrayDimensions() <= 0) && !this.isPureCall();
        this.myPrecalculatedReturnValue = precalculatedReturnValue;
        this.myOfNullable = call instanceof PsiMethodCallExpression && DfaOptionalSupport.resolveOfNullable((PsiMethodCallExpression)call) != null;
    }

    private Map<PsiExpression, Nullness> calcArgRequiredNullability(PsiSubstitutor substitutor, PsiParameter[] parameters) {
        int checkedCount = Math.min(this.myArgs.length, parameters.length) - (this.myVarArgCall ? 1 : 0);
        HashMap map = ContainerUtil.newHashMap();
        for (int i2 = 0; i2 < checkedCount; ++i2) {
            map.put(this.myArgs[i2], DfaPsiUtil.getElementNullability(substitutor.substitute(parameters[i2].getType()), (PsiModifierListOwner)parameters[i2]));
        }
        return map;
    }

    public static boolean isVarArgCall(PsiMethod method2, PsiSubstitutor substitutor, PsiExpression[] args, PsiParameter[] parameters) {
        PsiType lastArgType;
        if (!method2.isVarArgs()) {
            return false;
        }
        int argCount = args.length;
        int paramCount = parameters.length;
        if (argCount > paramCount) {
            return true;
        }
        return paramCount > 0 && argCount == paramCount && (lastArgType = args[argCount - 1].getType()) != null && !substitutor.substitute(parameters[paramCount - 1].getType()).isAssignableFrom(lastArgType);
    }

    private boolean isPureCall() {
        if (this.myTargetMethod == null) {
            return false;
        }
        return ControlFlowAnalyzer.isPure(this.myTargetMethod);
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    @NotNull
    public PsiExpression[] getArgs() {
        if (this.myArgs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "getArgs"));
        }
        return this.myArgs;
    }

    public MethodType getMethodType() {
        return this.myMethodType;
    }

    public boolean shouldFlushFields() {
        return this.myShouldFlushFields;
    }

    @Nullable
    public PsiMethod getTargetMethod() {
        return this.myTargetMethod;
    }

    public boolean isVarArgCall() {
        return this.myVarArgCall;
    }

    @Nullable
    public Nullness getArgRequiredNullability(@NotNull PsiExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "getArgRequiredNullability"));
        }
        return this.myArgRequiredNullability.get(arg);
    }

    public List<MethodContract> getContracts() {
        return this.myContracts;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitMethodCall(this, runner, stateBefore);
    }

    @Nullable
    public PsiCall getCallExpression() {
        return this.myCall;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "getContext"));
        }
        return psiElement;
    }

    @Nullable
    public DfaValue getPrecalculatedReturnValue() {
        return this.myPrecalculatedReturnValue;
    }

    public String toString() {
        return this.myMethodType == MethodType.UNBOXING ? "UNBOX" : (this.myMethodType == MethodType.BOXING ? "BOX" : "CALL_METHOD: " + (this.myCall == null ? "null" : this.myCall.getText()));
    }

    public boolean updateOfNullable(DfaMemoryState memState, DfaValue arg) {
        if (!this.myOfNullable) {
            return false;
        }
        if (!memState.isNotNull(arg)) {
            this.myOnlyNotNullArgs = false;
        }
        if (!memState.isNull(arg)) {
            this.myOnlyNullArgs = false;
        }
        return true;
    }

    public boolean isOptionalAlwaysNullProblem() {
        return this.myOfNullable && this.myOnlyNullArgs;
    }

    public boolean isOptionalAlwaysNotNullProblem() {
        return this.myOfNullable && this.myOnlyNotNullArgs;
    }

    public static enum MethodType {
        BOXING,
        UNBOXING,
        REGULAR_METHOD_CALL,
        CAST;

    }
}

