/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambda;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaParameterTypeInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + RedundantLambdaParameterTypeInspection.class.getName()));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitParameterList(PsiParameterList parameterList) {
                super.visitParameterList(parameterList);
                if (RedundantLambdaParameterTypeInspection.isApplicable(parameterList)) {
                    holder.registerProblem((PsiElement)parameterList, "Lambda parameter type is redundant", new LocalQuickFix[]{new LambdaParametersFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isApplicable(@NotNull PsiParameterList parameterList) {
        PsiParameter[] parameters;
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection", "isApplicable"));
        }
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiLambdaExpression expression = (PsiLambdaExpression)parent;
        for (PsiParameter parameter : parameters = parameterList.getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        if (parameters.length == 0) {
            return false;
        }
        PsiType functionalInterfaceType = LambdaUtil.getFunctionalInterfaceType((PsiElement)expression, (boolean)true);
        if (functionalInterfaceType != null) {
            PsiElement gParent;
            PsiElement lambdaParent = expression.getParent();
            if (lambdaParent instanceof PsiExpressionList && (gParent = lambdaParent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArguments().length == 0) {
                PsiType paramType;
                JavaResolveResult resolveResult = ((PsiCallExpression)gParent).resolveMethodGenerics();
                PsiMethod method2 = (PsiMethod)resolveResult.getElement();
                if (method2 == null) {
                    return false;
                }
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)lambdaParent), (PsiElement)expression);
                if (idx < 0) {
                    return false;
                }
                PsiTypeParameter[] typeParameters = method2.getTypeParameters();
                PsiExpression[] arguments = ((PsiExpressionList)lambdaParent).getExpressions();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)parameterList.getProject());
                arguments[idx] = javaPsiFacade.getElementFactory().createExpressionFromText("(" + StringUtil.join((Object[])expression.getParameterList().getParameters(), PomNamedTarget::getName, (String)", ") + ") -> {}", (PsiElement)expression);
                PsiParameter[] methodParams = method2.getParameterList().getParameters();
                PsiSubstitutor substitutor = javaPsiFacade.getResolveHelper().inferTypeArguments(typeParameters, methodParams, arguments, ((MethodCandidateInfo)resolveResult).getSiteSubstitutor(), gParent, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
                for (PsiTypeParameter parameter : typeParameters) {
                    PsiType psiType = substitutor.substitute(parameter);
                    if (psiType != null && !RedundantLambdaParameterTypeInspection.dependsOnTypeParams(psiType, expression, parameter)) continue;
                    return false;
                }
                if (idx < methodParams.length) {
                    paramType = methodParams[idx].getType();
                } else {
                    PsiParameter lastParam = methodParams[methodParams.length - 1];
                    if (!lastParam.isVarArgs()) {
                        return false;
                    }
                    paramType = ((PsiEllipsisType)lastParam.getType()).getComponentType();
                }
                return functionalInterfaceType.isAssignableFrom(substitutor.substitute(paramType));
            }
            return LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)expression, (PsiType)functionalInterfaceType);
        }
        return false;
    }

    private static void removeTypes(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            Object[] parameters = lambdaExpression.getParameterList().getParameters();
            String text = parameters.length == 1 ? parameters[0].getName() : "(" + StringUtil.join((Object[])parameters, PomNamedTarget::getName, (String)", ") + ")";
            PsiLambdaExpression expression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)lambdaExpression.getProject()).createExpressionFromText(text + "->{}", (PsiElement)lambdaExpression);
            lambdaExpression.getParameterList().replace((PsiElement)expression.getParameterList());
        }
    }

    private static boolean dependsOnTypeParams(PsiType type, PsiLambdaExpression expr, PsiTypeParameter param2Check) {
        return LambdaUtil.depends((PsiType)type, (LambdaUtil.TypeParamsChecker)new LambdaUtil.TypeParamsChecker((PsiElement)expr, PsiUtil.resolveGenericsClassInType((PsiType)LambdaUtil.getFunctionalInterfaceType((PsiElement)expr, (boolean)false)).getElement()), (PsiTypeParameter[])new PsiTypeParameter[]{param2Check});
    }

    private static class LambdaParametersFix
    implements LocalQuickFix {
        private LambdaParametersFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Remove redundant parameter types" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection$LambdaParametersFix", "getFamilyName"));
            }
            return "Remove redundant parameter types";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection$LambdaParametersFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/lambda/RedundantLambdaParameterTypeInspection$LambdaParametersFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiLambdaExpression) {
                RedundantLambdaParameterTypeInspection.removeTypes((PsiLambdaExpression)parent);
            }
        }
    }
}

