/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class ReplaceWithCountFix
extends MigrateToStreamFix {
    ReplaceWithCountFix() {
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with count()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithCountFix", "getFamilyName"));
        }
        return "Replace with count()";
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithCountFix", "migrate"));
        }
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithCountFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithCountFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithCountFix", "migrate"));
        }
        PsiExpression operand = StreamApiMigrationInspection.extractIncrementedLValue(tb.getSingleExpression(PsiExpression.class));
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        StringBuilder builder = ReplaceWithCountFix.generateStream(tb.getLastOperation()).append(".count()");
        return ReplaceWithCountFix.replaceWithNumericAddition(project2, loopStatement, (PsiVariable)var, builder, (PsiType)PsiType.LONG);
    }
}

