/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithFindFirstFix
extends MigrateToStreamFix {
    ReplaceWithFindFirstFix() {
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with findFirst()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "getFamilyName"));
        }
        return "Replace with findFirst()";
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        PsiExpression initializer;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        PsiStatement statement2 = tb.getSingleStatement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        StringBuilder builder = ReplaceWithFindFirstFix.generateStream(tb.getLastOperation());
        String stream = builder.append(".findFirst()").toString();
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression value = returnStatement.getReturnValue();
            if (value == null) {
                return null;
            }
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)loopStatement);
            if (nextReturnStatement == null) {
                return null;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(orElseExpression)) {
                return null;
            }
            stream = ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, orElseExpression, null);
            ReplaceWithFindFirstFix.restoreComments(loopStatement, body);
            boolean sibling = nextReturnStatement.getParent() == loopStatement.getParent();
            PsiElement replacement = loopStatement.replace((PsiElement)elementFactory.createStatementFromText("return " + stream + ";", (PsiElement)loopStatement));
            if (sibling || !ReplaceWithFindFirstFix.isReachable(nextReturnStatement)) {
                nextReturnStatement.delete();
            }
            return replacement;
        }
        PsiStatement[] statements = tb.getStatements();
        if (statements.length != 2) {
            return null;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        if (assignment == null) {
            if (!(statements[0] instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
            ReplaceWithFindFirstFix.restoreComments(loopStatement, body);
            return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(stream + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)tb.getVariable(), (PsiExpression)expression) + ");", (PsiElement)loopStatement));
        }
        PsiExpression lValue = assignment.getLExpression();
        if (!(lValue instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lValue).resolve();
        if (!(element instanceof PsiVariable)) {
            return null;
        }
        PsiVariable var = (PsiVariable)element;
        PsiExpression value = assignment.getRExpression();
        if (value == null) {
            return null;
        }
        ReplaceWithFindFirstFix.restoreComments(loopStatement, body);
        StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, (PsiStatement)loopStatement);
        if (status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN && (initializer = var.getInitializer()) != null) {
            String replacementText = ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, initializer, var.getType());
            return ReplaceWithFindFirstFix.replaceInitializer(loopStatement, var, initializer, replacementText, status);
        }
        PsiAssignmentExpression previousAssignment = ExpressionUtils.getAssignment(PsiTreeUtil.skipSiblingsBackward((PsiElement)loopStatement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}));
        if (previousAssignment != null) {
            PsiExpression prevRValue = previousAssignment.getRExpression();
            PsiExpression prevLValue = previousAssignment.getLExpression();
            if (prevRValue != null && prevLValue instanceof PsiReferenceExpression && ((PsiReferenceExpression)prevLValue).isReferenceTo((PsiElement)var)) {
                previousAssignment.delete();
                return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + " = " + ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, prevRValue, var.getType()) + ";", (PsiElement)loopStatement));
            }
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + " = " + ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, lValue, var.getType()) + ";", (PsiElement)loopStatement));
    }

    private static String generateOptionalUnwrap(String stream, @NotNull StreamApiMigrationInspection.TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression, PsiType targetType) {
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "generateOptionalUnwrap"));
        }
        PsiVariable var = tb.getVariable();
        if (!StreamApiMigrationInspection.isIdentityMapping(var, trueExpression)) {
            PsiConditionalExpression condition;
            PsiExpression elseExpression;
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (trueExpression instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)trueExpression).getCastType()) != null && StreamApiMigrationInspection.isIdentityMapping(var, castExpression.getOperand())) {
                return "(" + castType.getText() + ")" + stream + ".orElse(null)";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.FALSE) && PsiType.BOOLEAN.equals((Object)trueExpression.getType())) {
                return stream + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ").isPresent()";
            }
            if (trueExpression instanceof PsiConditionalExpression && (elseExpression = (condition = (PsiConditionalExpression)trueExpression).getElseExpression()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)elseExpression)) {
                return ReplaceWithFindFirstFix.generateOptionalUnwrap(stream + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)condition.getCondition()) + ")", tb, condition.getThenExpression(), falseExpression, targetType);
            }
            trueExpression = targetType == null ? trueExpression : RefactoringUtil.convertInitializerToNormalExpression(trueExpression, targetType);
            stream = stream + ".map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
        }
        stream = stream + ".orElse(" + falseExpression.getText() + ")";
        return stream;
    }
}

